! ==============================================================================
! Subroutine: SETUPMPI
! 
! Purpose: Initalizes MPI and finds the processor number of each machine.
!
! Method:
!
! Arguments:
!
! History:
!
! Version    Date         Comment
! --------   ----------   -----------------------
!            10/01/2010   Original Code
!
! Dependancies:
!
! Modules -
! Functions -
! Subroutines - MPI_INIT, MPI_COMM_RANK, MPI_COMM_SIZE
!
! Author(s): Eric Dykeman
!
! ==============================================================================

      SUBROUTINE SETUPMPI

        USE SystemParam, ONLY : mpijob,myproc,nproc

        IMPLICIT NONE

        INCLUDE 'mpif.h'

        !=== ARGUMENTS ===!

        !=== VARIABLES ===!

        INTEGER :: ierr 


        mpijob = .true.

        CALL MPI_INIT (ierr)

        IF ( ierr /= 0 ) THEN

          WRITE(*,*)'ERROR: MPI failed to initialize.'
          WRITE(*,*)'MPI error code -- ierr = ',ierr

          STOP

        ENDIF

        CALL MPI_COMM_RANK (mpi_comm_world,myproc,ierr)

        IF ( ierr /= 0 ) THEN

          WRITE(*,*)'ERROR: MPI_COMM_RANK returned an error.'
          WRITE(*,*)'MPI error code -- ierr = ',ierr

          STOP

        ENDIF

        CALL MPI_COMM_SIZE (mpi_comm_world,nproc,ierr)

        IF ( ierr /= 0 ) THEN

          WRITE(*,*)'ERROR: MPI_COMM_SIZE returned an error.'
          WRITE(*,*)'MPI error code -- ierr = ',ierr

          STOP

        ENDIF

        RETURN

      END SUBROUTINE SETUPMPI
