! ==============================================================================
! Subroutine: EWALDBETA
! 
! Purpose: Computes the Beta coefficent required for an Ewald sum based on
!          the real space cutoff and tolerance for electrostatic energy.
!
! Method: Uses a recursion to find BETA to a tolerance of 2^-50 ~ 1E-15
!
! Arguments:
!
!           CUT  - Real space cutoff for electrostatic interactions.
!           TOLE - Tolerance for direct and reciprocal Ewald sums.
!           BETA - Ewald beta factor.
!
! History:
!
! Version    Date         Comment
! --------   ----------   -----------------------
!            10/01/2010   Original Code
!
! Dependancies:
!
! Modules - SystemParam
! Functions - DERFC
! Subroutines -
!
! Author(s): Eric Dykeman
!
! ==============================================================================

      SUBROUTINE EWALDBETA

        USE SystemParam, ONLY : cut,tole,beta

        IMPLICIT NONE

        !=== ARGUMENTS ==!

        !=== VARIABLES ===!

        INTEGER :: i,j

        DOUBLE PRECISION :: blo,bhi,bm,arg


        !=== Bracket Solution ===!

        i = 1
        bhi = 1.0d0
        arg = bhi * cut
        arg = DERFC(arg) / cut

        DO WHILE ( arg > tole )

          i = i + 1
          bhi = 2.0d0 * bhi
          arg = bhi * cut
          arg = DERFC(arg) / cut

        ENDDO

        !=== Find Ewald Beta Factor ===!

        j = i + 50
        blo = 0.0d0

        DO i=1,j

          bm = 0.50d0 * ( blo + bhi )
          arg = bm * cut
          arg = DERFC(arg) / cut

          IF ( arg > tole ) THEN

            blo = bm

          ELSE

            bhi = bm

          ENDIF

        ENDDO

        beta = bm

        RETURN

      END SUBROUTINE EWALDBETA
