! ==============================================================================
! Program: BIOMT
! 
! Description: Applies a series of rotations and translations to the
!              asymmetric unit of a symmetric molecule in order to generate
!              the full molecule.
!
! Notes:
!
! History:
!
! Version    Date         Comment
! --------   ----------   -----------------------
!            10/01/2010   Original Code
!
! Dependancies:
!
! Modules -
! Functions -
! Subroutines -
!
! Author(s): Eric Dykeman
!
! ==============================================================================

      PROGRAM BIOMT

        IMPLICIT NONE

        INTEGER, DIMENSION(:), ALLOCATABLE :: iwrk,itype
        DOUBLE PRECISION, DIMENSION(:,:), ALLOCATABLE :: rat,r1,gt
        DOUBLE PRECISION, DIMENSION(:,:,:), ALLOCATABLE :: grot

        INTEGER :: i,j,ifmt,nat,ngrp,ntot
        DOUBLE PRECISION :: x(3),xsq
        CHARACTER (LEN=70) :: gf2kfile,symfile,outfile

        DOUBLE PRECISION, PARAMETER :: tol = 1.00000d-6


        !=== WELCOME ===!

        WRITE(*,*)'---------------- Welcome To BIOMT ------------------'
        WRITE(*,*)' '
        WRITE(*,*)'   A symmetric molecule will be generated from an   '
        WRITE(*,*)'        asymmetric unit and a symmetry file.        '
        WRITE(*,*)' '

        WRITE(*,*)'Enter the name of the GF2K file to rotate.'
        READ(*,*)gf2kfile
        WRITE(*,*)' '

        WRITE(*,*)'Enter the name of the symmetry file.'
        READ(*,*)symfile
        WRITE(*,*)' '

        WRITE(*,*)'Enter the name of the output GF2K file.'
        READ(*,*)outfile
        WRITE(*,*)' '

        !=== Rotations or R + Translations? ===!

        WRITE(*,*)'Does the symmetry file contain:'
        WRITE(*,*)'Rotations ONLY                           --- ENTER 1'
        WRITE(*,*)'Rotations AND Translations               --- ENTER 2'
        WRITE(*,*)' '
        READ(*,*)ifmt
        WRITE(*,*)' '

        IF ( ifmt < 1 .or. ifmt > 2 ) THEN

          WRITE(*,*)'ERROR: Invalid choice. You entered ',ifmt
          STOP

        ENDIF

        OPEN (UNIT = 1, FILE = gf2kfile, STATUS = 'Unknown')
        OPEN (UNIT = 2, FILE = symfile, STATUS = 'Unknown')
        OPEN (UNIT = 3, FILE = outfile, STATUS = 'Unknown')

        !=== Read in Asymmetric Unit ===!

        READ(1,*)nat

        ALLOCATE (itype(nat),rat(3,nat))

        READ(1,*)(itype(i),rat(1,i),rat(2,i),rat(3,i),i=1,nat)

        !=== Read in Symmetry File ===!

        READ(2,*)ngrp

        ALLOCATE (r1(3,ngrp),grot(3,3,ngrp),gt(3,ngrp),iwrk(ngrp))

        IF ( ifmt == 1 ) THEN

          DO i=1,ngrp
          READ(2,*)grot(1,1,i),grot(1,2,i),grot(1,3,i)
          READ(2,*)grot(2,1,i),grot(2,2,i),grot(2,3,i)
          READ(2,*)grot(3,1,i),grot(3,2,i),grot(3,3,i)
          ENDDO

        ELSEIF ( ifmt == 2 ) THEN

          DO i=1,ngrp
          READ(2,*)grot(1,1,i),grot(1,2,i),grot(1,3,i),gt(1,i)
          READ(2,*)grot(2,1,i),grot(2,2,i),grot(2,3,i),gt(2,i)
          READ(2,*)grot(3,1,i),grot(3,2,i),grot(3,3,i),gt(3,i)
          ENDDO

        ENDIF

        CLOSE (UNIT = 1)
        CLOSE (UNIT = 2)

        !=== Check Which Rotations Give Unique Atoms ===!

        ntot = 0

        DO i=1,ngrp

          x(1) = grot(1,1,i) * rat(1,1) + grot(1,2,i) * rat(2,1) &
             & + grot(1,3,i) * rat(3,1)

          x(2) = grot(2,1,i) * rat(1,1) + grot(2,2,i) * rat(2,1) &
             & + grot(2,3,i) * rat(3,1)

          x(3) = grot(3,1,i) * rat(1,1) + grot(3,2,i) * rat(2,1) &
             & + grot(3,3,i) * rat(3,1)

          IF ( ifmt == 2 ) x(:) = x(:) + gt(:,i)

          r1(:,i) = x(:)

          iwrk(i) = 1

          IF ( i > 1 ) THEN

            DO j=1,i-1
            IF ( iwrk(j) == 1 ) THEN

              x(:) = r1(:,i) - r1(:,j)

              xsq = x(1) * x(1) + x(2) * x(2) + x(3) * x(3)

              IF ( xsq < tol ) iwrk(i) = 0

            ENDIF
            ENDDO

          ENDIF

          IF ( iwrk(i) == 1 ) ntot = ntot + nat

        ENDDO


        !=== Output New GF2K File ===!

        WRITE(3,30)ntot,0.0d0

        DO i=1,ngrp
        IF ( iwrk(i) == 1 ) THEN

          DO j=1,nat

            x(1) = grot(1,1,i) * rat(1,j) + grot(1,2,i) * rat(2,j) &
               & + grot(1,3,i) * rat(3,j)

            x(2) = grot(2,1,i) * rat(1,j) + grot(2,2,i) * rat(2,j) &
               & + grot(2,3,i) * rat(3,j)

            x(3) = grot(3,1,i) * rat(1,j) + grot(3,2,i) * rat(2,j) &
               & + grot(3,3,i) * rat(3,j)

            IF ( ifmt == 2 ) x(:) = x(:) + gt(:,i)

            WRITE(3,31)itype(j),x(1),x(2),x(3)

          ENDDO

        ENDIF
        ENDDO

        CLOSE (UNIT = 1)
        CLOSE (UNIT = 2)
        CLOSE (UNIT = 3)

        !=== DEALLOCATE ARRAYS ===!

        DEALLOCATE (rat,r1,grot,itype,iwrk)

        !=== Format Statements ===!

 30     FORMAT (I8,E16.8)
 31     FORMAT (I3,3F13.7)

        END PROGRAM BIOMT
