! ==============================================================================
! Program: CALPHAENM
! 
! Description: Uses a Saguaro GF2K file of a protein to create Saguaro PARM
!              and MOL files which can be used in an ENM simulation of the
!              vibrational modes of only the proteins C ALPHA carbons.
!
! Notes:
!
! History:
!
! Version    Date         Comment
! --------   ----------   -----------------------
!            10/01/2010   Original Code
!
! Dependancies:
!
! Modules -
! Functions -
! Subroutines -
!
! Author(s): Eric Dykeman
!
! ==============================================================================

      PROGRAM CALPHAENM

        IMPLICIT NONE

        INTEGER, DIMENSION(:), ALLOCATABLE :: itype,iwrk
        DOUBLE PRECISION, DIMENSION(:,:), ALLOCATABLE :: rat

        INTEGER :: i,nat,nbd,nag,ndh,nhbd,nex,n14,npro,nca
        DOUBLE PRECISION :: time,amass,q,r,eps
        CHARACTER (LEN=70) :: gf2kfile,parmfile,molfile


        !=== WELCOME ===!

        WRITE(*,*)'-------------- WELCOME TO CALPHAENM ----------------'
        WRITE(*,*)' '
        WRITE(*,*)'This program creates Saguaro PARM and MOL files from'
        WRITE(*,*)'a GF2K file of a protein which can be used in an ENM'
        WRITE(*,*)'simulation of the vibrational modes of the proteins'
        WRITE(*,*)'C Alpha Carbon atoms.'
        WRITE(*,*)' '

        WRITE(*,*)'NOTE: If you have created the coordinates directly'
        WRITE(*,*)'      from a PDB file, Please EXIT and use pepalyze'
        WRITE(*,*)'      to make a GF2K file from the PDB first.'
        WRITE(*,*)' '

        WRITE(*,*)'Please enter the Saguaro GF2K file.'
        READ(*,*)gf2kfile
        WRITE(*,*)' '

        !=== Open Files ===!

        OPEN (UNIT = 1, FILE = gf2kfile, STATUS = 'Unknown')
        OPEN (UNIT = 2, FILE = 'calpha.gf2k', STATUS = 'Unknown')
        OPEN (UNIT = 3, FILE = 'calpha.parm', STATUS = 'Unknown')
        OPEN (UNIT = 4, FILE = 'calpha.mol', STATUS = 'Unknown')


        !=== Create Saguaro Files ===!

        q = 0.0d0
        r = 0.0d0
        eps = 0.0d0
        amass = 12.01d0

        nbd = 0
        nag = 0
        ndh = 0
        nhbd = 0
        nex = 0
        n14 = 0

        READ(1,*)nat,time

        ALLOCATE (itype(nat),rat(3,nat),iwrk(nat))

        READ(1,*)(itype(i),rat(1,i),rat(2,i),rat(3,i),i=1,nat)

        !=== Find C alphas ===!

        npro = 1
        nca = 1

        iwrk(:) = 0

        IF ( itype(4) == 6 ) THEN

          iwrk(4) = npro

        ELSE

          iwrk(5) = npro

        ENDIF

        DO i=3,nat
        IF ( itype(i) == 7 ) THEN
        IF ( itype(i-2) == 6 .and. itype(i-1) == 8 ) THEN

          IF ( itype(i+1) == 1 .and. itype(i+2) == 6 ) THEN

            nca = nca + 1
            iwrk(i+2) = npro

          ELSEIF ( itype(i+1) == 6 .and. itype(i+2) == 1 ) THEN

            nca = nca + 1
            iwrk(i+1) = npro

          ENDIF

        ELSEIF ( itype(i-2) == 8 .and. itype(i-1) == 8 ) THEN

          IF ( itype(i+1) == 1 .and. itype(i+2) == 1 ) THEN

            npro = npro + 1

          IF ( itype(i+3) == 6 ) THEN

            nca = nca + 1
            iwrk(i+3) = npro

          ELSE

            nca = nca + 1
            iwrk(i+4) = npro

          ENDIF
          ENDIF

        ENDIF
        ENDIF
        ENDDO

        WRITE(2,20)nca,time
        WRITE(3,30)nca,nbd,nhbd,nag,ndh,nex,n14
        WRITE(4,40)nca,npro

        DO i=1,nat
        IF ( iwrk(i) /= 0 ) THEN

          WRITE(2,21)itype(i),rat(1,i),rat(2,i),rat(3,i)
          WRITE(3,31)amass,q,r,eps
          WRITE(4,41)iwrk(i),'A'

        ENDIF
        ENDDO

        CLOSE (UNIT = 1)
        CLOSE (UNIT = 2)
        CLOSE (UNIT = 3)
        CLOSE (UNIT = 4)

        !=== DEALLOCATE ARRAYS ===!

        DEALLOCATE (itype,rat,iwrk)

        !=== Format Statements ===!

 20     FORMAT (I8,E16.8)
 21     FORMAT (I3,3F13.7)
 30     FORMAT (7I8)
 31     FORMAT (4E16.8)
 40     FORMAT (I8,I6)
 41     FORMAT (I6,2X,A1)

        END PROGRAM CALPHAENM
