! ==============================================================================
! Program: GF2K2PDB
! 
! Description: Converts a Saguaro coordinate file to PDB format or converts
!              a PDB coordinate file to a gf2k saguaro coordinate file.
!
! Notes:
!
! History:
!
! Version    Date         Comment
! --------   ----------   -----------------------
!            10/01/2010   Original Code
!
! Dependancies:
!
! Modules -
! Functions -
! Subroutines - GETTYPE
!
! Author(s): Eric Dykeman
!
! ==============================================================================

      PROGRAM GF2K2PDB

        IMPLICIT NONE

        !=== VARAIBLES ===!

        CHARACTER (LEN=1) :: aloc,cid,incd
        CHARACTER (LEN=2) :: aname
        CHARACTER (LEN=3) :: resn
        CHARACTER (LEN=4) :: pdbnm
        CHARACTER (LEN=6) :: recid
        CHARACTER (LEN=70) :: gf2kfile,pdbfile

        DOUBLE PRECISION :: x,y,z,time,xocc,b
        INTEGER :: i,ifmt,nat,itype,iser,ires

        INTEGER, PARAMETER :: maxline = 100000


        !=== WELCOME ===!

        WRITE(*,*)'--------------- Welcome To GF2K2PDB ----------------'
        WRITE(*,*)' '
        WRITE(*,*)'WHICH WOULD YOU LIKE TO DO'
        WRITE(*,*)'Convert GF2K to PDB --> ENTER 1'
        WRITE(*,*)'Convert PDB to GF2K --> ENTER 2'
        WRITE(*,*)' '

        READ(*,*)ifmt
        WRITE(*,*)' '

        IF ( ifmt < 1 .or. ifmt > 2 ) THEN

          WRITE(*,*)'ERROR: Invalid choice. You entered ',ifmt
          STOP

        ENDIF

        !=== Get file names ===!

        IF ( ifmt == 1 ) THEN

          WRITE(*,*)'Enter the name of the input GF2K file.'
          READ(*,*)gf2kfile
          WRITE(*,*)' '

          WRITE(*,*)'Enter the name of the output PDB file.'
          READ(*,*)pdbfile
          WRITE(*,*)' '


          !=== PDB DEFAULTS ===!

          xocc = 1.0d0
          b = 0.0d0

          recid = 'ATOM  '
          resn = 'UNK'
          cid = 'A'
          ires = 1
          incd = ' '
          aloc = ' '

        ELSE

          WRITE(*,*)'Enter the name of the input PDB file.'
          READ(*,*)pdbfile
          WRITE(*,*)' '

          WRITE(*,*)'Enter the name of the output GF2K file.'
          READ(*,*)gf2kfile
          WRITE(*,*)' '

          time = 0.0d0

        ENDIF

        OPEN (UNIT=1,FILE=gf2kfile,STATUS='Unknown')
        OPEN (UNIT=2,FILE=pdbfile,STATUS='Unknown')


        IF ( ifmt == 1 ) THEN

          READ(1,*)nat,time

          DO i=1,nat

            READ(1,*)itype,x,y,z

            CALL GETTYPE (pdbnm,itype,ifmt)

            iser = i

            WRITE(2,20)recid,iser,pdbnm,aloc,resn,cid,ires,incd,&
                     & x,y,z,xocc,b,itype

          ENDDO

          WRITE(2,21)'TER',nat+1,resn,cid,ires

          WRITE(2,22)'END'

        ELSE

          nat = 0

          DO i=1,maxline

            READ(2,30,END=1)recid

            IF ( recid == 'ATOM' .or. recid == 'HETATM' ) nat = nat + 1

          ENDDO

          WRITE(*,*)'PLEASE INCREASE MAXLINE IN GF2K2PDB'
          STOP

 1        WRITE(1,10)nat,time

          REWIND (UNIT = 2)

          DO i=1,maxline

            READ(2,30,END=2)recid

            IF ( recid == 'ATOM' .or. recid == 'HETATM') THEN

              BACKSPACE (UNIT = 2)

              READ(2,31,END=2)recid,iser,pdbnm,aloc,resn,cid,ires,&
                            & incd,x,y,z

              CALL GETTYPE (pdbnm,itype,ifmt)

              WRITE(1,11)itype,x,y,z

            ENDIF

          ENDDO

 2        CONTINUE

        ENDIF

        WRITE(*,*)'The coordinate file has been converted. Goodbye.'

        CLOSE (UNIT = 1)
        CLOSE (UNIT = 2)

        !=== Format Statements ===!

 10     FORMAT(I8,E16.8)
 11     FORMAT(I3,3F13.7)

 20     FORMAT(A6,I5,1X,A4,A1,A3,1X,A1,I4,A1,3X,3F8.3,2F6.2,I4)
 21     FORMAT(A3,3X,I5,6X,A3,1X,A1,I4)
 22     FORMAT(A3)

 30     FORMAT(A6)
 31     FORMAT(A6,I5,1X,A4,A1,A3,1X,A1,I4,A1,3X,3F8.3)

      END PROGRAM GF2K2PDB

! ==============================================================================
! Subroutine: GETTYPE (PDBNM,ITYPE,ICONV)
! 
! Purpose: Converts pdb atom names to numerical numbers.
!
! Method:
!
! Arguments:
!
!           PDBNM - The name of the atom in the pdb file.
!           ITYPE - Integer containing the numerical atom number.
!           ICONV - Flag for converting.
!                   IF ICONV = 1 the atom number ITYPE is used to generate
!                   the pdb atom name.
!                   IF ICONV = 2 the pdb atom name is used to generate the
!                   atom number.
!
! History:
!
! Version    Date         Comment
! --------   ----------   -----------------------
!            10/01/2010   Original Code
!
! Dependancies:
!
! Modules -
! Functions -
! Subroutines -
!
! Author(s): Eric Dykeman
!
! ==============================================================================

      SUBROUTINE GETTYPE (PDBNM,ITYPE,ICONV)

        IMPLICIT NONE

        !=== ARGUMENTS ===!

        CHARACTER (LEN=4), INTENT(INOUT) :: pdbnm
        INTEGER, INTENT(INOUT) :: itype
        INTEGER, INTENT(IN) :: iconv

        !=== VARIBLES ===!

        INTEGER :: iz
        CHARACTER (LEN=2) :: atmn(106),aname


        !=== Initialize Names ===!

        DATA atmn / ' H','HE','LI','BE',' B',' C',' N',' O',' F','NE', &
        & 'NA','MG','AL','SI',' P',' S','CL','AR',' K','CA','SC','TI', &
        & ' V','CR','MN','FE','CO','NI','CU','ZN','GA','GE','AS','SE', &
        & 'BR','KR','RB','SR',' Y','ZR','NB','MO','TC','RU','RH','PD', &
        & 'AG','CD','IN','SN','SB','TE',' I','XE','CS','BA','LA','CE', &
        & 'PR','ND','PM','SM','EU','GD','TB','DY','HO','ER','TM','TB', &
        & 'LU','HF','TA',' W','RE','OS','IR','PT','AU','HG','TL','PB', &
        & 'BI','PO','AT','RN','XX','XX','XX','XX','XX','XX','XX','XX', &
        & 'XX','XX','XX','XX','XX','XX','XX','XX','XX','XX','XX','XX'/

        IF ( iconv == 1 ) THEN

          !=== ICONV = 1 ===!
          !=== Get atom name ===!

          aname = atmn(itype)

          pdbnm = aname//'  '

        ELSEIF ( iconv == 2 ) THEN

          !=== ICONV = 2 ===!
          !=== Get atom number ===!

          READ(pdbnm,'(A2)')aname

          IF ( aname(1:1) == ' ' ) aname = pdbnm(2:2)
          IF ( aname(1:1) == '0' ) aname = pdbnm(2:2)
          IF ( aname(1:1) == '1' ) aname = pdbnm(2:2)
          IF ( aname(1:1) == '2' ) aname = pdbnm(2:2)
          IF ( aname(1:1) == '3' ) aname = pdbnm(2:2)
          IF ( aname(1:1) == '4' ) aname = pdbnm(2:2)
          IF ( aname(1:1) == '5' ) aname = pdbnm(2:2)
          IF ( aname(1:1) == '6' ) aname = pdbnm(2:2)
          IF ( aname(1:1) == '7' ) aname = pdbnm(2:2)
          IF ( aname(1:1) == '8' ) aname = pdbnm(2:2)
          IF ( aname(1:1) == '9' ) aname = pdbnm(2:2)

          iz = 0

          IF ( aname == 'h' ) iz = 1
          IF ( aname == 'H' ) iz = 1

          IF ( aname == 'li' ) iz = 3
          IF ( aname == 'Li' ) iz = 3
          IF ( aname == 'lI' ) iz = 3
          IF ( aname == 'LI' ) iz = 3

          IF ( aname == 'c' ) iz = 6
          IF ( aname == 'C' ) iz = 6

          IF ( aname == 'n' ) iz = 7
          IF ( aname == 'N' ) iz = 7

          IF ( aname == 'o' ) iz = 8
          IF ( aname == 'O' ) iz = 8

          IF ( aname == 'f' ) iz = 9
          IF ( aname == 'F' ) iz = 9

          IF ( aname == 'na' ) iz = 11
          IF ( aname == 'Na' ) iz = 11
          IF ( aname == 'nA' ) iz = 11
          IF ( aname == 'NA' ) iz = 11

          IF ( aname == 'mg' ) iz = 12
          IF ( aname == 'Mg' ) iz = 12
          IF ( aname == 'mG' ) iz = 12
          IF ( aname == 'MG' ) iz = 12

          IF ( aname == 'al' ) iz = 13
          IF ( aname == 'Al' ) iz = 13
          IF ( aname == 'aL' ) iz = 13
          IF ( aname == 'AL' ) iz = 13

          IF ( aname == 'si' ) iz = 14
          IF ( aname == 'Si' ) iz = 14
          IF ( aname == 'sI' ) iz = 14
          IF ( aname == 'SI' ) iz = 14

          IF ( aname == 'p' ) iz = 15
          IF ( aname == 'P' ) iz = 15

          IF ( aname == 's' ) iz = 16
          IF ( aname == 'S' ) iz = 16

          IF ( aname == 'cl' ) iz = 17
          IF ( aname == 'Cl' ) iz = 17
          IF ( aname == 'cL' ) iz = 17
          IF ( aname == 'CL' ) iz = 17

          IF ( aname == 'k' ) iz = 19
          IF ( aname == 'K' ) iz = 19

          IF ( aname == 'ca' ) iz = 20
          IF ( aname == 'Ca' ) iz = 20
          IF ( aname == 'cA' ) iz = 20
          IF ( aname == 'CA' ) iz = 20

          IF ( aname == 'cu' ) iz = 29
          IF ( aname == 'Cu' ) iz = 29
          IF ( aname == 'cU' ) iz = 29
          IF ( aname == 'CU' ) iz = 29

          IF ( aname == 'ge' ) iz = 32
          IF ( aname == 'Ge' ) iz = 32
          IF ( aname == 'gE' ) iz = 32
          IF ( aname == 'GE' ) iz = 32

          IF ( aname == 'au' ) iz = 79
          IF ( aname == 'Au' ) iz = 79
          IF ( aname == 'aU' ) iz = 79
          IF ( aname == 'AU' ) iz = 79

          IF ( iz == 0 ) THEN

            WRITE(*,*)'ERROR: Unknown atom name in PDB file.'
            WRITE(*,*)'NAME = ',aname

            STOP

          ENDIF

          itype = iz

        ENDIF

        RETURN

      END SUBROUTINE GETTYPE
