! ==============================================================================
! Program: GF2K2XYZ
! 
! Description: Converts a Saguaro coordinate file to XYZ format or converts
!              a XYZ coordinate file to a gf2k saguaro coordinate file.
!
! Notes:
!
! History:
!
! Version    Date         Comment
! --------   ----------   -----------------------
!            10/01/2010   Original Code
!
! Dependancies:
!
! Modules -
! Functions -
! Subroutines - GETTYPE
!
! Author(s): Eric Dykeman
!
! ==============================================================================

      PROGRAM GF2K2XYZ

        IMPLICIT NONE

        !=== VARIABLES ===!

        DOUBLE PRECISION :: x,y,z,time
        INTEGER :: i,itype,nat,ifmt

        CHARACTER (LEN=2) :: aname
        CHARACTER (LEN=70) :: gf2kfile,xyzfile,junk


        !=== WELCOME ===!

        WRITE(*,*)'--------------- Welcome To GF2K2XYZ ----------------'
        WRITE(*,*)' '
        WRITE(*,*)'WHICH WOULD YOU LIKE TO DO'
        WRITE(*,*)'Convert GF2K to XYZ --> ENTER 1'
        WRITE(*,*)'Convert XYZ to GF2K --> ENTER 2'
        WRITE(*,*)' '

        READ(*,*)ifmt
        WRITE(*,*)' '

        IF ( ifmt < 1 .or. ifmt > 2 ) THEN

          WRITE(*,*)'ERROR: Invalid choice. You entered ',ifmt
          STOP

        ENDIF

        !=== Get file names ===!

        IF ( ifmt == 1 ) THEN

          WRITE(*,*)'Enter the name of the input GF2K file.'
          READ(*,*)gf2kfile
          WRITE(*,*)' '

          WRITE(*,*)'Enter the name of the output XYZ file.'
          READ(*,*)xyzfile
          WRITE(*,*)' '

          junk = 'XYZ GENERATED BY GF2K2XYZ'

        ELSE

          WRITE(*,*)'Enter the name of the input XYZ file.'
          READ(*,*)xyzfile
          WRITE(*,*)' '

          WRITE(*,*)'Enter the name of the output GF2K file.'
          READ(*,*)gf2kfile
          WRITE(*,*)' '

          time = 0.0d0

        ENDIF

        OPEN (UNIT=1,FILE=gf2kfile,STATUS='Unknown')
        OPEN (UNIT=2,FILE=xyzfile,STATUS='Unknown')


        IF ( ifmt == 1 ) THEN

          READ(1,*)nat,time

          WRITE(2,10)nat
          WRITE(2,*)junk

        ELSE

          READ(2,*)nat
          READ(2,*)junk

          WRITE(1,11)nat,time

        ENDIF


        !=== Convert Coordinate File ===!

        DO i=1,nat

          IF ( ifmt == 1 ) THEN

            READ(1,*)itype,x,y,z

            CALL GETTYPE (aname,itype,ifmt)

            WRITE(2,20)aname,x,y,z

          ELSE

            READ(2,*)aname,x,y,z

            CALL GETTYPE (aname,itype,ifmt)

            WRITE(1,21)itype,x,y,z

          ENDIF

        ENDDO

        WRITE(*,*)'The coordinate file has been converted. Goodbye'

        CLOSE (UNIT = 1)
        CLOSE (UNIT = 2)

        !=== Format Statements ===!

 10     FORMAT(I8)
 11     FORMAT(I8,E16.8)

 20     FORMAT(A2,3F13.7)
 21     FORMAT(I3,3F13.7)

      END PROGRAM GF2K2XYZ

! ==============================================================================
! Subroutine: GETTYPE (ANAME,ITYPE,ICONV)
! 
! Purpose: Converts atom names to numerical numbers.
!
! Method:
!
! Arguments:
!
!           ANAME - The name of the atom.
!           ITYPE - Integer containing the numerical atom number.
!           ICONV - Flag for converting.
!                   IF ICONV = 1 the atom number ITYPE is used to generate
!                   the atom name.
!                   IF ICONV = 2 the atom name is used to generate the
!                   atom number.
!
! History:
!
! Version    Date         Comment
! --------   ----------   -----------------------
!            10/01/2010   Original Code
!
! Dependancies:
!
! Modules -
! Functions -
! Subroutines -
!
! Author(s): Eric Dykeman
!
! ==============================================================================

      SUBROUTINE GETTYPE (ANAME,ITYPE,ICONV)

        IMPLICIT NONE

        !=== ARGUMENTS ===!

        CHARACTER (LEN=2), INTENT(INOUT) :: aname
        INTEGER, INTENT(INOUT) :: itype
        INTEGER, INTENT(IN) :: iconv

        !=== VARIABLES ===!

        INTEGER :: iz
        CHARACTER (LEN=2),DIMENSION(106) :: atmn


        !=== Initialize Names ===!

        DATA atmn / ' H','He','Li','Be',' B',' C',' N',' O',' F','Ne', &
        & 'Na','Mg','Al','Si',' P',' S','Cl','Ar',' K','Ca','Sc','Ti', &
        & ' V','Cr','Mn','Fe','Co','Ni','Cu','Zn','Ga','Ge','As','Se', &
        & 'Br','Kr','Rb','Sr',' Y','Zr','Nb','Mo','Tc','Ru','Rh','Pd', &
        & 'Ag','Cd','In','Sn','Sb','Te',' I','Xe','Cs','Ba','La','Ce', &
        & 'Pr','Nd','Pm','Sm','Eu','Gd','Tb','Dy','Ho','Er','Tm','Tb', &
        & 'Lu','Hf','Ta',' W','Re','Os','Ir','Pt','Au','Hg','Tl','Pb', &
        & 'Bi','Po','At','Rn','XX','XX','XX','XX','XX','XX','XX','XX', &
        & 'XX','XX','XX','XX','XX','XX','XX','XX','XX','XX','XX','XX'/

        IF ( iconv == 1 ) THEN

          !=== ICONV = 1 ===!
          !=== Get atom name ===!

          aname = atmn(itype)

        ELSEIF ( iconv == 2 ) THEN

          !=== ICONV = 2 ===!
          !=== Get atom number ===!

          iz = 0

          IF ( aname == 'h' ) iz = 1
          IF ( aname == 'H' ) iz = 1

          IF ( aname == 'li' ) iz = 3
          IF ( aname == 'Li' ) iz = 3
          IF ( aname == 'lI' ) iz = 3
          IF ( aname == 'LI' ) iz = 3

          IF ( aname == 'c' ) iz = 6
          IF ( aname == 'C' ) iz = 6

          IF ( aname == 'n' ) iz = 7
          IF ( aname == 'N' ) iz = 7

          IF ( aname == 'o' ) iz = 8
          IF ( aname == 'O' ) iz = 8

          IF ( aname == 'f' ) iz = 9
          IF ( aname == 'F' ) iz = 9

          IF ( aname == 'na' ) iz = 11
          IF ( aname == 'Na' ) iz = 11
          IF ( aname == 'nA' ) iz = 11
          IF ( aname == 'NA' ) iz = 11

          IF ( aname == 'mg' ) iz = 12
          IF ( aname == 'Mg' ) iz = 12
          IF ( aname == 'mG' ) iz = 12
          IF ( aname == 'MG' ) iz = 12

          IF ( aname == 'al' ) iz = 13
          IF ( aname == 'Al' ) iz = 13
          IF ( aname == 'aL' ) iz = 13
          IF ( aname == 'AL' ) iz = 13

          IF ( aname == 'si' ) iz = 14
          IF ( aname == 'Si' ) iz = 14
          IF ( aname == 'sI' ) iz = 14
          IF ( aname == 'SI' ) iz = 14

          IF ( aname == 'p' ) iz = 15
          IF ( aname == 'P' ) iz = 15

          IF ( aname == 's' ) iz = 16
          IF ( aname == 'S' ) iz = 16

          IF ( aname == 'cl' ) iz = 17
          IF ( aname == 'Cl' ) iz = 17
          IF ( aname == 'cL' ) iz = 17
          IF ( aname == 'CL' ) iz = 17

          IF ( aname == 'k' ) iz = 19
          IF ( aname == 'K' ) iz = 19

          IF ( aname == 'ca' ) iz = 20
          IF ( aname == 'Ca' ) iz = 20
          IF ( aname == 'cA' ) iz = 20
          IF ( aname == 'CA' ) iz = 20

          IF ( aname == 'cu' ) iz = 29
          IF ( aname == 'Cu' ) iz = 29
          IF ( aname == 'cU' ) iz = 29
          IF ( aname == 'CU' ) iz = 29

          IF ( aname == 'ge' ) iz = 32
          IF ( aname == 'Ge' ) iz = 32
          IF ( aname == 'gE' ) iz = 32
          IF ( aname == 'GE' ) iz = 32

          IF ( aname == 'au' ) iz = 79
          IF ( aname == 'Au' ) iz = 79
          IF ( aname == 'aU' ) iz = 79
          IF ( aname == 'AU' ) iz = 79

          IF ( iz == 0 ) THEN

            WRITE(*,*)'ERROR: Unknown atom name in XYZ file.'
            WRITE(*,*)'NAME = ',aname

            STOP

          ENDIF

          itype = iz

        ENDIF

        RETURN

      END SUBROUTINE GETTYPE
