! ==============================================================================
! Program: ROTRANS
! 
! Description: Applies a rotation and or a translation to a molecule.
!
! Notes:
!
! History:
!
! Version    Date         Comment
! --------   ----------   -----------------------
!            10/01/2010   Original Code
!
! Dependancies:
!
! Modules -
! Functions -
! Subroutines -
!
! Author(s): Eric Dykeman
!
! ==============================================================================

      PROGRAM ROTRANS

        IMPLICIT NONE

        INTEGER, DIMENSION(:), ALLOCATABLE :: itype
        DOUBLE PRECISION, DIMENSION(:,:), ALLOCATABLE :: rat

        INTEGER :: i,nat
        DOUBLE PRECISION :: rot(3,3),t(3),x(3),b(3),c,w,theta
        CHARACTER (LEN=70) :: gf2kfile,outfile

        DOUBLE PRECISION, PARAMETER :: pi = 3.14159265358979323d0


        !=== WELCOME ===!

        WRITE(*,*)'--------------- Welcome To ROTRANS -----------------'
        WRITE(*,*)' '
        WRITE(*,*)'This program will apply a rotation and translation  '
        WRITE(*,*)'to a molecule and output the file as a GF2K file.   '
        WRITE(*,*)' '

        WRITE(*,*)'Enter the name of the GF2K file to rotate.'
        READ(*,*)gf2kfile
        WRITE(*,*)' '

        WRITE(*,*)'Enter the name of the output GF2K file.'
        READ(*,*)outfile
        WRITE(*,*)' '

        OPEN (UNIT = 1, FILE = gf2kfile, STATUS = 'Unknown')
        OPEN (UNIT = 2, FILE = outfile, STATUS = 'Unknown')


        !=== Read in Input GF2K File ===!

        READ(1,*)nat

        ALLOCATE (itype(nat),rat(3,nat))

        READ(1,*)(itype(i),rat(1,i),rat(2,i),rat(3,i),i=1,nat)

        !=== Construct Rotation ===!

        WRITE(*,*)'Enter the rotation angle in degrees.'
        WRITE(*,*)'If no rotation enter 0.0'
        READ(*,*)theta
        WRITE(*,*)' '

        IF ( theta == 0.0d0 ) THEN

          b(:) = 0.0d0
          b(1) = 1.0d0

        ELSE

          WRITE(*,*)'Enter the axis of rotation.'
          WRITE(*,*)'NOTE: This need not be normalized.'
          READ(*,*)b(1),b(2),b(3)
          WRITE(*,*)' '

        ENDIF

        WRITE(*,*)'Enter translation.'
        READ(*,*)t(1),t(2),t(3)
        WRITE(*,*)' '


        c = b(1) * b(1) + b(2) * b(2) + b(3) * b(3)

        c = 1.0d0 / DSQRT(c)

        b(:) = b(:) * c

        theta = theta * pi / 180.0d0
        c = theta / 2.0d0

        c = 2.0d0 * DSIN(c)

        b(:) = b(:) * c

        w = 1.0d0 - c * c / 4.0d0
        w = DSQRT(w)

        rot(1,1) = 1.0d0 - ( c * c - b(1) * b(1) ) / 2.0d0
        rot(1,2) = -w * b(3) + b(1) * b(2) / 2.0d0
        rot(1,3) = +w * b(2) + b(1) * b(3) / 2.0d0

        rot(2,2) = 1.0d0 - ( c * c - b(2) * b(2) ) / 2.0d0
        rot(2,1) = +w * b(3) + b(1) * b(2) / 2.0d0
        rot(2,3) = -w * b(1) + b(2) * b(3) / 2.0d0

        rot(3,3) = 1.0d0 - ( c * c - b(3) * b(3) ) / 2.0d0
        rot(3,1) = -w * b(2) + b(1) * b(3) / 2.0d0
        rot(3,2) = +w * b(1) + b(2) * b(3) / 2.0d0


        !=== Output New GF2K File ===!

        DO i=1,nat

          x(1) = rot(1,1) * rat(1,i) + rot(1,2) * rat(2,i) &
             & + rot(1,3) * rat(3,i)

          x(2) = rot(2,1) * rat(1,i) + rot(2,2) * rat(2,i) &
             & + rot(2,3) * rat(3,i)

          x(3) = rot(3,1) * rat(1,i) + rot(3,2) * rat(2,i) &
             & + rot(3,3) * rat(3,i)

          x(:) = x(:) + t(:)

          WRITE(2,21)itype(i),x(1),x(2),x(3)

        ENDDO

        CLOSE (UNIT = 1)
        CLOSE (UNIT = 2)

        !=== DEALLOCATE ARRAYS ===!

        DEALLOCATE (rat,itype)

        !=== Format Statements ===!

 20     FORMAT (I8,E16.8)
 21     FORMAT (I3,3F13.7)

        END PROGRAM ROTRANS
