! ==============================================================================
! Program: SAGCAT
! 
! Description: Concatenates two or more saguaro PARM, GF2K, and MOL files into
!              a single PARM, GF2K, and MOL file. This program is useful when
!              files for several molecules have been built seperatly and now
!              need combined.
!
! Notes:
!
! History:
!
! Version    Date         Comment
! --------   ----------   -----------------------
!            10/01/2010   Original Code
!
! Dependancies:
!
! Modules -
! Functions -
! Subroutines -
!
! Author(s): Eric Dykeman
!
! ==============================================================================

      PROGRAM SAGCAT

        IMPLICIT NONE

        !=== VARIABLES ===!

        DOUBLE PRECISION, DIMENSION(:,:), ALLOCATABLE :: dbd,db1,db2,dag
        DOUBLE PRECISION, DIMENSION(:,:), ALLOCATABLE :: ddh,dd1,dd2,da1
        DOUBLE PRECISION, DIMENSION(:,:), ALLOCATABLE :: datm,dat1,dat2
        DOUBLE PRECISION, DIMENSION(:,:), ALLOCATABLE :: rat,ra1,ra2,da2

        INTEGER, DIMENSION(:,:), ALLOCATABLE :: lbd,lb1,lb2,lag,la1,la2
        INTEGER, DIMENSION(:,:), ALLOCATABLE :: ldh,ld1,ld2,lex,le1,le2
        INTEGER, DIMENSION(:,:), ALLOCATABLE :: l14,l11,l12

        INTEGER, DIMENSION(:), ALLOCATABLE :: itype,itp1,itp2
        INTEGER, DIMENSION(:), ALLOCATABLE :: moln,mn1,mn2

        CHARACTER, DIMENSION(:), ALLOCATABLE :: mtype,mt1,mt2

        INTEGER :: nat,nat1,nat2,nbd,nb1,nb2,nhbd,nhb1,nhb2,nag,na1,na2
        INTEGER :: ndh,nd1,nd2,nex,ne1,ne2,n14,n11,n12,nmol,nm1,nm2
        INTEGER :: i,j,k,icont

        CHARACTER(LEN=70) :: parmfile,gf2kfile,molfile


        !=== WELCOME ===!

        WRITE(*,*)'--------------- WELCOME TO SAGCAT ------------------'
        WRITE(*,*)' '
        WRITE(*,*)'This program combines two or more Saguaro PARM files'
        WRITE(*,*)'to make a single Saguaro PARM file.'
        WRITE(*,*)' '

        WRITE(*,*)'Please enter the first Saguaro PARM file.'
        READ(*,*)parmfile
        WRITE(*,*)' '

        WRITE(*,*)'Please enter the first Saguaro GF2K file.'
        READ(*,*)gf2kfile
        WRITE(*,*)' '

        WRITE(*,*)'Please enter the first Saguaro MOL file.'
        READ(*,*)molfile
        WRITE(*,*)' '

        OPEN (UNIT=1,FILE=parmfile,STATUS='Old')
        OPEN (UNIT=2,FILE=gf2kfile,STATUS='Old')
        OPEN (UNIT=3,FILE=molfile,STATUS='Old')

        !=== Allocate Variables ===!

        READ(1,*)nat1,nb1,nhb1,na1,nd1,ne1,n11

        ALLOCATE (dat1(4,nat1),ra1(3,nat1),itp1(nat1))
        ALLOCATE (mn1(nat1),mt1(nat1))

        IF ( nb1 > 0 ) ALLOCATE (lb1(2,nb1),db1(2,nb1))
        IF ( na1 > 0 ) ALLOCATE (la1(3,na1),da1(2,na1))
        IF ( nd1 > 0 ) ALLOCATE (ld1(4,nd1),dd1(3,nd1))
        IF ( ne1 > 0 ) ALLOCATE (le1(2,ne1))
        IF ( n11 > 0 ) ALLOCATE (l11(2,n11))

        !=== Read in parm file ===!

        READ(1,*)(dat1(1,i),dat1(2,i),dat1(3,i),dat1(4,i),i=1,nat1)

        IF ( nb1 > 0 ) THEN

          READ(1,*)(lb1(1,i),lb1(2,i),db1(1,i),db1(2,i),i=1,nb1)

        ENDIF

        IF ( na1 > 0 ) THEN

          READ(1,*)(la1(1,i),la1(2,i),la1(3,i),&
                  & da1(1,i),da1(2,i),i=1,na1)

        ENDIF

        IF ( nd1 > 0 ) THEN

          READ(1,*)(ld1(1,i),ld1(2,i),ld1(3,i),ld1(4,i),&
                  & dd1(1,i),dd1(2,i),dd1(3,i),i=1,nd1)

        ENDIF

        IF ( ne1 > 0 ) THEN

          READ(1,*)(le1(1,i),le1(2,i),i=1,ne1)

        ENDIF

        IF ( n11 > 0 ) THEN

          READ(1,*)(l11(1,i),l11(2,i),i=1,n11)

        ENDIF

        !=== Read in gf2k file ===!

        READ(2,*)k

        READ(2,*)(itp1(i),ra1(1,i),ra1(2,i),ra1(3,i),i=1,nat1)

        !=== Read in mol file ===!

        READ(3,*)k,nm1

        READ(3,*)(mn1(i),mt1(i),i=1,nat1)

        CLOSE (UNIT = 1)
        CLOSE (UNIT = 2)
        CLOSE (UNIT = 3)


        !=== START CONCATENATION PROCEDURE ===!

        icont = 1

        DO WHILE ( icont == 1 )

          WRITE(*,*)'Please enter the Saguaro PARM file to add.'
          READ(*,*)parmfile
          WRITE(*,*)' '

          WRITE(*,*)'Please enter the Saguaro GF2K file to add.'
          READ(*,*)gf2kfile
          WRITE(*,*)' '

          WRITE(*,*)'Please enter the Saguaro MOL file to add.'
          READ(*,*)molfile
          WRITE(*,*)' '

          OPEN (UNIT=1,FILE=parmfile,STATUS='Old')
          OPEN (UNIT=2,FILE=gf2kfile,STATUS='Old')
          OPEN (UNIT=3,FILE=molfile,STATUS='Old')

          !=== Allocate Variables ===!

          READ(1,*)nat2,nb2,nhb2,na2,nd2,ne2,n12

          ALLOCATE (dat2(4,nat2),ra2(3,nat2),itp2(nat2))
          ALLOCATE (mn2(nat2),mt2(nat2))

          IF ( nb2 > 0 ) ALLOCATE (lb2(2,nb2),db2(2,nb2))
          IF ( na2 > 0 ) ALLOCATE (la2(3,na2),da2(2,na2))
          IF ( nd2 > 0 ) ALLOCATE (ld2(4,nd2),dd2(3,nd2))
          IF ( ne2 > 0 ) ALLOCATE (le2(2,ne2))
          IF ( n12 > 0 ) ALLOCATE (l12(2,n12))

          !=== Read in parm file ===!

          READ(1,*)(dat2(1,i),dat2(2,i),dat2(3,i),dat2(4,i),i=1,nat2)

          IF ( nb2 > 0 ) THEN

            READ(1,*)(lb2(1,i),lb2(2,i),db2(1,i),db2(2,i),i=1,nb2)

          ENDIF

          IF ( na2 > 0 ) THEN

            READ(1,*)(la2(1,i),la2(2,i),la2(3,i),&
                    & da2(1,i),da2(2,i),i=1,na2)

          ENDIF

          IF ( nd2 > 0 ) THEN

            READ(1,*)(ld2(1,i),ld2(2,i),ld2(3,i),ld2(4,i),&
                    & dd2(1,i),dd2(2,i),dd2(3,i),i=1,nd2)

          ENDIF

          IF ( ne2 > 0 ) THEN

            READ(1,*)(le2(1,i),le2(2,i),i=1,ne2)

          ENDIF

          IF ( n12 > 0 ) THEN

            READ(1,*)(l12(1,i),l12(2,i),i=1,n12)

          ENDIF

          !=== Read in gf2k file ===!

          READ(2,*)k

          READ(2,*)(itp2(i),ra2(1,i),ra2(2,i),ra2(3,i),i=1,nat2)

          !=== Read in mol file ===!

          READ(3,*)k,nm2

          READ(3,*)(mn2(i),mt2(i),i=1,nat2)

          CLOSE (UNIT = 1)
          CLOSE (UNIT = 2)
          CLOSE (UNIT = 3)

          nat = nat1 + nat2
          nbd = nb1 + nb2
          nhbd = nhb1 + nhb2
          nag = na1 + na2
          ndh = nd1 + nd2
          nex = ne1 + ne2
          n14 = n11 + n12
          nmol = nm1 + nm2

          ALLOCATE (datm(4,nat),rat(3,nat),itype(nat))
          ALLOCATE (moln(nat),mtype(nat))

          IF ( nbd > 0 ) ALLOCATE (lbd(2,nbd),dbd(2,nbd))
          IF ( nag > 0 ) ALLOCATE (lag(3,nag),dag(2,nag))
          IF ( ndh > 0 ) ALLOCATE (ldh(4,ndh),ddh(3,ndh))
          IF ( nex > 0 ) ALLOCATE (lex(2,nex))
          IF ( n14 > 0 ) ALLOCATE (l14(2,n14))

          DO i=1,nat

            IF ( i <= nat1 ) THEN
            datm(:,i) = dat1(:,i)
            ELSE
            j = i - nat1
            datm(:,i) = dat2(:,j)
            ENDIF

          ENDDO

          IF ( nbd > 0 ) THEN

            DO i=1,nbd

              IF ( i <= nhb1 ) THEN
              lbd(:,i) = lb1(:,i)
              dbd(:,i) = db1(:,i)
              ELSEIF ( i <= nhbd ) THEN
              j = i - nhb1
              lbd(:,i) = lb2(:,j) + nat1
              dbd(:,i) = db2(:,j)
              ELSEIF ( i <= nb1 + nhb2 ) THEN
              j = i - nhb2
              lbd(:,i) = lb1(:,j)
              dbd(:,i) = db1(:,j)
              ELSEIF ( i <= nbd ) THEN
              j = i - nb1
              lbd(:,i) = lb2(:,j) + nat1
              dbd(:,i) = db2(:,j)
              ENDIF

            ENDDO

          ENDIF

          IF ( nag > 0 ) THEN

            DO i=1,nag

              IF ( i <= na1 ) THEN
              lag(:,i) = la1(:,i)
              dag(:,i) = da1(:,i)
              ELSEIF ( i <= nag ) THEN
              j = i - na1
              lag(:,i) = la2(:,j) + nat1
              dag(:,i) = da2(:,j)
              ENDIF

            ENDDO

          ENDIF

          IF ( ndh > 0 ) THEN

            DO i=1,ndh

              IF ( i <= nd1 ) THEN
              ldh(:,i) = ld1(:,i)
              ddh(:,i) = dd1(:,i)
              ELSEIF ( i <= ndh ) THEN
              j = i - nd1
              ldh(:,i) = ld2(:,j) + nat1
              ddh(:,i) = dd2(:,j)
              ENDIF

            ENDDO

          ENDIF

          IF ( nex > 0 ) THEN

            DO i=1,nex

              IF ( i <= ne1 ) THEN
              lex(:,i) = le1(:,i)
              ELSEIF ( i <= nex ) THEN
              j = i - ne1
              lex(:,i) = le2(:,j) + nat1
              ENDIF

            ENDDO

          ENDIF

          IF ( n14 > 0 ) THEN

            DO i=1,n14

              IF ( i <= n11 ) THEN
              l14(:,i) = l11(:,i)
              ELSEIF ( i <= n14 ) THEN
              j = i - n11
              l14(:,i) = l12(:,j) + nat1
              ENDIF

            ENDDO

          ENDIF

          DO i=1,nat

            IF ( i <= nat1 ) THEN

              itype(i) = itp1(i)
              rat(:,i) = ra1(:,i)

              moln(i) = mn1(i)
              mtype(i) = mt1(i)

            ELSE

              j = i - nat1

              itype(i) = itp2(j)
              rat(:,i) = ra2(:,j)

              moln(i) = mn2(j) + nm1
              mtype(i) = mt2(j)

            ENDIF

          ENDDO

          !=== Deallocate work arrays ===!

          DEALLOCATE (dat1,ra1,itp1,dat2,ra2,itp2)
          DEALLOCATE (mn1,mt1,mn2,mt2)

          IF ( nb1 > 0 ) DEALLOCATE (lb1,db1)
          IF ( na1 > 0 ) DEALLOCATE (la1,da1)
          IF ( nd1 > 0 ) DEALLOCATE (ld1,dd1)
          IF ( ne1 > 0 ) DEALLOCATE (le1)
          IF ( n11 > 0 ) DEALLOCATE (l11)

          IF ( nb2 > 0 ) DEALLOCATE (lb2,db2)
          IF ( na2 > 0 ) DEALLOCATE (la2,da2)
          IF ( nd2 > 0 ) DEALLOCATE (ld2,dd2)
          IF ( ne2 > 0 ) DEALLOCATE (le2)
          IF ( n12 > 0 ) DEALLOCATE (l12)

          !=== Ask if there is another file to add ===!

          WRITE(*,*)'Do you have another set of files to add?'
          WRITE(*,*)'YES --> ENTER 1'
          WRITE(*,*)'NO  --> ENTER 0'
          READ(*,*)icont
          WRITE(*,*)' '

          !== If YES ... Then reallocate arrays ===!

          IF ( icont == 1 ) THEN

            nat1 = nat
            nb1 = nbd
            nhb1 = nhbd
            na1 = nag
            nd1 = ndh
            ne1 = nex
            n11 = n14
            nm1 = nmol

            READ(1,*)nat1,nb1,nhb1,na1,nd1,ne1,n11

            ALLOCATE (dat1(4,nat1),ra1(3,nat1),itp1(nat1))
            ALLOCATE (mn1(nat1),mt1(nat1))

            IF ( nb1 > 0 ) ALLOCATE (lb1(2,nb1),db1(2,nb1))
            IF ( na1 > 0 ) ALLOCATE (la1(3,na1),da1(2,na1))
            IF ( nd1 > 0 ) ALLOCATE (ld1(4,nd1),dd1(3,nd1))
            IF ( ne1 > 0 ) ALLOCATE (le1(2,ne1))
            IF ( n11 > 0 ) ALLOCATE (l11(2,n11))

            itp1(:) = itype(:)
            ra1(:,:) = rat(:,:)

            mn1(:) = moln(:)
            mt1(:) = mtype(:)

            dat1(:,:) = datm(:,:)

            IF ( nb1 > 0 ) THEN

              lb1(:,:) = lbd(:,:)
              db1(:,:) = dbd(:,:)

            ENDIF

            IF ( na1 > 0 ) THEN

              la1(:,:) = lag(:,:)
              da1(:,:) = dag(:,:)

            ENDIF

            IF ( nd1 > 0 ) THEN

              ld1(:,:) = ldh(:,:)
              dd1(:,:) = ddh(:,:)

            ENDIF

            IF ( ne1 > 0 ) le1(:,:) = lex(:,:)
            IF ( n11 > 0 ) l11(:,:) = l14(:,:)

            DEALLOCATE (datm,rat,itype,moln,mtype)

            IF ( nbd > 0 ) DEALLOCATE (lbd,dbd)
            IF ( nag > 0 ) DEALLOCATE (lag,dag)
            IF ( ndh > 0 ) DEALLOCATE (ldh,ddh)
            IF ( nex > 0 ) DEALLOCATE (lex)
            IF ( n14 > 0 ) DEALLOCATE (l14)

          ENDIF

        ENDDO


        !=== WRITE OUT NEW FILES ===!

        WRITE(*,*)'Please enter the new Saguaro PARM file name.'
        READ(*,*)parmfile
        WRITE(*,*)' '

        WRITE(*,*)'Please enter the new Saguaro GF2K file name.'
        READ(*,*)gf2kfile
        WRITE(*,*)' '

        WRITE(*,*)'Please enter the new Saguaro MOL file name.'
        READ(*,*)molfile
        WRITE(*,*)' '

        OPEN (UNIT=1,FILE=parmfile,STATUS='Unknown')
        OPEN (UNIT=2,FILE=gf2kfile,STATUS='Unknown')
        OPEN (UNIT=3,FILE=molfile,STATUS='Unknown')

        !=== WRITE OUT PARM FILE ===!

        WRITE(1,10)nat,nbd,nhbd,nag,ndh,nex,n14

        WRITE(1,11)(datm(1,i),datm(2,i),datm(3,i),datm(4,i),i=1,nat)

        IF ( nbd > 0 ) THEN
        WRITE(1,12)(lbd(1,i),lbd(2,i),dbd(1,i),dbd(2,i),i=1,nbd)
        ENDIF

        IF ( nag > 0 ) THEN
        WRITE(1,13)(lag(1,i),lag(2,i),lag(3,i),&
                  & dag(1,i),dag(2,i),i=1,nag)
        ENDIF

        IF ( ndh > 0 ) THEN
        WRITE(1,14)(ldh(1,i),ldh(2,i),ldh(3,i),ldh(4,i),&
                  & ddh(1,i),ddh(2,i),ddh(3,i),i=1,ndh)
        ENDIF

        IF ( nex > 0 ) THEN
        WRITE(1,15)(lex(1,i),lex(2,i),i=1,nex)
        ENDIF

        IF ( n14 > 0 ) THEN
        WRITE(1,15)(l14(1,i),l14(2,i),i=1,n14)
        ENDIF

        !=== WRITE OUT GF2K FILE ===!

        WRITE(2,20)nat,0.0d0

        WRITE(2,21)(itype(i),rat(1,i),rat(2,i),rat(3,i),i=1,nat)

        !=== WRITE OUT MOL FILE ===!

        WRITE(3,30)nat,nmol

        WRITE(3,31)(moln(i),mtype(i),i=1,nat)

        CLOSE (UNIT = 1)
        CLOSE (UNIT = 2)
        CLOSE (UNIT = 3)

        !=== DEALLOCATE ARRAYS ===!

        DEALLOCATE (datm,rat,itype,moln,mtype)

        IF ( nbd > 0 ) DEALLOCATE (lbd,dbd)
        IF ( nag > 0 ) DEALLOCATE (lag,dag)
        IF ( ndh > 0 ) DEALLOCATE (ldh,ddh)
        IF ( nex > 0 ) DEALLOCATE (lex)
        IF ( n14 > 0 ) DEALLOCATE (l14)

        !=== Format Statements ===!

 10     FORMAT(7I8)
 11     FORMAT(4E16.8)
 12     FORMAT(2I8,16X,2E16.8)
 13     FORMAT(3I8,8X,2E16.8)
 14     FORMAT(4I8,3E16.8)
 15     FORMAT(2I8)

 20     FORMAT(I8,E16.8)
 21     FORMAT(I3,3F13.7)

 30     FORMAT(I8,I6)
 31     FORMAT(I6,2X,A1)

      END PROGRAM SAGCAT
