! Subroutine: AddH
! Purpose: Adds Missing Hydrogen Atoms to Nucleic Acid Residues
! Written: September 16th 2007
! Last Update: April 7th 2009
! Author: Eric Dykeman

! NOTES: VARIABLES
!           RAT - (NAT,3) List of atomic coordinates
!         ITYPE - (NAT) List of Atom Types
!          RESN - (NRES) List of Residue Names
!          IRES - (NRES) List of First Atom Numbers For Each nucleic Acid
!           NAT - Total Number of Atoms in the System
!          NRES - Total Number of nucleic Acid Residues in the System
!
!        DEPENDANCIES
!        SystemParam - Global system parameters
!        CreateH TwoCoord ThreeCoord FourCoord -- Included At End
!

! **********************************************************************

      Subroutine AddH

         Use SystemParam, Only : RAT,ITYPE,RESN,IRES,NAT,NRES

         Implicit None

      !Variable Declaration!

      !Local Variables!

         Double Precision ROLD 
         Integer i,j,k,l,jS,jE,N,NH,iATM
         Integer ITOLD,iPHOS,NSKIP,jshift
         Character RNAME*3

         Dimension ROLD(NAT,3),ITOLD(NAT)

      !ROUTINE!

         !Make Backup Copy Of Coordinates!

         Do i=1,NAT
         Do j=1,3
         ROLD(i,j) = RAT(i,j)
         EndDo
         EndDo

         Do i=1,NAT
         ITOLD(i) = ITYPE(i)
         EndDo

         !First Figure Out How Many Hydrogens To Add!

         N = 0

         Do i=1,NRES

            jS = Iabs(IRES(i))

            If (i .NE. NRES)Then
            jE = Iabs(IRES(i+1)) - 1
            Else
            jE = NAT
            EndIf

            !DNA - Adenosine!

            If (RESN(i) .EQ. 'DA ')k = 32

            !DNA - Guanosine!

            If (RESN(i) .EQ. 'DG ')k = 33

            !DNA - Cytosine!

            If (RESN(i) .EQ. 'DC ')k = 30

            !DNA - Thymine!

            If (RESN(i) .EQ. 'DT ')k = 32

            !RNA - Adenosine!

            If (RESN(i) .EQ. 'RA ')k = 33

            !RNA - Guanosine!

            If (RESN(i) .EQ. 'RG ')k = 34

            !RNA - Cytosine!

            If (RESN(i) .EQ. 'RC ')k = 31

            !RNA - Uracil!

            If (RESN(i) .EQ. 'RU ')k = 30

            !ADP - Adenosine Di-Phosphate!

            If (RESN(i) .EQ. 'ADP')k = 39

            !GDP - Guanosine Di-Phosphate!

            If (RESN(i) .EQ. 'GDP')k = 40

            !ATP - Adenosine Tri-Phosphate!

            If (RESN(i) .EQ. 'ATP')k = 43

            !GTP - Guanosine Tri-Phosphate!

            If (RESN(i) .EQ. 'GTP')k = 44

            N = N + (k - (jE - jS + 1))

         EndDo


         !OK Check For Proper Hydrogens On Each Amino!
         !Add Dummy Hydrogens to coordinates 0,0,0!

         !Reallocate Arrays!

         Deallocate (RAT,ITYPE)

         Allocate (RAT(NAT+N,3),ITYPE(NAT+N))

         !Note -- Atoms Are in STANDARD Order!

         iATM = 0

         Do i=1,NRES

            RNAME = RESN(i)

            NSKIP = 4
            iPHOS = 0

            If (RESN(i) .EQ. 'ADP')Then
            NSKIP = 9
            RNAME = 'RA '
            iPHOS = 1
            EndIf

            If (RESN(i) .EQ. 'GDP')Then
            NSKIP = 9
            RNAME = 'RG '
            iPHOS = 1
            EndIf

            If (RESN(i) .EQ. 'ATP')Then
            NSKIP = 13
            RNAME = 'RA '
            iPHOS = 1
            EndIf

            If (RESN(i) .EQ. 'GTP')Then
            NSKIP = 13
            RNAME = 'RG '
            iPHOS = 1
            EndIf


            jS = Iabs(IRES(i))

            If (i .NE. NRES)Then
            jE = Iabs(IRES(i+1)) - 1
            Else
            jE = NAT
            EndIf

            j = jS

            !Get NEW IRES!

            If (IRES(i) .LT. 0)Then
            IRES(i) = -(iATM + 1)
            Else
            IRES(i) = iATM + 1
            EndIf

            !Check for missing Phosphate!
            !Missing Phosphate!

            If (ITOLD(j) .EQ. 8 .AND. ITOLD(j+1) .EQ. 6)Then
            If (IRES(i) .LT. 0)Then

               iATM = iATM + 1

               ITYPE(iATM) = 15
               ITYPE(iATM+1) = 8
               ITYPE(iATM+2) = 8
               ITYPE(iATM+3) = ITOLD(j)

               Do k=1,3
               RAT(iATM,k) = 0.0d0
               RAT(iATM+1,k) = 0.0d0
               RAT(iATM+2,k) = 0.0d0
               RAT(iATM+3,k) = ROLD(j,k)
               EndDo

               j = j + 1

               iATM = iATM + 3

               Call TwoCoord(RAT(iATM,:),RAT(iATM-3,:),ROLD(j,:))

               Call ThreeCoord (RAT(iATM-3,:),RAT(iATM-2,:),&
                              & RAT(iATM-1,:),RAT(iATM,:))

            Else

               Write(*,*)'ERROR: A NON 5 PRIME NUCLEIC ACID IS'
               Write(*,*)'MISSING ITS PHOSPHORUS. I CAN NOT PROCEED'

            EndIf
            Else

               !No missing Phosphate!

               Do k=1,NSKIP

               iATM = iATM + 1

               ITYPE(iATM) = ITOLD(j)
               Do l=1,3
               RAT(iATM,l) = ROLD(j,l)
               EndDo

               j = j + 1

               EndDo

            EndIf

            !Add two hydrogens to C5!

            NH = 2

            Call CreateH (RAT,ITYPE,ROLD,ITOLD,NAT,N,j,iATM,NH)

            !Add 1 hydrogen to C4!

            NH = 1

            Call CreateH (RAT,ITYPE,ROLD,ITOLD,NAT,N,j,iATM,NH)

            !Write out O4 oxygen!

            iATM = iATM + 1

            ITYPE(iATM) = ITOLD(j)
            Do k=1,3
            RAT(iATM,k) = ROLD(j,k)
            EndDo

            j = j + 1

            !Add one hydrogen to C1!

            NH = 1

            Call CreateH (RAT,ITYPE,ROLD,ITOLD,NAT,N,j,iATM,NH)


            !NOW WE WRITE OUT THE BASE!

            !Adenine DA or RA!

            If (RNAME(2:2) .EQ. 'A')Then

               iATM = iATM + 1

               ITYPE(iATM) = ITOLD(j)
               Do l=1,3
               RAT(iATM,l) = ROLD(j,l)
               EndDo

               j = j + 1

               NH = 1

               Call CreateH (RAT,ITYPE,ROLD,ITOLD,NAT,N,j,iATM,NH)

               Do k=1,3

               iATM = iATM + 1

               ITYPE(iATM) = ITOLD(j)
               Do l=1,3
               RAT(iATM,l) = ROLD(j,l)
               EndDo

               j = j + 1

               EndDo

               NH = 2

               Call CreateH (RAT,ITYPE,ROLD,ITOLD,NAT,N,j,iATM,NH)

               iATM = iATM + 1

               ITYPE(iATM) = ITOLD(j)
               Do l=1,3
               RAT(iATM,l) = ROLD(j,l)
               EndDo

               j = j + 1

               NH = 1

               Call CreateH (RAT,ITYPE,ROLD,ITOLD,NAT,N,j,iATM,NH)

               Do k=1,2

               iATM = iATM + 1

               ITYPE(iATM) = ITOLD(j)
               Do l=1,3
               RAT(iATM,l) = ROLD(j,l)
               EndDo

               j = j + 1

               EndDo

            EndIf

            !Guanine DG or RG!

            If (RNAME(2:2) .EQ. 'G')Then

               iATM = iATM + 1

               ITYPE(iATM) = ITOLD(j)
               Do l=1,3
               RAT(iATM,l) = ROLD(j,l)
               EndDo

               j = j + 1

               NH = 1

               Call CreateH (RAT,ITYPE,ROLD,ITOLD,NAT,N,j,iATM,NH)

               Do k=1,4

               iATM = iATM + 1

               ITYPE(iATM) = ITOLD(j)
               Do l=1,3
               RAT(iATM,l) = ROLD(j,l)
               EndDo

               j = j + 1

               EndDo

               NH = 1

               Call CreateH (RAT,ITYPE,ROLD,ITOLD,NAT,N,j,iATM,NH)

               iATM = iATM + 1

               ITYPE(iATM) = ITOLD(j)
               Do l=1,3
               RAT(iATM,l) = ROLD(j,l)
               EndDo

               j = j + 1

               NH = 2

               Call CreateH (RAT,ITYPE,ROLD,ITOLD,NAT,N,j,iATM,NH)

               Do k=1,2

               iATM = iATM + 1

               ITYPE(iATM) = ITOLD(j)
               Do l=1,3
               RAT(iATM,l) = ROLD(j,l)
               EndDo

               j = j + 1

               EndDo

            EndIf

            !Thymine DT!

            If (RNAME .EQ. 'DT ')Then

               iATM = iATM + 1

               ITYPE(iATM) = ITOLD(j)
               Do l=1,3
               RAT(iATM,l) = ROLD(j,l)
               EndDo

               j = j + 1

               NH = 1

               Call CreateH (RAT,ITYPE,ROLD,ITOLD,NAT,N,j,iATM,NH)

               iATM = iATM + 1

               ITYPE(iATM) = ITOLD(j)
               Do l=1,3
               RAT(iATM,l) = ROLD(j,l)
               EndDo

               j = j + 1

               NH = 3

               Call CreateH (RAT,ITYPE,ROLD,ITOLD,NAT,N,j,iATM,NH)

               Do k=1,2

               iATM = iATM + 1

               ITYPE(iATM) = ITOLD(j)
               Do l=1,3
               RAT(iATM,l) = ROLD(j,l)
               EndDo

               j = j + 1

               EndDo

               NH = 1

               Call CreateH (RAT,ITYPE,ROLD,ITOLD,NAT,N,j,iATM,NH)

               Do k=1,2

               iATM = iATM + 1

               ITYPE(iATM) = ITOLD(j)
               Do l=1,3
               RAT(iATM,l) = ROLD(j,l)
               EndDo

               j = j + 1

               EndDo

            EndIf

            !Uracil RU!

            If (RNAME .EQ. 'RU ')Then

               iATM = iATM + 1

               ITYPE(iATM) = ITOLD(j)
               Do l=1,3
               RAT(iATM,l) = ROLD(j,l)
               EndDo

               j = j + 1

               Do k=1,2

               NH = 1

               Call CreateH (RAT,ITYPE,ROLD,ITOLD,NAT,N,j,iATM,NH)

               EndDo

               Do k=1,2

               iATM = iATM + 1

               ITYPE(iATM) = ITOLD(j)
               Do l=1,3
               RAT(iATM,l) = ROLD(j,l)
               EndDo

               j = j + 1

               EndDo

               NH = 1

               Call CreateH (RAT,ITYPE,ROLD,ITOLD,NAT,N,j,iATM,NH)

               Do k=1,2

               iATM = iATM + 1

               ITYPE(iATM) = ITOLD(j)
               Do l=1,3
               RAT(iATM,l) = ROLD(j,l)
               EndDo

               j = j + 1

               EndDo

            EndIf

            !Cytosine DC or RC!

            If (RNAME(2:2) .EQ. 'C')Then

               iATM = iATM + 1

               ITYPE(iATM) = ITOLD(j)
               Do l=1,3
               RAT(iATM,l) = ROLD(j,l)
               EndDo

               j = j + 1

               Do k=1,2

               NH = 1

               Call CreateH (RAT,ITYPE,ROLD,ITOLD,NAT,N,j,iATM,NH)

               EndDo

               iATM = iATM + 1

               ITYPE(iATM) = ITOLD(j)
               Do l=1,3
               RAT(iATM,l) = ROLD(j,l)
               EndDo

               j = j + 1

               NH = 2

               Call CreateH (RAT,ITYPE,ROLD,ITOLD,NAT,N,j,iATM,NH)

               Do k=1,3

               iATM = iATM + 1

               ITYPE(iATM) = ITOLD(j)
               Do l=1,3
               RAT(iATM,l) = ROLD(j,l)
               EndDo

               j = j + 1

               EndDo

            EndIf

            !Write Out C3 Group!

            NH = 1

            Call CreateH (RAT,ITYPE,ROLD,ITOLD,NAT,N,j,iATM,NH)

            !Write out C2 Group!

            If (RNAME(1:1) .EQ. 'D')Then

               NH = 2

               Call CreateH (RAT,ITYPE,ROLD,ITOLD,NAT,N,j,iATM,NH)

            ElseIf (RNAME(1:1) .EQ. 'R')Then

               Do k=1,2

               NH = 1

               Call CreateH (RAT,ITYPE,ROLD,ITOLD,NAT,N,j,iATM,NH)

               EndDo

            EndIf

            !Write Out O3 Oxygen!

            iATM = iATM + 1

            ITYPE(iATM) = ITOLD(j)
            Do l=1,3
            RAT(iATM,l) = ROLD(j,l)
            EndDo

            j = j + 1

            !Write out Hydrogen for ADP ATP GDP GTP!

            If (iPHOS .EQ. 1)Then

               iATM = iATM + 1

               ITYPE(iATM) = 1
               Do l=1,3
               RAT(iATM,l) = 0.0d0
               EndDo

            EndIf

         EndDo


         !Now Fix Hydrogen Positions!

         NAT = NAT + N

         Do i=1,NRES

            RNAME = RESN(i)

            NSKIP = 4
            iPHOS = 0

            If (RESN(i) .EQ. 'ADP')Then
            NSKIP = 9
            RNAME = 'RA '
            iPHOS = 1
            EndIf

            If (RESN(i) .EQ. 'GDP')Then
            NSKIP = 9
            RNAME = 'RG '
            iPHOS = 1
            EndIf

            If (RESN(i) .EQ. 'ATP')Then
            NSKIP = 13
            RNAME = 'RA '
            iPHOS = 1
            EndIf

            If (RESN(i) .EQ. 'GTP')Then
            NSKIP = 13
            RNAME = 'RG '
            iPHOS = 1
            EndIf


            jS = Iabs(IRES(i))

            If (i .NE. NRES)Then
            jE = Iabs(IRES(i+1)) - 1
            Else
            jE = NAT
            EndIf

            j = jS + NSKIP         !Skip Phosphate group(s)!

            !C5 Hydrogens!

            Call FourCoord (RAT(j,:),RAT(j-1,:),RAT(j+1,:),&
                          & RAT(j+2,:),RAT(j+3,:))

            j = j + 3

            !C4 Hydrogen!

            jshift = 5

            If (RNAME(1:1) .EQ. 'R')Then
            If (iPHOS .EQ. 0)jshift = 6
            If (iPHOS .EQ. 1)jshift = 7
            EndIf

            Call FourCoord (RAT(j,:),RAT(j-1,:),RAT(j+1,:),&
                          & RAT(j+2,:),RAT(jE-jshift,:))

            j = j + 3

            !C1 Hydrogen!

            jshift = 3

            If (RNAME(1:1) .EQ. 'R')Then
            If (iPHOS .EQ. 0)jshift = 4
            If (iPHOS .EQ. 1)jshift = 5
            EndIf

            Call FourCoord (RAT(j,:),RAT(j-1,:),RAT(j+1,:),&
                          & RAT(j+2,:),RAT(jE-jshift,:))

            j = j + 3

            !Adenine DA or RA!

            If (RNAME(2:2) .EQ. 'A')Then

               Call ThreeCoord (RAT(j,:),RAT(j-1,:),&
                              & RAT(j+1,:),RAT(j+2,:))

               j = j + 5

               Do k=1,2

               Call ThreeCoord (RAT(j,:),RAT(j-1,:),&
                              & RAT(j+1,:),RAT(j+2,:))

               j = j + 4

               EndDo

            EndIf

            !Guanine DG or RG!

            If (RNAME(2:2) .EQ. 'G')Then

               Call ThreeCoord (RAT(j,:),RAT(j-1,:),&
                              & RAT(j+1,:),RAT(j+2,:))

               j = j + 6

               Call ThreeCoord (RAT(j,:),RAT(j-2,:),&
                              & RAT(j+1,:),RAT(j+2,:))

               j = j + 3

               Call ThreeCoord (RAT(j,:),RAT(j-1,:),&
                              & RAT(j+1,:),RAT(j+2,:))

               j = j + 5

            EndIf

            !Thymine DT!

            If (RNAME .EQ. 'DT ')Then

               Call ThreeCoord (RAT(j,:),RAT(j-1,:),&
                              & RAT(j+1,:),RAT(j+2,:))

               j = j + 3

               Call FourCoord (RAT(j,:),RAT(j-1,:),RAT(j+1,:),&
                             & RAT(j+2,:),RAT(j+3,:))

               j = j + 6

               Call ThreeCoord (RAT(j,:),RAT(j-2,:),&
                              & RAT(j+1,:),RAT(j+2,:))

               j = j + 4

            EndIf

            !Uracil RU!

            If (RNAME .EQ. 'RU ')Then

               Call ThreeCoord (RAT(j,:),RAT(j-1,:),&
                              & RAT(j+1,:),RAT(j+2,:))

               j = j + 2

               Do k=1,2

               Call ThreeCoord (RAT(j,:),RAT(j-2,:),&
                              & RAT(j+1,:),RAT(j+2,:))

               j = j + 4

               EndDo

            EndIf

            !Cytosine DC or RC!

            If (RNAME(2:2) .EQ. 'C')Then

               Call ThreeCoord (RAT(j,:),RAT(j-1,:),&
                              & RAT(j+1,:),RAT(j+2,:))

               j = j + 2

               Call ThreeCoord (RAT(j,:),RAT(j-2,:),&
                              & RAT(j+1,:),RAT(j+2,:))

               j = j + 3

               Call ThreeCoord (RAT(j,:),RAT(j-1,:),&
                              & RAT(j+1,:),RAT(j+2,:))

               j = j + 6

            EndIf

            !Fix C3 Hydrogen!

            k = jE
            jshift = NSKIP + 3
            If (iPHOS .EQ. 1)k = jE-1

            Call FourCoord (RAT(j,:),RAT(j+1,:),RAT(j+2,:),&
                          & RAT(jS+jshift,:),RAT(k,:))

            j = j + 2

            !Fix C2 Hydrogens!

            jshift = NSKIP + 6
 
            Call FourCoord (RAT(j,:),RAT(j-2,:),RAT(j+1,:),&
                          & RAT(j+2,:),RAT(jS+jshift,:))
 
            If (RNAME(1:1) .EQ. 'R')Then

               j = j + 2

               Call TwoCoord (RAT(j,:),RAT(j-2,:),RAT(j+1,:))

            EndIf


            !If ADP ATP GDP or GTP fix last Hydrogen!

            If (iPHOS .EQ. 1)Then

               j = j + 2

               Call TwoCoord (RAT(j,:),RAT(j-6,:),RAT(j+1,:))

            EndIf
 
         EndDo

         Return

      End Subroutine
