! Subroutine: AdjustEND
! Purpose: Adjusts the 5' and 3' ends of a nucleic acid strand.
! Written: May 4th 2008
! Last Update: April 7th 2009
! Author: Eric Dykeman

! NOTES: VARIABLES
!        SystemParam - Global variables
!
!        DEPENDANCIES
!        TwoCoord FourCoord
!

! **********************************************************************

      Subroutine AdjustEND

         Use SystemParam, Only : RAT,ITYPE,IRES,RESN,NAT,NRES

         Implicit None

      !Variable Declaration!

      !Local Variables!

         Double Precision, Dimension(:,:), Allocatable :: RNEW
         Integer, Dimension(:), Allocatable :: ITNEW,IRNEW

         Integer i,j,k,jS,jE,iATM,NNEW,iCHOICE,iPHOS
         Character RJUNK*3,RESNEW*3,JUNK*3

         Dimension RESNEW(NRES)

      !ROUTINE!

         !Copy residue names into temporary working array!

         Do i=1,NRES
         RESNEW(i) = RESN(i)
         EndDo

         !THREE CHOICES FOR ENDS ADJUSTMENT!

         !Choice 0 - 5' with P- (NO OH) and 3' with O- (NO H)!
         !Choice 1 - 5' with P-OH and 3' with OH!
         !Choice 2 - 5' with OH (NO PHOSPATE) and 3' with OH!

         !ADJUST ENDS!

         Write(*,*)'WHAT TYPE OF 5 AND 3 PRIME ENDS WOULD YOU LIKE'
         Write(*,*)'5 WITH P-   AND 3 WITH O-  --> ENTER 0'
         Write(*,*)'5 WITH P-OH AND 3 WITH O-H --> ENTER 1'
         Write(*,*)'5 WITH  -OH AND 3 WITH O-H --> ENTER 2'
         Write(*,*)' '
         Write(*,*)'NOTE: THE DEFAULT IS CHOICE 0'
         Read(*,*)iCHOICE
         Write(*,*)' '

         !NOTE: iCHOICE = 0 IS THE DEFAULT!
         !SO NOTHING TO DO FOR THIS CASE!

         !5' END IS DA etc. and 3' END IS DA etc.!

         If (iCHOICE .EQ. 1)Then

            !5' END IS DAP etc. and 3' END IS DA3 etc.!

            Do i=1,NRES-1

               If (IRES(i) .LT. 0)Then
               If (RESN(i) .EQ. 'DA')RESNEW(i) = 'DAP'
               If (RESN(i) .EQ. 'DG')RESNEW(i) = 'DGP'
               If (RESN(i) .EQ. 'DT')RESNEW(i) = 'DTP'
               If (RESN(i) .EQ. 'DC')RESNEW(i) = 'DCP'
               If (RESN(i) .EQ. 'RA')RESNEW(i) = 'RAP'
               If (RESN(i) .EQ. 'RG')RESNEW(i) = 'RGP'
               If (RESN(i) .EQ. 'RU')RESNEW(i) = 'RUP'
               If (RESN(i) .EQ. 'RC')RESNEW(i) = 'RCP'
               EndIf

               If (IRES(i+1) .LT. 0)Then
               If (RESN(i) .EQ. 'DA')RESNEW(i) = 'DA3'
               If (RESN(i) .EQ. 'DG')RESNEW(i) = 'DG3'
               If (RESN(i) .EQ. 'DT')RESNEW(i) = 'DT3'
               If (RESN(i) .EQ. 'DC')RESNEW(i) = 'DC3'
               If (RESN(i) .EQ. 'RA')RESNEW(i) = 'RA3'
               If (RESN(i) .EQ. 'RG')RESNEW(i) = 'RG3'
               If (RESN(i) .EQ. 'RU')RESNEW(i) = 'RU3'
               If (RESN(i) .EQ. 'RC')RESNEW(i) = 'RC3'
               EndIf

            EndDo

            If (RESN(NRES) .EQ. 'DA')RESNEW(NRES) = 'DA3'
            If (RESN(NRES) .EQ. 'DG')RESNEW(NRES) = 'DG3'
            If (RESN(NRES) .EQ. 'DT')RESNEW(NRES) = 'DT3'
            If (RESN(NRES) .EQ. 'DC')RESNEW(NRES) = 'DC3'
            If (RESN(NRES) .EQ. 'RA')RESNEW(NRES) = 'RA3'
            If (RESN(NRES) .EQ. 'RG')RESNEW(NRES) = 'RG3'
            If (RESN(NRES) .EQ. 'RU')RESNEW(NRES) = 'RU3'
            If (RESN(NRES) .EQ. 'RC')RESNEW(NRES) = 'RC3'

         ElseIf (iCHOICE .EQ. 2)Then

            !5' END IS DA5 etc. and 3' END IS DA3 etc.!

            Do i=1,NRES-1

               If (IRES(i) .LT. 0)Then
               If (RESN(i) .EQ. 'DA')RESNEW(i) = 'DA5'
               If (RESN(i) .EQ. 'DG')RESNEW(i) = 'DG5'
               If (RESN(i) .EQ. 'DT')RESNEW(i) = 'DT5'
               If (RESN(i) .EQ. 'DC')RESNEW(i) = 'DC5'
               If (RESN(i) .EQ. 'RA')RESNEW(i) = 'RA5'
               If (RESN(i) .EQ. 'RG')RESNEW(i) = 'RG5'
               If (RESN(i) .EQ. 'RU')RESNEW(i) = 'RU5'
               If (RESN(i) .EQ. 'RC')RESNEW(i) = 'RC5'
               EndIf

               If (IRES(i+1) .LT. 0)Then
               If (RESN(i) .EQ. 'DA')RESNEW(i) = 'DA3'
               If (RESN(i) .EQ. 'DG')RESNEW(i) = 'DG3'
               If (RESN(i) .EQ. 'DT')RESNEW(i) = 'DT3'
               If (RESN(i) .EQ. 'DC')RESNEW(i) = 'DC3'
               If (RESN(i) .EQ. 'RA')RESNEW(i) = 'RA3'
               If (RESN(i) .EQ. 'RG')RESNEW(i) = 'RG3'
               If (RESN(i) .EQ. 'RU')RESNEW(i) = 'RU3'
               If (RESN(i) .EQ. 'RC')RESNEW(i) = 'RC3'
               EndIf

            EndDo

            If (RESN(NRES) .EQ. 'DA')RESNEW(NRES) = 'DA3'
            If (RESN(NRES) .EQ. 'DG')RESNEW(NRES) = 'DG3'
            If (RESN(NRES) .EQ. 'DT')RESNEW(NRES) = 'DT3'
            If (RESN(NRES) .EQ. 'DC')RESNEW(NRES) = 'DC3'
            If (RESN(NRES) .EQ. 'RA')RESNEW(NRES) = 'RA3'
            If (RESN(NRES) .EQ. 'RG')RESNEW(NRES) = 'RG3'
            If (RESN(NRES) .EQ. 'RU')RESNEW(NRES) = 'RU3'
            If (RESN(NRES) .EQ. 'RC')RESNEW(NRES) = 'RC3'

         EndIf


         !Copy over changes!

         Do i=1,NRES
         RESN(i) = RESNEW(i)
         EndDo

         !Now fix selected nucleic acids!

         NNEW = 0

         Do i=1,NRES

            JUNK = RESN(i)

            If (JUNK(3:3) .EQ. 'P')Then
            If (JUNK(1:1) .EQ. 'D')NNEW = NNEW + 2
            If (JUNK(1:1) .EQ. 'R')NNEW = NNEW + 2
            EndIf

            If (JUNK(3:3) .EQ. '5')NNEW = NNEW - 2
            If (JUNK(3:3) .EQ. '3')NNEW = NNEW + 1

         EndDo

         Allocate (RNEW(NAT+NNEW,3),ITNEW(NAT+NNEW))
         Allocate (IRNEW(NRES))

         iATM = 0

         Do i=1,NRES

            !First Get NEW IRES assignemnt!

            IRNEW(i) = iATM + 1
            If (IRES(i) .LT. 0)IRNEW(i) = -IRNEW(i)

            JUNK = RESN(i)

            iPHOS = 0

            If (JUNK .EQ. 'ADP')iPHOS = 1
            If (JUNK .EQ. 'GDP')iPHOS = 1
            If (JUNK .EQ. 'ATP')iPHOS = 1
            If (JUNK .EQ. 'GTP')iPHOS = 1

            !Now copy over nucleic acid!

            jS = Iabs(IRES(i))

            If (i .LT. NRES)Then
            jE = Iabs(IRES(i+1)) - 1
            Else
            jE = NAT
            EndIf

            If (JUNK(3:3) .EQ. 'P' .AND. iPHOS .EQ. 0)Then

               iATM = iATM + 1
               ITNEW(iATM) = 1

               iATM = iATM + 1
               ITNEW(iATM) = 8

               Do k=1,3
               RNEW(iATM-1,k) = 0.0d0
               RNEW(iATM,k) = 0.0d0
               EndDo

               Do j=jS,jE

                  iATM = iATM + 1
                  ITNEW(iATM) = ITYPE(j)

                  Do k=1,3
                  RNEW(iATM,k) = RAT(j,k)
                  EndDo

               EndDo

               k = jE + 1 - jS

               Call FourCoord (RNEW(iATM-k+1,:),RNEW(iATM-k,:),&
                             & RNEW(iATM-k+2,:),RNEW(iATM-k+3,:),&
                             & RNEW(iATM-k+4,:))

               Call TwoCoord (RNEW(iATM-k,:),RNEW(iATM-k-1,:),&
                            & RNEW(iATM-k+1,:))

               jS = 0

            EndIf

            If (JUNK(3:3) .EQ. '5')Then

               iATM = iATM + 1
               ITNEW(iATM) = 1

               Do k=1,3
               RNEW(iATM,k) = 0.0d0
               EndDo

               Do j=jS+3,jE

                  iATM = iATM + 1
                  ITNEW(iATM) = ITYPE(j)

                  Do k=1,3
                  RNEW(iATM,k) = RAT(j,k)
                  EndDo

               EndDo

               k = jE - jS - 1

               Call TwoCoord (RNEW(iATM-k+2,:),RNEW(iATM-k+1,:),&
                            & RNEW(iATM-k+3,:))

               jS = 0

            EndIf

            If (JUNK(3:3) .EQ. '3')Then

               Do j=jS,jE

                  iATM = iATM + 1
                  ITNEW(iATM) = ITYPE(j)

                  Do k=1,3
                  RNEW(iATM,k) = RAT(j,k)
                  EndDo

               EndDo

               iATM = iATM + 1
               ITNEW(iATM) = 1

               Do k=1,3
               RNEW(iATM,k) = 0.0d0
               EndDo

               Call TwoCoord (RNEW(iATM-1,:),RNEW(iATM,:),&
                              & RAT(jE-5,:))

               jS = 0

            EndIf

            !Finish copying over rest of atoms!
            !OR copy over entire nucleic acid if!
            !It is unchanged!

            If (jS .NE. 0)Then

               Do j=jS,jE

                  iATM = iATM + 1
                  ITNEW(iATM) = ITYPE(j)

                  Do k=1,3
                  RNEW(iATM,k) = RAT(j,k)
                  EndDo

               EndDo

            EndIf

         EndDo

         !Copy RNEW over to RAT!

         Deallocate (RAT,ITYPE)

         NAT = NAT + NNEW

         Allocate (RAT(NAT,3),ITYPE(NAT))

         Do i=1,NAT
         ITYPE(i) = ITNEW(i)
         Do j=1,3
         RAT(i,j) = RNEW(i,j)
         EndDo
         EndDo

         !Copy IRNEW over to IRES!

         Do i=1,NRES
         IRES(i) = IRNEW(i)
         EndDo

         Deallocate (RNEW,ITNEW,IRNEW)

         Return

      End Subroutine
