! Subroutine: Analyze
! Purpose: Performs Three Tasks:
!          1) Find Sugar And Nucleoside Atoms. 
!          2) Assign Nucleoside Names.
!          3) Place Each Nucleic acid's Atoms in AMBER order
! Written: September 14th 2007
! Last Update: April 7th 2009
! Author: Eric Dykeman

! NOTES: VARIABLES
!             RAT - (NAT,3) List of Atomic Coordinates
!           ITYPE - (NAT) List of Atom Types
!            RESN - (NRES) Nucleic Acid Residue Name
!            IRES - (NRES) Atom number of the P in Nucleic Acid
!             NAT - Total Number of Atoms in the System
!            NRES - Number of Amino Acid Residues
!
!        DEPENDANCIES
!        SystemParam Neighbors Chemistry Order
!

! **********************************************************************

      Subroutine Analyze

         Use SystemParam, Only : RAT,ITYPE,RESN,IRES,NAT,NRES

         Implicit None

      !Variable Declaration!

      !Local Variables!

         Double Precision, Dimension(:,:), Allocatable :: RNEW
         Integer, Dimension(:,:), Allocatable :: LNEIGH
         Integer, Dimension(:), Allocatable :: NNEIGH,ITNEW

         Character*3 CWRK,JUNK
         Logical OK
         Integer NNMAX,iHCNOP,iATM,iTOT
         Integer IWRK,IWRT,iPRES,iNEXT,iLAST,NP,iNP
         Integer i,j,k,jS,jE,iC(5),iP,iNB,iO4,iO5

         Parameter (NNMAX = 4)   !Maximum Number of Neighbors!

         Dimension iHCNOP(5),CWRK(NAT)
         Dimension IWRK(NAT),IWRT(NAT)

      !ROUTINE!

         Allocate (RNEW(NAT,3),ITNEW(NAT))
         Allocate (LNEIGH(NAT,NNMAX),NNEIGH(NAT))

         Do i=1,NAT
         IWRT(i) = 0
         EndDo

         !Form Neighbor Map of Bonded Atoms!

         Call Neighbors (RAT,ITYPE,LNEIGH,NNEIGH,NAT,NNMAX)

         NRES = 0
         iATM = 0

         Do i=1,NAT

            Do j=1,5
            iC(j) = 0       !Atom Number for Sugar Cj j=1,5!
            EndDo

            iNB = 0         !Atom Number Nitrogen in base!
            iO4 = 0         !Atom Number for O4 Oxygen!
            iO5 = 0         !Atom Number for O5 Oxygen!
            iP = 0          !Atom Number for Phosphate!

            NP = 0          !Number of phosphate groups!

            !Find Sugar Carbons and Phosphate!

            If (ITYPE(i) .EQ. 6)Then

               !C1 is bonded to 1 Nitrogen!
               !1 Carbon and 1 Oxygen!

               Call Chemistry (LNEIGH(i,:),NNEIGH(i),&
                             & ITYPE,NAT,NNMAX,iHCNOP)

               If (iHCNOP(2) .NE. 1)Goto 10
               If (iHCNOP(3) .NE. 1)Goto 10
               If (iHCNOP(4) .NE. 1)Goto 10

               !OK POSSIBLE C1 -- Log Atom numbers!

               iC(1) = i

               Do k=1,NNEIGH(i)
               j = LNEIGH(i,k)
               If (ITYPE(j) .EQ. 7)iNB = j
               If (ITYPE(j) .EQ. 6)iC(2) = j
               If (ITYPE(j) .EQ. 8)iO4 = j
               EndDo

               !THERE ARE 3 EXCEPTIONS!
               !The bases of GUA THY and URA!

               !C1's oxygen neighbor (O4) should have!
               !ONLY TWO CARBON NEIGHBORS!

               Call Chemistry (LNEIGH(iO4,:),NNEIGH(iO4),&
                             & ITYPE,NAT,NNMAX,iHCNOP)

               If (iHCNOP(2) .NE. 2)Goto 10

               !OK THIS IS C1!
               !Find C3,C4,C5,O5,P!

               NRES = NRES + 1

               Do k=1,NNEIGH(iC(2))
               j = LNEIGH(iC(2),k)
               If (ITYPE(j) .EQ. 6)Then
               If (j .NE. iC(1))iC(3) = j
               EndIf
               EndDo

               Do k=1,NNEIGH(iO4)
               j = LNEIGH(iO4,k)
               If (j .NE. iC(1))iC(4) = j
               EndDo

               Do k=1,NNEIGH(iC(4))
               j = LNEIGH(iC(4),k)
               If (ITYPE(j) .EQ. 6)Then
               If (j .NE. iC(3))iC(5) = j
               EndIf
               EndDo

               !Look for Phosphorus!

               Do k=1,NNEIGH(iC(5))

                  j = LNEIGH(iC(5),k)

                  If (ITYPE(j) .EQ. 8)Then

                     iO5 = j

                     If (ITYPE(LNEIGH(j,1)) .EQ. 15)Then
                     iP = LNEIGH(j,1)
                     NP = NP + 1
                     ElseIf (NNEIGH(j) .EQ. 2)Then
                     If (ITYPE(LNEIGH(j,2)) .EQ. 15)Then
                     iP = LNEIGH(j,2)
                     NP = NP + 1
                     EndIf
                     EndIf

                  EndIf

               EndDo

               !Check for Di-Phosphate or Tri-Phosphate!

               If (iP .NE. 0)Then

                  iNEXT = 0
                  iPRES = iP
                  iLAST = iO5

                  !Order Phosphate Neighbors!

                  Call Order (LNEIGH,NNEIGH,ITYPE,NAT,NNMAX,iPRES,iLAST)
                  iLAST = LNEIGH(iPRES,NNEIGH(iPRES)-1)

                  If (NNEIGH(iLAST) .EQ. 2)Then
                  If (LNEIGH(iLAST,1) .EQ. iPRES)Then
                  iNEXT = LNEIGH(iLAST,2)
                  ElseIf (LNEIGH(iLAST,2) .EQ. iPRES)Then
                  iNEXT = LNEIGH(iLAST,1)
                  EndIf
                  EndIf

                  If (iNEXT .NE. 0)Then
                  If (ITYPE(iNEXT) .EQ. 15)Then
                  iPRES = iNEXT
                  NP = NP + 1
                  EndIf
                  EndIf

                  iNEXT = 0

                  If (NP .EQ. 2)Then
                  Call Order (LNEIGH,NNEIGH,ITYPE,NAT,NNMAX,iPRES,iLAST)
                  iLAST = LNEIGH(iPRES,NNEIGH(iPRES)-1)
                  EndIf

                  If (NNEIGH(iLAST) .EQ. 2)Then
                  If (LNEIGH(iLAST,1) .EQ. iPRES)Then
                  iNEXT = LNEIGH(iLAST,2)
                  ElseIf (LNEIGH(iLAST,2) .EQ. iPRES)Then
                  iNEXT = LNEIGH(iLAST,1)
                  EndIf
                  EndIf

                  If (iNEXT .NE. 0)Then
                  If (ITYPE(iNEXT) .EQ. 15)Then
                  iPRES = iNEXT
                  NP = NP + 1
                  EndIf
                  EndIf

                  If (NP .EQ. 3)Then
                  Call Order (LNEIGH,NNEIGH,ITYPE,NAT,NNMAX,iPRES,iLAST)
                  EndIf

                  iP = iPRES

               EndIf


               !Copy Atom Coordinates!

               !Write out Phosphates (if present)!

               If (iP .NE. 0)Then

                  !Log the first atom number into IRES!

                  IWRK(NRES) = iATM + 1

                  !Write out OXY if Di or Tri Phosphate!

                  If (NP .GT. 1)Then

                     j = LNEIGH(iP,1)

                     IWRT(j) = IWRT(j) + 1

                     iATM = iATM + 1

                     ITNEW(iATM) = ITYPE(j)

                     Do k=1,3
                     RNEW(iATM,k) = RAT(j,k)
                     EndDo

                  Else

                     !Check that this is not a 5' with!
                     !3 O double bonds!

                     j = 0

                     Do k=1,NNEIGH(iP)
                     If (NNEIGH(LNEIGH(iP,k)) .EQ. 1)Then
                     j = j + 1
                     If (j .EQ. 3)IWRT(LNEIGH(iP,k)) = 1
                     EndIf
                     EndDo

                  EndIf

                  !Write out BETA and/or GAMMA phosphates!

                  If (NP .GE. 2)Then
                  Do iNP=2,NP

                     iATM = iATM + 1

                     IWRT(iP) = IWRT(iP) + 1

                     ITNEW(iATM) = ITYPE(iP)

                     Do k=1,3
                     RNEW(iATM,k) = RAT(iP,k)
                     EndDo

                     Do k=1,NNEIGH(iP)
                     If (IWRT(LNEIGH(iP,k)) .EQ. 0)Then

                        j = LNEIGH(iP,k)

                        IWRT(j) = IWRT(j) + 1
                        iATM = iATM + 1

                        ITNEW(iATM) = ITYPE(j)
                        RNEW(iATM,1) = RAT(j,1)
                        RNEW(iATM,2) = RAT(j,2)
                        RNEW(iATM,3) = RAT(j,3)

                     EndIf
                     EndDo

                     j = LNEIGH(iP,NNEIGH(iP))

                     Do k=1,NNEIGH(j)
                     If (ITYPE(LNEIGH(j,k)) .EQ. 15)iP = LNEIGH(j,k)
                     EndDo

                  EndDo
                  EndIf

                  !Write out ALPHA Phosphate!

                  IWRT(iP) = IWRT(iP) + 1

                  iATM = iATM + 1

                  ITNEW(iATM) = ITYPE(iP)

                  Do k=1,3
                  RNEW(iATM,k) = RAT(iP,k)
                  EndDo

                  Do k=1,NNEIGH(iP)
                  If (IWRT(LNEIGH(iP,k)) .EQ. 0)Then

                     j = LNEIGH(iP,k)

                     If (NNEIGH(j) .EQ. 1)Then

                     IWRT(j) = IWRT(j) + 1
                     iATM = iATM + 1
                     ITNEW(iATM) = ITYPE(j)

                     RNEW(iATM,1) = RAT(j,1)
                     RNEW(iATM,2) = RAT(j,2)
                     RNEW(iATM,3) = RAT(j,3)

                     EndIf

                  EndIf
                  EndDo

               EndIf

               !Write out O5 oxygen!

               IWRT(iO5) = IWRT(iO5) + 1

               iATM = iATM + 1

               If (iP .EQ. 0)IWRK(NRES) = iATM

               ITNEW(iATM) = ITYPE(iO5)

               Do k=1,3
               RNEW(iATM,k) = RAT(iO5,k)
               EndDo

               !Write Out C5 and rest of sugar!

               Do j=1,5
               iHCNOP(j) = 0
               EndDo

               iNEXT = iC(5)     !Next Non H Atom to Write Out!
               iPRES = iC(5)     !Present Non H Atom We Are On!
               iLAST = iO5       !Last Non H Atom Written Out!

               OK = .TRUE.

               Do While (OK)

                  If (IWRT(iPRES) .EQ. 0)Then

                     Call Order (LNEIGH,NNEIGH,ITYPE,&
                               & NAT,NNMAX,iPRES,iLAST) 

                     IWRT(iPRES) = IWRT(iPRES) + 1

                     iATM = iATM + 1

                     ITNEW(iATM) = ITYPE(iPRES)
                     Do k=1,3
                     RNEW(iATM,k) = RAT(iPRES,k)
                     EndDo
!TEMP
                     If (ITYPE(iPRES) .EQ. 1)Then
                     Write(4,*)'ERROR!!! Writing out a hydrogen'
                     Stop
                     EndIf
!TEMP
                     If (ITYPE(iPRES) .EQ. 6)iHCNOP(2) = iHCNOP(2) + 1
                     If (ITYPE(iPRES) .EQ. 7)iHCNOP(3) = iHCNOP(3) + 1
                     If (ITYPE(iPRES) .EQ. 8)iHCNOP(4) = iHCNOP(4) + 1
                     If (ITYPE(iPRES) .EQ. 15)iHCNOP(5) = iHCNOP(5) + 1

                  EndIf

                  Do j=1,NNEIGH(iPRES)

                     iNEXT = LNEIGH(iPRES,j)

                     If (ITYPE(iNEXT) .EQ. 1)Then

                        If (IWRT(iNEXT) .EQ. 0)Then

                        IWRT(iNEXT) = IWRT(iNEXT) + 1

                        iATM = iATM + 1

                        ITNEW(iATM) = ITYPE(iNEXT)
                        Do k=1,3
                        RNEW(iATM,k) = RAT(iNEXT,k)
                        EndDo

                        EndIf

                     Else

                        If (IWRT(iNEXT) .EQ. 0)Goto 5

                     EndIf

                 EndDo

                 If (iNEXT .EQ. iNB)OK = .FALSE.

 5               Continue

                 iLAST = iPRES
                 iPRES = iNEXT

              EndDo

              !We have over counted base atoms by 3 C's!
              !and 1 O due to the sugar ... subtract these!

              iHCNOP(2) = iHCNOP(2) - 3
              iHCNOP(4) = iHCNOP(4) - 1

              iTOT = iHCNOP(4)  !Total Number of oxygens!

              !Only C3 and C2 should be left!
              !Copy over C3 and C2!

              IWRT(iC(3)) = IWRT(iC(3)) + 1

              iATM = iATM + 1

              ITNEW(iATM) = ITYPE(iC(3))
              Do k=1,3
              RNEW(iATM,k) = RAT(iC(3),k)
              EndDo

              Do k=1,NNEIGH(iC(3))

                 j = LNEIGH(iC(3),k)

                 If (ITYPE(j) .EQ. 1)Then

                    IWRT(j) = IWRT(j) + 1

                    iATM = iATM + 1
                    ITNEW(iATM) = ITYPE(j)
                    RNEW(iATM,1) = RAT(j,1)
                    RNEW(iATM,2) = RAT(j,2)
                    RNEW(iATM,3) = RAT(j,3)

                 EndIf

              EndDo

              IWRT(iC(2)) = IWRT(iC(2)) + 1

              iATM = iATM + 1

              ITNEW(iATM) = ITYPE(iC(2))
              Do k=1,3
              RNEW(iATM,k) = RAT(iC(2),k)
              EndDo

              Do k=1,NNEIGH(iC(2))

                 j = LNEIGH(iC(2),k)

                 If (ITYPE(j) .EQ. 1)Then

                    IWRT(j) = IWRT(j) + 1

                    iATM = iATM + 1
                    ITNEW(iATM) = ITYPE(j)
                    RNEW(iATM,1) = RAT(j,1)
                    RNEW(iATM,2) = RAT(j,2)
                    RNEW(iATM,3) = RAT(j,3)

                 EndIf

              EndDo

              !Check for OH group on C2 -- RNA!

              Do k=1,NNEIGH(iC(2))

                 j = LNEIGH(iC(2),k)

                 If (ITYPE(j) .EQ. 8)Then

                    iTOT = iTOT + 1

                    IWRT(j) = IWRT(j) + 1

                    iATM = iATM + 1
                    ITNEW(iATM) = ITYPE(j)
                    RNEW(iATM,1) = RAT(j,1)
                    RNEW(iATM,2) = RAT(j,2)
                    RNEW(iATM,3) = RAT(j,3)

                    If (NNEIGH(j) .EQ. 2)Then
                    If (ITYPE(LNEIGH(j,1)) .EQ. 1)Then
                    iATM = iATM + 1
                    ITNEW(iATM) = ITYPE(LNEIGH(j,1))
                    RNEW(iATM,1) = RAT(LNEIGH(j,1),1)
                    RNEW(iATM,2) = RAT(LNEIGH(j,1),2)
                    RNEW(iATM,3) = RAT(LNEIGH(j,1),3)
                    ElseIf (ITYPE(LNEIGH(j,2)) .EQ. 1)Then
                    iATM = iATM + 1
                    ITNEW(iATM) = ITYPE(LNEIGH(j,2))
                    RNEW(iATM,1) = RAT(LNEIGH(j,2),1)
                    RNEW(iATM,2) = RAT(LNEIGH(j,2),2)
                    RNEW(iATM,3) = RAT(LNEIGH(j,2),3)
                    EndIf
                    EndIf

                 EndIf

              EndDo

              !Now write out the Oxygen on C3!

              Do k=1,NNEIGH(iC(3))

                 j = LNEIGH(iC(3),k)

                 If (ITYPE(j) .EQ. 8)Then

                    IWRT(j) = IWRT(j) + 1

                    iATM = iATM + 1
                    ITNEW(iATM) = ITYPE(j)
                    RNEW(iATM,1) = RAT(j,1)
                    RNEW(iATM,2) = RAT(j,2)
                    RNEW(iATM,3) = RAT(j,3)

                 EndIf

              EndDo

              !What Residue is this!

              If (iHCNOP(3) .EQ. 5)then

                 If (iHCNOP(4) .EQ. 0)Then
                 If (iTOT .EQ. 0)CWRK(NRES) = 'DA '
                 If (iTOT .EQ. 1)CWRK(NRES) = 'RA '
                 EndIf

                 If (iHCNOP(4) .EQ. 1)Then
                 If (iTOT .EQ. 1)CWRK(NRES) = 'DG '
                 If (iTOT .EQ. 2)CWRK(NRES) = 'RG '
                 EndIf

              EndIf

              If (iHCNOP(3) .EQ. 3)Then

                 If (iTOT .EQ. 1)CWRK(NRES) = 'DC '
                 If (iTOT .EQ. 2)CWRK(NRES) = 'RC '

              EndIf

              If (iHCNOP(3) .EQ. 2)Then

                 If (iHCNOP(2) .EQ. 5)Then
                 If (iTOT .EQ. 2)CWRK(NRES) = 'DT '
                 If (iTOT .EQ. 3)Then
                 Write(*,*)'ERROR -- NO PARAMETERS FOR RNA THYMINE'
                 Stop
                 EndIf
                 EndIf

                 If (iHCNOP(2) .EQ. 4)Then
                 If (iTOT .EQ. 2)Then
                 Write(*,*)'ERROR -- NO PARAMETERS FOR DNA URACIL'
                 Stop
                 EndIf
                 If (iTOT .EQ. 3)CWRK(NRES) = 'RU '
                 EndIf

              EndIf

              !Check for ADP ATP GDP and GTP!

              If (NP .EQ. 2)Then

                 If (CWRK(NRES) .EQ. 'RA ')CWRK(NRES) = 'ADP'
                 If (CWRK(NRES) .EQ. 'RG ')CWRK(NRES) = 'GDP'

                 If (CWRK(NRES) .EQ. 'RU ')Then
                 Write(*,*)'ERROR -- NO PARAMETERS FOR URACIL DI-PHOS'
                 Stop
                 EndIf

                 If (CWRK(NRES) .EQ. 'RC ')Then
                 Write(*,*)'ERROR -- NO PARAMETERS FOR CYSTINE DI-PHOS'
                 Stop
                 EndIf

                 JUNK = CWRK(NRES)
                 If (JUNK(1:1) .EQ. 'D')Then
                 Write(*,*)'ERROR -- DI-PHOSPHATE PRESENT ON DNA'
                 Stop
                 EndIf

              ElseIf (NP .EQ. 3)Then

                 If (CWRK(NRES) .EQ. 'RA ')CWRK(NRES) = 'ATP'
                 If (CWRK(NRES) .EQ. 'RG ')CWRK(NRES) = 'GTP'

                 If (CWRK(NRES) .EQ. 'RU ')Then
                 Write(*,*)'ERROR -- NO PARAMETERS FOR URACIL TRI-PHOS'
                 Stop
                 EndIf

                 If (CWRK(NRES) .EQ. 'RC ')Then
                 Write(*,*)'ERROR -- NO PARAMETERS FOR CYSTINE TRI-PHOS'
                 Stop
                 EndIf

                 JUNK = CWRK(NRES)
                 If (JUNK(1:1) .EQ. 'D')Then
                 Write(*,*)'ERROR -- TRI-PHOSPHATE PRESENT ON DNA'
                 Stop
                 EndIf

              EndIf

           EndIf

 10        Continue

        EndDo

        !OK Have Located all nucleic acids!
        !Now Put Into proper Order 5' - 3'!

        Allocate (RESN(NRES),IRES(NRES))

        !Reallocate RAT, RNEW In Case We Striped of water!

        NAT = iATM

        Deallocate (RAT,ITYPE)
        Allocate (RAT(NAT,3),ITYPE(NAT))

        Do i=1,NAT

           ITYPE(i) = ITNEW(i)

           Do j=1,3
           RAT(i,j) = RNEW(i,j)
           EndDo

        EndDo

        Deallocate (LNEIGH,NNEIGH,RNEW,ITNEW)
        Allocate (RNEW(NAT,3),ITNEW(NAT))
        Allocate (NNEIGH(NAT),LNEIGH(NAT,NNMAX))

        Do i=1,NAT

           ITNEW(i) = ITYPE(i)

           Do j=1,3
           RNEW(i,j) = RAT(i,j)
           EndDo

        EndDo

        Call Neighbors (RNEW,ITNEW,LNEIGH,NNEIGH,NAT,NNMAX)

        iATM = 0
        iTOT = 0

        Do While (iATM .NE. NAT)

           !Find a 5' end!

           Do i=1,NRES
           If (IWRK(i) .NE. 0)Then

              j = IWRK(i)

              If (ITNEW(j) .EQ. 8)Then

                 iPRES = i
                 OK = .TRUE.
                 Goto 20

              ElseIf (ITNEW(j) .EQ. 15)Then

                 If (NNEIGH(j) .EQ. 3)Then
                 iPRES = i
                 OK = .TRUE.
                 Goto 20
                 EndIf

              EndIf

           EndIf
           EndDo

 20        iTOT = iTOT + 1

           jS = IWRK(iPRES)
           IWRK(iPRES) = 0

           If (iPRES .NE. NRES)Then
           jE = IWRK(iPRES+1) - 1
           Else
           jE = NAT
           EndIf

           RESN(iTOT) = CWRK(iPRES)
           IRES(iTOT) = iATM + 1

           !Make IRES negative if this is 5'!

           If (OK)Then
           IRES(iTOT) = -IRES(iTOT)
           OK = .FALSE.
           EndIf

           Do j=jS,jE
           iATM = iATM + 1
           ITYPE(iATM) = ITNEW(j)
           Do k=1,3
           RAT(iATM,k) = RNEW(j,k)
           EndDo
           EndDo

           !Find Next Residue!

           Do i=1,NNEIGH(jE)

              j = LNEIGH(jE,i)

              If (ITNEW(j) .EQ. 15)Then

                 Do k=1,NRES
                 If (IWRK(k) .EQ. j)Then
                 iPRES = k
                 Goto 20
                 EndIf
                 EndDo

              EndIf

           EndDo

        EndDo

        Return

      End Subroutine
