! Subroutine: AssignTC
! Purpose: Assigns types and charges for nucleic acids following the 
!          nucleic acid naming scheme. The nucleic acids are in AMBER order
!          i.e. the same order that appears in AMBER all_nuc94.dat
! Written: September 14th 2007
! Last Update: September 14th 2007
! Author: Eric Dykeman

! NOTES: VARIABLES
!        SystemParam - Global system parameters
!

! **********************************************************************

      Subroutine AssignTC

         Use SystemParam, Only : Q,ATMT,NAT,RESN,IRES,NRES

         Implicit None

      !Variable Declaration!

      !Local Variables!

         Double Precision QTMP
         Integer i,j,k,kS,kE,NARES,MAXR,MAXAT
         Character*72 FNAME,STR1,STR2
         Character*3 RTMP
         Character*2 ATMP

         Parameter (MAXR = 50)
         Parameter (MAXAT = 50)

         Dimension QTMP(MAXR,MAXAT),ATMP(MAXR,MAXAT),RTMP(MAXR)

      !ROUTINE!

         !File Locations!

         Write(*,*)'ENTERING Saguaro3.3/sdat/ FOR NUCLEIC CHARGES'

         FNAME = '/home/eric/Saguaro3.3/sdat/nuc94.dat'

         Open (Unit=10,File=FNAME,Status='Unknown')

         Read(10,*)i
         Read(10,*)STR1

         NARES = 1

         Read(10,*)STR1

         Do While (STR1 .NE. 'STOP')

            Read(10,11)RTMP(NARES)

            Do i=1,5
            Read(10,*)STR1
            EndDo

            Do i=1,MAXAT

               Read(10,*)STR1

               If (STR1 .NE. 'IMPROPER')Then

                  BackSpace(Unit = 10)
                  Read(10,12)STR1,STR2

                  Write(ATMP(NARES,i),13)STR1(14:15)
                  Read(STR2,*)QTMP(NARES,i)

               Else

                  Do While (STR1 .NE. 'DONE')
                  Read(10,*)STR1
                  EndDo

                  Goto 30

               EndIf

            EndDo

 30         NARES = NARES + 1

            Read(10,*)STR1

         EndDo

         NARES = NARES - 1

         Close (Unit = 10)

         Do i=1,NRES

            Do j=1,NARES
            If (RESN(i) .EQ. RTMP(j))Then

               kS = Iabs(IRES(i))

               If (i .NE. NRES)Then
               kE = Iabs(IRES(i+1)) - 1
               Else
               kE = NAT
               EndIf

               Do k=kS,kE
               Q(k) = QTMP(j,k-kS+1)
               ATMT(k) = ATMP(j,k-kS+1)
               EndDo

            EndIf
            EndDo

         EndDo

 11      Format(1X,A3) 
 12      Format(A62,A12)
 13      Format(A2)

         Return

      End Subroutine
