! Subroutine: CreateH
! Purpose: Creates Hydrogen Entries into RAT and ITYPE Arrays and Copies
!          Carbon,Oxygen,Nitrogen, and Sulfer Data From ROLD ITOLD Arrays 
! Written: April 24th 2006
! Last Update: April 24th 2006
! Author: Eric Dykeman

! NOTES: VARIABLES
!             RAT - (NAT+N,3) Coordinates of atoms in the system
!           ITYPE - (NAT+N) Atom Types For each Atom
!            ROLD - (NAT,3) Old Atom Coordinates (Missing Some Hydrogens)
!           ITOLD - (NAT) Old Atom Types (Missing Some Hydrogens)
!             NAT - Total Number of Atoms in system (Missing Some H)
!               N - Total Number of hydrogens to add to system
!               j - Current Atom number in ROLD
!            iATM - Current Atom number in RAT
!              NH - Number of Hydrogens to add
!
!        DEPENDANCIES
!

! **********************************************************************

      Subroutine CreateH (RAT,ITYPE,ROLD,ITOLD,NAT,N,j,iATM,NH)

         Implicit None

      !Variable Declaration!

         Double Precision, Intent(In) :: ROLD
         Double Precision, Intent(InOut) :: RAT
         Integer, Intent(In) :: ITOLD,NAT,N
         Integer, Intent(InOut) :: ITYPE,j,iATM,NH

         Dimension RAT(NAT+N,3),ITYPE(NAT+N),ROLD(NAT,3),ITOLD(NAT)

      !Local Variables!

         Integer i,k

      !ROUTINE!

         iATM = iATM + 1

         ITYPE(iATM) = ITOLD(j)
         Do k=1,3
         RAT(iATM,k) = ROLD(j,k)
         EndDo

         j = j + 1
         Do While (ITOLD(j) .EQ. 1)

            iATM = iATM + 1

            ITYPE(iATM) = ITOLD(j)
            Do k=1,3
            RAT(iATM,k) = ROLD(j,k)
            EndDo

            NH = NH - 1
            j = j + 1

         EndDo

         If (NH .GT. 0)Then

            Do i=1,NH

               iATM = iATM + 1

               ITYPE(iATM) = 1
               Do k=1,3
               RAT(iATM,k) = 0.0d0
               EndDo

            EndDo

         EndIf

         If (NH .LT. 0)iATM = iATM + NH

         Return

      End Subroutine
