! Program: Nanalyze
! Purpose: Analyzes a nucleic acid sequence and does one or more of the 
!          following tasks
!          1) Outputs the nucleic sequence
!          2) Builds a Saguaro Coordinate and Parameter file
!             for the nucleic acid.
! Written: September 14th 2007
! Last Update: April 7th 2009
! Author: Eric Dykeman

! NOTES: DEPENDANCIES
!        
!

! **********************************************************************

      Program Nanalyze

         Use SystemParam

         Implicit None

      !Variable Declaration!

         Double Precision AMASS
         Character, Dimension(:), Allocatable :: RCODE
         Character*60 INFILE,OUTFILE,PARMFILE,MOLFILE,CRDFILE
         Integer, Dimension (:), Allocatable :: IWRK
         Integer i,j,k,iS,iE,iCRD,iADDH,iCHOICE,iSOL,MAXTP

         Parameter (MAXTP = 100)

         Dimension AMASS(MAXTP)

      !ROUTINE!

         !MASSES!

         Do i=1,MAXTP
         AMASS(i) = 0.0d0
         EndDo

         AMASS(1)=1.008d0
         AMASS(3)=6.941d0
         AMASS(6)=1.201d1
         AMASS(7)=1.401d1
         AMASS(8)=1.599d1
         AMASS(9)=1.899d1
         AMASS(11)=2.299d1
         AMASS(12)=2.431d1
         AMASS(13)=2.698d1
         AMASS(14)=2.809d1
         AMASS(15)=3.097d1
         AMASS(16)=3.207d1
         AMASS(19)=3.909d1
         AMASS(20)=4.0078d1
         AMASS(29)=6.355d1
         AMASS(32)=7.261d1
         AMASS(79)=1.969d2

         Write(*,*)'------------WELCOME TO NANALYZE---------------'
         Write(*,*)' '
         Write(*,*)'WE WILL ANALYZE A GIVEN NUCLEIC ACID THEN DO ONE'
         Write(*,*)'OR MORE OF THE FOLLOWING TASKS:'
         Write(*,*)'1) OUTPUT THE NUCLEIC ACID SEQUENCE OF THE PEPTIDE'
         Write(*,*)'2) BUILD A SAGUARO PARM, MOL, AND GF2K FILE'
         Write(*,*)' '

         Write(*,*)'PLEASE ENTER THE FILE NAME'
         Read(*,*)INFILE
         Write(*,*)INFILE
         Write(*,*)' '

         Write(*,*)'WHAT FORMAT IS THIS IN?'
         Write(*,*)'PDB  ---> ENTER 1'
         Write(*,*)'XYZ  ---> ENTER 2'
         Write(*,*)'GF2K ---> ENTER 3'
         Read(*,*)iCRD
         Write(*,*)iCRD
         Write(*,*)' '

         Open(Unit=1,File=INFILE,Status='Unknown')

         Select Case (iCRD)
            Case (1)
            Call Readpdb
            Case (2)
            Call Readxyz
            Case (3)
            Call Readgf2k
            Case Default
            Write(*,*)'ERROR: NOT A VALID CHOICE!'
            Stop
         End Select

         Call Analyze

         Write(*,*)'DO YOU WANT TO CHECK FOR MISSING HYDROGENS?'
         Write(*,*)' '
         Write(*,*)'YES ---> ENTER 1'
         Write(*,*)'NO  ---> ENTER 0'
         Read(*,*)iCHOICE
         Write(*,*)iCHOICE
         Write(*,*)' '

         iADDH = 0

         If (iCHOICE .EQ. 1)Then

            Call AddH

            iADDH = 1

         EndIf

         !Do Various Tasks One at a Time!

         Write(*,*)'WOULD YOU LIKE TO OUTPUT THE SEQUENCE?'
         Write(*,*)'YES ---> ENTER 1'
         Write(*,*)'NO  ---> ENTER 0'
         Read(*,*)iCHOICE
         Write(*,*)iCHOICE
         Write(*,*)' '

         If (iCHOICE .EQ. 1)Then

            !Output Nucleic Acid Sequence!

            Write(*,*)'PLEASE ENTER OUTPUT FILE FOR SEQUENCE INFO'
            Read(*,*)OUTFILE
            Write(*,*)OUTFILE
            Write(*,*)' '

            Open(Unit=2,File=OUTFILE,Status='Unknown')

            !Get Single Letter Atom names for nucleic acids!

            Allocate(RCODE(NRES))

            Do i=1,NRES

               RCODE(i) = ' '

               If (RESN(i) .EQ. 'DA ')RCODE(i) = 'A'
               If (RESN(i) .EQ. 'DG ')RCODE(i) = 'G'
               If (RESN(i) .EQ. 'DT ')RCODE(i) = 'T'
               If (RESN(i) .EQ. 'DC ')RCODE(i) = 'C'

               If (RESN(i) .EQ. 'RA ')RCODE(i) = 'A'
               If (RESN(i) .EQ. 'RG ')RCODE(i) = 'G'
               If (RESN(i) .EQ. 'RU ')RCODE(i) = 'U'
               If (RESN(i) .EQ. 'RC ')RCODE(i) = 'C'

               If (RESN(i) .EQ. 'ADP')RCODE(i) = 'A'
               If (RESN(i) .EQ. 'ATP')RCODE(i) = 'A'
               If (RESN(i) .EQ. 'GDP')RCODE(i) = 'G'
               If (RESN(i) .EQ. 'GTP')RCODE(i) = 'G'

            EndDo

            Write(2,*)'NUCLEIC ACID SEQUENCE OF COORD FILE: ',INFILE

            iS = 1

            Do While (iS .LE. NRES)

            Write(2,*)' '

            iE = iS + 1

            If (iE .LE. NRES)Then
            Do While (IRES(iE) .GT. 0 .AND. iE .LT. NRES)
            iE = iE + 1
            EndDo
            EndIf

            If (iE .NE. NRES)iE = iE - 1

            !First Output Nucleic Acid Code!

            Write(2,20)(RCODE(j),j=iS,iE)
            Write(2,*)' '

            iS = iE + 1

            EndDo

            Close (Unit = 2)

         EndIf

         Write(*,*)'WOULD YOU LIKE TO BUILD SAGUARO FILES?'
         Write(*,*)'YES ---> ENTER 1'
         Write(*,*)'NO  ---> ENTER 0'
         Read(*,*)iCHOICE
         Write(*,*)iCHOICE
         Write(*,*)' '

         If (iCHOICE .EQ. 1)Then

            If (iADDH .NE. 1)Then

               Call AddH

               iADDH = 1

            EndIf

            Write(*,*)'WOULD YOU LIKE TO CHANGE THE 5 PRIME'
            Write(*,*)'AND/OR THE 3 PRIME ENDS?'
            Write(*,*)'(NOTE: THE DEFAULT ENDS HAVE NO OH GROUP)'
            Write(*,*)'YES --> ENTER 1'
            Write(*,*)'NO  --> ENTER 0'
            Read(*,*)iCHOICE
            Write(*,*)iCHOICE
            Write(*,*)' '

            If (iCHOICE .EQ. 1)Call AdjustEND

            Call SetupParms

!            Write(*,*)'WOULD YOU LIKE TO SOLVATE THE NUCLEIC ACID?
!            Write(*,*)'YES ---> ENTER 1'
!            Write(*,*)'NO  ---> ENTER 0'
!            Read(*,*)iCHOICE
!            Write(*,*)iCHOICE
!            Write(*,*)' '
!
!            If (iCHOICE .EQ. 1)Then
!            iSOL = 1
!            Call SolvateBox
!            Else
!            iSOL = 0
!            EndIf

            Write(*,*)'PLEASE ENTER SAGUARO PARM FILE NAME'
            Read(*,*)PARMFILE
            Write(*,*)PARMFILE
            Write(*,*)' '

            Write(*,*)'PLEASE ENTER SAGUARO MOL FILE NAME'
            Read(*,*)MOLFILE
            Write(*,*)MOLFILE
            Write(*,*)' '

            Write(*,*)'PLEASE ENTER SAGUARO GF2K FILE NAME'
            Read(*,*)CRDFILE
            Write(*,*)CRDFILE
            Write(*,*)' '

            Open(Unit=7,File=PARMFILE,Status='Unknown')
            Open(Unit=8,File=MOLFILE,Status='Unknown')
            Open(Unit=9,File=CRDFILE,Status='Unknown')

            !First need to put bonds in order!
            !hbonds first - others second!

            If (NBD .NE. 0)Then

            NHBD = 0

            Allocate (IWRK(NBD))

            Do i=1,NBD

               j = ITYPE(LBOND(i,1))
               k = ITYPE(LBOND(i,2))

               If (j .EQ. 1)Then
               NHBD = NHBD + 1
               IWRK(i) = 1
               ElseIf (k .EQ. 1)Then
               NHBD = NHBD + 1
               IWRK(i) = 1
               Else
               IWRK(i) = 0
               EndIf

            EndDo

            EndIf

            Write(7,70)NAT,NBD,NHBD,NAG,NDH+NIDH,NEX,N14

            Do i=1,NAT
            j = ITYPE(i)
            If (AMASS(j) .EQ. 0.0d0)Then
            Write(*,*)'ERROR: UNKNOWN ATOM MASS FOR ATOM # ',i
            Write(*,*)'ATOMIC NUMBER IS ',j
            Stop
            EndIf
            Write(7,71)AMASS(j),Q(i),DVDW(i,1),DVDW(i,2)
            EndDo

            If (NBD .NE. 0)Then

            !BONDS CONTAINING HYDROGEN!

            Do i=1,NBD
            If (IWRK(i) .EQ. 1)Then
            Write(7,72)LBOND(i,1),LBOND(i,2),DBOND(i,1),DBOND(i,2)
            EndIf
            EndDo

            !BONDS WITH NO HYDROGEN!

            Do i=1,NBD
            If (IWRK(i) .EQ. 0)Then
            Write(7,72)LBOND(i,1),LBOND(i,2),DBOND(i,1),DBOND(i,2)
            EndIf
            EndDo

            Deallocate(IWRK)

            EndIf

            If (NAG .NE. 0)Then

            Do i=1,NAG
            Write(7,73)LANGL(i,1),LANGL(i,2),LANGL(i,3),DANGL(i,1),&
                      &DANGL(i,2)
            EndDo

            EndIf

            If (NDH .NE. 0)Then

            !PROPER DIHEDRAL!

            Do i=1,NDH
            Write(7,74)LDIHD(i,1),LDIHD(i,2),LDIHD(i,3),LDIHD(i,4),&
                      &DDIHD(i,1),DDIHD(i,2),DDIHD(i,3)
            EndDo

            EndIf

            !IMPROPER DIHEDRAL!

            If (NIDH .NE. 0)Then

            Do i=1,NIDH
            Write(7,74)LIDIHD(i,1),LIDIHD(i,2),LIDIHD(i,3),LIDIHD(i,4),&
                      &DIDIHD(i,1),DIDIHD(i,2),DIDIHD(i,3)
            EndDo

            EndIf

            If (NEX .NE. 0)Then

            Do i=1,NEX
            Write(7,75)LEX(i,1),LEX(i,2)
            EndDo

            EndIf

            If (N14 .NE. 0)Then

            Do i=1,N14
            Write(7,75)L14(i,1),L14(i,2)
            EndDo

            EndIf

            Write(8,80)NAT,NMOL
            Do i=1,NAT
            Write(8,81)MOLN(i),MTYPE(i)
            EndDo

            Write(9,90)NAT,0.0d0
            Do i=1,NAT
            Write(9,91)ITYPE(i),RAT(i,1),RAT(i,2),RAT(i,3)
            EndDo

!            If (iSOL .EQ. 1)Then
!            Do i=1,3
!            Write(9,92)DLV(i,1),DLV(i,2),DLV(i,3)
!            EndDo
!            EndIf

            Close(Unit = 7)
            Close(Unit = 8)
            Close(Unit = 9)

         EndIf

         Write(*,*)'GOODBYE FROM NANALYZE!!!'

         Close (Unit = 1)

 20      Format(50A1)
 70      Format(7I8)
 71      Format(4E16.8)
 72      Format(2I8,16X,2E16.8)
 73      Format(3I8,8X,2E16.8)
 74      Format(4I8,3E16.8)
 75      Format(2I8)
 80      Format(I8,I6)
 81      Format(I6,2X,A1)
 90      Format(I8,E16.8)
 91      Format(I3,3F13.7)
 92      Format(3F13.7)

      End Program
