! Subroutine: Order
! Purpose: Orders the neighbors of an atom to a specific format that
!          Is nessacary to find all atoms associated with the residue
! Written: September 14th 2007
! Last Update: September 14th 2007
! Author: Eric Dykeman

! NOTES: VARIABLES
!           LNEIGH - (NAT,NNMAX) List of Neighbors of each atom
!           NNEIGH - (NAT) Number of neighbors that each atom has
!            ITYPE - (NAT) List of Atom Types
!              NAT - Total Number of Atoms in the System
!            NNMAX - Maximum Number of Neighbors Per atom
!            iPRES - Present Atom Number to order
!            iLAST - Last Atom number
!
!             NOTE - ORDER IS GIVEN BY
!                    1) HYDROGENS
!                    2) OXYGENS (DOUBLE BONDED)
!                    3) OXYGENS (SINGLE BONDED)
!                    4) NITROGENS 
!                       (FROM LEAST # OF NON H NEIGHBORS TO MOST)
!                    6) CARBONS
!                       (FROM LEAST # OF NON H NEIGHBORS TO MOST)
!
!        DEPENDANCIES
!        Chemistry
!

! **********************************************************************

      Subroutine Order (LNEIGH,NNEIGH,ITYPE,NAT,NNMAX,iPRES,iLAST)

         Implicit None

      !Variable Declaration!

         Integer, Intent(In) :: NNEIGH,ITYPE,NAT,NNMAX,iPRES,iLAST
         Integer, Intent(InOut) :: LNEIGH

         Dimension LNEIGH(NAT,NNMAX),NNEIGH(NAT),ITYPE(NAT)

      !Local Variables!

         Integer i,j,k,N,M,NN,LTMP,ISKIP
         Integer iHCNOP(5),jHCNOP(5),iNEIG

         Dimension LTMP(NNMAX),ISKIP(NNMAX)

      !ROUTINE!

         k = 0

         Do i=1,NNMAX
         ISKIP(i) = 0
         EndDo

         !SPECIAL CASE FOR ADENINE AND GUANINE!

         Call Chemistry (LNEIGH(iPRES,:),NNEIGH(iPRES),&
                       & ITYPE,NAT,NNMAX,iHCNOP)

         If (ITYPE(iPRES) .EQ. 6 .AND. NNEIGH(iPRES) .EQ. 3)Then
         If (iHCNOP(2) .EQ. 2 .AND. iHCNOP(3) .EQ. 1)Then

            Do i=1,NNEIGH(iPRES)

               j = LNEIGH(iPRES,i)

               If (ITYPE(j) .EQ. 6)Then

               N = 0

               Do k=1,NNEIGH(j)

                  iNEIG = LNEIGH(j,k)

                  Call Chemistry (LNEIGH(iNEIG,:),NNEIGH(iNEIG),&
                                & ITYPE,NAT,NNMAX,jHCNOP)

                  N = N + jHCNOP(2)

               EndDo

               If (N .EQ. 5)Then
               LTMP(1) = j
               Else
               LTMP(2) = j
               EndIf

               EndIf

            EndDo

            LTMP(3) = iLAST

            Goto 10

         EndIf
         EndIf

         !First Find Any Hydrogens!

         Do i=1,NNEIGH(iPRES)

            j = LNEIGH(iPRES,i)

            If (j .NE. iLAST .AND. ISKIP(i) .NE. 1)Then

               If (ITYPE(j) .EQ. 1)Then
                  k = k + 1
                  LTMP(k) = j
                  ISKIP(i) = 1
               EndIf

            EndIf

         EndDo

         !Now Find Any Oxygens with a Double Bond!

         Do i=1,NNEIGH(iPRES)

            j = LNEIGH(iPRES,i)

            If (j .NE. iLAST .AND. ISKIP(i) .NE. 1)Then

               If (ITYPE(j) .EQ. 8)Then
               If (NNEIGH(j) .EQ. 1)Then
                  k = k + 1
                  LTMP(k) = j
                  ISKIP(i) = 1
               EndIf
               EndIf

            EndIf

         EndDo

         !Now Find Any Oxygens with No Double Bonds!

         Do i=1,NNEIGH(iPRES)

            j = LNEIGH(iPRES,i)

            If (j .NE. iLAST .AND. iSKIP(i) .NE. 1)Then

               If (ITYPE(j) .EQ. 8)Then
               If (NNEIGH(j) .EQ. 2)Then
                  k = k + 1
                  LTMP(k) = j
                  ISKIP(i) = 1
               EndIf
               EndIf

            EndIf

         EndDo

         !Now Find Any Nitrogens!
         !Order is nitrogens with Least number!
         !of non hydrogen neighbors to Greatest!

         NN = 0

         Do i=1,NNEIGH(iPRES)
         j = LNEIGH(iPRES,i)
         If (ITYPE(j) .EQ. 7)Then
         If (j .NE. iLAST)NN = NN + 1
         EndIf
         EndDo

         NN = k + NN

         Do While (k .NE. NN)

            N = NNMAX

            Do i=1,NNEIGH(iPRES)

               j = LNEIGH(iPRES,i)

               If (j .NE. iLAST .AND. ISKIP(i) .NE. 1)Then

                  If (ITYPE(j) .EQ. 7)Then

                     Call Chemistry (LNEIGH(j,:),NNEIGH(j),ITYPE,&
                                   & NAT,NNMAX,iHCNOP)

                     iNEIG = iHCNOP(2) + iHCNOP(3) + iHCNOP(4)
                     iNEIG = iNEIG + iHCNOP(5)

                     If (iNEIG .LT. N)Then
                     N = iNEIG
                     M = i
                     EndIf

                  EndIf

               EndIf

            EndDo

            k = k + 1
            ISKIP(M) = 1
            LTMP(k) = LNEIGH(iPRES,M)

         EndDo

         !Now Find Any Carbons!

         !Carbons Neighbor Order is from Least Number!
         !of non hydrogen Neighbors To the Greatest!

         Do While (k .NE. NNEIGH(iPRES) - 1)

            N = NNMAX

            Do i=1,NNEIGH(iPRES)

               j = LNEIGH(iPRES,i)

               If (j .NE. iLAST .AND. ISKIP(i) .NE. 1)Then

                  If (ITYPE(j) .EQ. 6)Then

                     Call Chemistry (LNEIGH(j,:),NNEIGH(j),ITYPE,&
                                   & NAT,NNMAX,iHCNOP)

                     iNEIG = iHCNOP(2) + iHCNOP(3) + iHCNOP(4)
                     iNEIG = iNEIG + iHCNOP(5)

                     If (iNEIG .LT. N)Then
                     N = iNEIG
                     M = i
                     EndIf

                  EndIf

               EndIf

            EndDo

            k = k + 1
            ISKIP(M) = 1
            LTMP(k) = LNEIGH(iPRES,M)

         EndDo

         !Now Place in Last Neighbor!

         k = k + 1

         LTMP(k) = iLAST

         !Copy Over to LNEIGH!

 10      Continue

         Do i=1,NNEIGH(iPRES)

            LNEIGH(iPRES,i) = LTMP(i)

         EndDo

         Return

      End Subroutine
