! Subroutine: ReadAP
! Purpose: Reads in amber parameter file and stores info in arrays
! Written: March 15th 2007
! Last Update: March 15th 2007
! Author: Eric Dykeman

! NOTES: VARIABLES
!        SystemParam - Global system parameters
!

! **********************************************************************

      Subroutine ReadAP

         Use SystemParam, Only : ATYPE,AVDW,ABDN,ABDD,AAGN,AAGD,&
                               & ADHN,ADHD,AIDHN,AIDHD,NAAT,NABD,&
                               & NAAG,NADH,NAIDH

         Implicit None

      !Variable Declaration!

      !Local Variables!

         Double Precision FACTOR
         Character*72 STR2,FNAME
         Character*12 STR1
         Integer i,j

      !ROUTINE!

         !Conversion Factor!
         !1 kcal/mol = FACTOR ev!

         FACTOR = 0.043365134d0

         Write(*,*)'ENTERING Saguaro3.3/sdat/ FOR PARAMS'

         FNAME = '/home/eric/Saguaro3.3/sdat/aparm94.dat'

         Open (Unit=10,File=FNAME,Status='Unknown')

         !The List of AMBER Parmeters!

         !AMBER ATOM TYPES- ATYPE(NAAT)!
         !VDW DATA       -- AVDW(NAAT)!
         !BOND NAMES     -- ABDN(NABD,2)!
         !BOND DATA      -- ABDD(NABD,2)!
         !ANGLE NAMES    -- AAGN(NAAG,3)!
         !ANGLE DATA     -- AAGD(NAAG,2)!
         !DIHEDRAL NAMES -- ADHN(NADH,4)!
         !DIHEDRAL DATA  -- ADHD(NADH,3)!
         !IMPROPER NAMES -- AIDHN(NAIDH,4)!
         !IMPROPER DATA  -- AIDHD(NAIDH,3)!

         Read(10,*)NAAT,NABD,NAAG,NADH,NAIDH

         Allocate (ATYPE(NAAT),AVDW(NAAT,2))
         Allocate (ABDN(NABD,2),ABDD(NABD,2))
         Allocate (AAGN(NAAG,3),AAGD(NAAG,2))
         Allocate (ADHN(NADH,4),ADHD(NADH,3))
         Allocate (AIDHN(NAIDH,4),AIDHD(NAIDH,3))

         !ATOM TYPES!

         Do i=1,NAAT

            Read(10,11)ATYPE(i),STR2
            Read(STR2,*)AVDW(i,1),AVDW(i,2)

            AVDW(i,2) = AVDW(i,2)*FACTOR

         EndDo

         !BONDS!

         Do i=1,NABD

            Read(10,12)STR1,STR2
            Read(STR2,*)ABDD(i,1),ABDD(i,2)

            ABDD(i,1) = ABDD(i,1)*FACTOR

            ABDN(i,1) = STR1(1:2)
            ABDN(i,2) = STR1(4:5)

         EndDo

         !ANGLES!

         Do i=1,NAAG

            Read(10,13)STR1,STR2
            read(STR2,*)AAGD(i,1),AAGD(i,2)

            AAGD(i,1) = AAGD(i,1)*FACTOR

            AAGN(i,1) = STR1(1:2)
            AAGN(i,2) = STR1(4:5)
            AAGN(i,3) = STR1(7:8)

         EndDo

         !DIHEDRALS!

         Do i=1,NADH

            Read(10,14)STR1,STR2
            Read(STR2,*)j,ADHD(i,1),ADHD(i,2),ADHD(i,3)

            ADHD(i,1) = ADHD(i,1)*FACTOR/Dble(j)

            ADHN(i,1) = STR1(1:2)
            ADHN(i,2) = STR1(4:5)
            ADHN(i,3) = STR1(7:8)
            ADHN(i,4) = STR1(10:11)

         EndDo

         !IMPROPER DIHEDRALS!

         Do i=1,NAIDH

            Read(10,14)STR1,STR2
            Read(STR2,*)AIDHD(i,1),AIDHD(i,2),AIDHD(i,3)

            AIDHD(i,1) = AIDHD(i,1)*FACTOR

            AIDHN(i,1) = STR1(1:2)
            AIDHN(i,2) = STR1(4:5)
            AIDHN(i,3) = STR1(7:8)
            AIDHN(i,4) = STR1(10:11)

         EndDo

 11      Format(A2,A70)
 12      Format(A5,A67)
 13      Format(A8,A64)
 14      Format(A11,A61)

         Close(Unit = 10)

         Return

      End Subroutine
