! Subroutine: Readgf2k
! Purpose: Reads in a coordinate file that is in gf2k format (SAGUARO)
! Written: April 26th 2006
! Last Update: April 26th 2006
! Author: Eric Dykeman

! NOTES: VARIABLES
!            RAT - (NAT,3) List of Atomic Coordinates
!          ITYPE - (NAT) List of Atom types
!            NAT - Total Number of atoms in the system
!
!        DEPENDANCIES
!        Systemparam - Module Contaning global system variables
!

! **********************************************************************

      Subroutine Readgf2k

         Use SystemParam, Only : RAT,ITYPE,NAT,TIME

         Implicit None

      !Variable Declaration!

      !Local Variables!

         Integer i

      !ROUTINE!

         Read(1,*)NAT,TIME

         Allocate (RAT(NAT,3),ITYPE(NAT))

         Do i=1,NAT

            Read(1,*)ITYPE(i),RAT(i,1),RAT(i,2),RAT(i,3)

         EndDo

         Return

      End Subroutine
