! Subroutine: Readpdb
! Purpose: Reads in a coordinate file that is in pdb format then converts
!          atom names into numerical format.
! Written: April 26th 2006
! Last Update: April 26th 2006
! Author: Eric Dykeman

! NOTES: VARIABLES
!            RAT - (NAT,3) List of Atomic Coordinates
!          ITYPE - (NAT) List of Atom types
!            NAT - Total Number of atoms in the system
!
!        DEPENDANCIES
!        Systemparam - Module Contaning global system variables
!

! **********************************************************************

      Subroutine Readpdb

         Use SystemParam, Only : RAT,ITYPE,NAT

         Implicit None

      !Variable Declaration!

      !Local Variables!

         Double Precision RTEMP
         Integer i,MAXAT,ISER,IRES,ITEMP
         Character*6 RECID
         Character*4 PDBNM
         Character*3 RESN
         Character*2 ANAME
         Character ALOC,CID,INCD
         Logical OK

         Parameter (MAXAT = 10000)

         Dimension RTEMP(MAXAT,3),ITEMP(MAXAT)

      !ROUTINE!

         !Begin Reading of Pdb!
         !Look For ATOM or HETATM!

         NAT = 0
         OK = .TRUE.

         Do While (OK)

            Read(1,100,End=10)RECID

            If (RECID .EQ. 'ATOM' .OR. RECID .EQ. 'HETATM')Then

            Backspace(1)

            NAT = NAT + 1

            If (NAT .EQ. MAXAT)OK = .FALSE.

            Read(1,110,End=10)RECID,ISER,PDBNM,ALOC,RESN,CID,IRES,INCD,&
                             &RTEMP(NAT,1),RTEMP(NAT,2),RTEMP(NAT,3)

            ANAME = PDBNM(1:1)
            If (ANAME .EQ. ' ')ANAME = PDBNM(2:2)
            If (ANAME .EQ. '0')ANAME = PDBNM(2:2)
            If (ANAME .EQ. '1')ANAME = PDBNM(2:2)
            If (ANAME .EQ. '2')ANAME = PDBNM(2:2)
            If (ANAME .EQ. '3')ANAME = PDBNM(2:2)
            If (ANAME .EQ. '4')ANAME = PDBNM(2:2)
            If (ANAME .EQ. '5')ANAME = PDBNM(2:2)
            If (ANAME .EQ. '6')ANAME = PDBNM(2:2)
            If (ANAME .EQ. '7')ANAME = PDBNM(2:2)
            If (ANAME .EQ. '8')ANAME = PDBNM(2:2)
            If (ANAME .EQ. '9')ANAME = PDBNM(2:2)

            Call GetType (ANAME,ITEMP(NAT))

            EndIf

         EndDo

         Write(*,*)'ERROR IN READPDB: TO MANY ATOMS IN PDB FILE'
         Write(*,*)'INCREASE PARAMETER MAXAT IN READPDB'
         Stop

 10      Allocate (RAT(NAT,3),ITYPE(NAT))

         Do i=1,NAT
         ITYPE(i) = ITEMP(i)
         RAT(i,1) = RTEMP(i,1)
         RAT(i,2) = RTEMP(i,2)
         RAT(i,3) = RTEMP(i,3)
         EndDo

         Return

 100     Format(A6)
 110     Format(A6,I5,1X,A4,A1,A3,1X,A1,I4,A1,3X,3F8.3)

      End Subroutine
