! Subroutine: ThreeCoord
! Purpose: Checks to make sure that a set of atoms are Three Coordinated
! Written: April 24th 2006
! Last Update: April 24th 2006
! Author: Eric Dykeman

! NOTES: VARIABLES
!            RC - (3) Center Atom Coordinates
!            R1 - (3) 1st attached atom
!            R2 - (3) 2nd attached atom
!            R3 - (3) 3rd attached atom
!
!        DEPENDANCIES
!

! **********************************************************************

      Subroutine ThreeCoord (RC,R1,R2,R3)

         Implicit None

      !Variable Declaration!

         Double Precision, Intent (InOut) :: RC,R1,R2,R3

         Dimension RC(3),R1(3),R2(3),R3(3)

      !Local Variables!

         Double Precision A,B,X,R12,R13,VEC
         Double Precision RBOND,THETA
         Integer i,N,LIST

         Dimension R12(3),R13(3),VEC(3),LIST(3)

      !ROUTINE!

         RBOND = 1.0d0      !Default H-? Bond Distance!
         THETA = 2.0944d0   !Default Angle in Radians!

         !First Find Troubled Atoms ... Located at (0,0,0)!

         Do i=1,3
         LIST(i) = 0
         EndDo

         If (R1(1) .EQ. 0.0d0 .AND. R1(2) .EQ. 0.0d0 &
           & .AND. R1(3) .EQ. 0.0d0)LIST(1) = 1

         If (R2(1) .EQ. 0.0d0 .AND. R2(2) .EQ. 0.0d0 &
           & .AND. R2(3) .EQ. 0.0d0)LIST(2) = 1

         If (R3(1) .EQ. 0.0d0 .AND. R3(2) .EQ. 0.0d0 &
           & .AND. R3(3) .EQ. 0.0d0)LIST(3) = 1

         !How Many Bad Atoms (Should Be Either 1 or 2)!

         N = 0

         Do i=1,3
         N = N + LIST(i)
         EndDo

         !Very RARE Possabilty!

         If (N .EQ. 3)Then
         LIST(1) = 0
         N = 2
         EndIf

         If (N .EQ. 1)Then

            !Enough Info to Form A Plane!

            If (LIST(1) .EQ. 1)Then

               Do i=1,3
               R12(i) = RC(i) - R2(i)
               R13(i) = RC(i) - R3(i)
               EndDo

            EndIf

            If (LIST(2) .EQ. 1)Then

               Do i=1,3
               R12(i) = RC(i) - R1(i)
               R13(i) = RC(i) - R3(i)
               EndDo

            EndIf

            If (LIST(3) .EQ. 1)Then

               Do i=1,3
               R12(i) = RC(i) - R1(i)
               R13(i) = RC(i) - R2(i)
               EndDo

            EndIf

            !Normailize vectors!

            X = R12(1)**2 + R12(2)**2 + R12(3)**2
            X = 1.0d0/Dsqrt(X)

            Do i=1,3
            R12(i) = R12(i)*X
            EndDo

            X = R13(1)**2 + R13(2)**2 + R13(3)**2
            X = 1.0d0/Dsqrt(X)

            Do i=1,3
            R13(i) = R13(i)*X
            EndDo

            Do i=1,3
            VEC(i) = R12(i) + R13(i)
            EndDo

            X = 0.0d0
            Do i=1,3
            X = X + VEC(i)*VEC(i)
            EndDo
            X = RBOND/Dsqrt(X)

            Do i=1,3
            VEC(i) = VEC(i)*X
            EndDo

            If (LIST(1) .EQ. 1)Then

               Do i=1,3
               R1(i) = RC(i) + VEC(i)
               EndDo

            EndIf

            If (LIST(2) .EQ. 1)Then

               Do i=1,3
               R2(i) = RC(i) + VEC(i)
               EndDo

            EndIf

            If (LIST(3) .EQ. 1)Then

               Do i=1,3
               R3(i) = RC(i) + VEC(i)
               EndDo

            EndIf

         ElseIf (N .EQ. 2)Then

            !Not Enough Info To Form a Plane!

            If (LIST(1) .EQ. 0)Then

               Do i=1,3
               R12(i) = RC(i) - R1(i)
               EndDo

            EndIf

            If (LIST(2) .EQ. 0)Then

               Do i=1,3
               R12(i) = RC(i) - R2(i)
               EndDo

            EndIf

            If (LIST(3) .EQ. 0)Then

               Do i=1,3
               R12(i) = RC(i) - R3(i)
               EndDo

            EndIf

            X = R12(1)**2 + R12(2)**2 + R12(3)**2
            X = 1.0d0/Dsqrt(X)

            Do i=1,3
            R12(i) = R12(i)*X
            EndDo

            !Find A perpendicular vector to R12!

            Do i=1,3
            VEC(i) = 0.0d0
            EndDo

            If (R12(1) .NE. 0.0d0)Then

               VEC(3) = 1.0d0

            ElseIf (R12(2) .NE. 0.0d0)Then

               VEC(3) = 1.0d0

            Else

               VEC(2) = 1.0d0

            EndIf

            !Remove any component along R12 and Normalize!
         
            X = 0.0d0
            Do i=1,3
            X = X + VEC(i)*R12(i)
            EndDo

            Do i=1,3
            VEC(i) = VEC(i) - X*R12(i)
            EndDo

            X = 0.0d0
            Do i=1,3
            X = X + VEC(i)*VEC(i)
            EndDo
            X = 1.0d0/Dsqrt(X)

            Do i=1,3
            VEC(i) = VEC(i)*X
            EndDo

            B = -RBOND*DCos(THETA)
            A = RBOND**2 - B*B
            A = Dsqrt(A)

            If (LIST(1) .NE. 1)Then

               Do i=1,3
               R2(i) = RC(i) + A*VEC(i) + B*R12(i)
               R3(i) = RC(i) - A*VEC(i) + B*R12(i)
               EndDo

            EndIf

            If (LIST(2) .NE. 1)Then

               Do i=1,3
               R1(i) = RC(i) + A*VEC(i) + B*R12(i)
               R3(i) = RC(i) - A*VEC(i) + B*R12(i)
               EndDo

            EndIf

            If (LIST(3) .NE. 1)Then

               Do i=1,3
               R1(i) = RC(i) + A*VEC(i) + B*R12(i)
               R2(i) = RC(i) - A*VEC(i) + B*R12(i)
               EndDo

            EndIf

         EndIf

         Return

      End Subroutine
