! Subroutine: Analyze (FOR Pdb4Jmol)
! Purpose: Performs Three Tasks:
!          1) Find Backbone And Residue Atoms. 
!          2) Assign Residue Names.
!          3) Place Each Amino's Atoms in PDB order
! Written: April 17th 2006
! Last Update: May 30th 2008
! Author: Eric Dykeman

! NOTES: VARIABLES
!             RAT - (NAT,3) List of Atomic Coordinates
!           ITYPE - (NAT) List of Atom Types
!            RESN - (NRES) Amino Acid Residue Name
!            IRES - (NRES) Atom number of the N in Amino Acid
!             NAT - Total Number of Atoms in the System
!            NRES - Number of Amino Acid Residues
!
!        DEPENDANCIES
!        SystemParam Neighbors Chemistry Order
!

! **********************************************************************

      Subroutine Analyze

         Use SystemParam, Only : RAT,ISWP,ITYPE,RESN,IRES,NAT,NRES,NATOM

         Implicit None

      !Variable Declaration!

      !Local Variables!

         Double Precision, Dimension(:,:), Allocatable :: RNEW
         Integer, Dimension(:,:), Allocatable :: LNEIGH
         Integer, Dimension(:), Allocatable :: NNEIGH,ITNEW

         Character*3 CWRK
         Logical OK
         Integer NNMAX,iHCNOS,iATM,iTOT
         Integer IWRK,IWRT,iPRES,iNEXT,iLAST
         Integer i,j,k,m,jS,jE,iCA,iCB,iNB,iCO

         Parameter (NNMAX = 4)   !Maximum Number of Neighbors!

         Dimension iHCNOS(5),CWRK(NAT)
         Dimension IWRK(NAT),IWRT(NAT)

      !ROUTINE!

         Allocate (RNEW(NAT,3),ITNEW(NAT),ISWP(NAT))
         Allocate (LNEIGH(NAT,NNMAX),NNEIGH(NAT))

         Do i=1,NAT
         IWRT(i) = 0
         ISWP(i) = 0 !Swap Array!
         !Atom i of PDB is Atom ISWP(i) of GF2K or XYZ!
         EndDo

         !Form Neighbor Map of Bonded Atoms!

         Call Neighbors (RAT,ITYPE,LNEIGH,NNEIGH,NAT,NNMAX)

         NRES = 0
         iATM = 0

         Do i=1,NAT

            iNB = 0         !Atom Number for Backbone N!
            iCA = 0         !Atom Number for C Alpha!
            iCO = 0         !Atom Number for Backbone C!
            iCB = 0         !Atom Number for C Beta!

            If (ITYPE(i) .EQ. 6)Then

               !MUST be Bonded to One N!
               !And One or Two C's!

               Call Chemistry (LNEIGH(i,:),NNEIGH(i),&
                             & ITYPE,NAT,NNMAX,iHCNOS)

               If (iHCNOS(3) .NE. 1)Goto 10

               If (iHCNOS(2) .NE. 1 .AND. iHCNOS(2) .NE. 2)Goto 10

               !OK POSSIBLE C ALPHA -- Log Atom Numbers!

               iCA = i

               Do k=1,NNEIGH(i)
               j = LNEIGH(i,k)
               If (ITYPE(j) .EQ. 7)iNB = j
               EndDo

               Do k=1,NNEIGH(i)
               j = LNEIGH(i,k)
               If (ITYPE(j) .EQ. 6)Then
               If (iCO .EQ. 0)Then
                  iCO = j
               Else
                  iCB = j
               EndIf
               EndIf
               EndDo

               !Still Not Sure If This is C Alpha!
               !Check Chemistry of N and C Bonded to it!

               !N Should ONLY be Bonded to Hydrogen and Carbon!

               Call Chemistry (LNEIGH(iNB,:),NNEIGH(iNB),&
                             & ITYPE,NAT,NNMAX,iHCNOS)

               j = iHCNOS(1) + iHCNOS(2)

               If (j .NE. NNEIGH(iNB))Goto 10

               !CO Should Be Bonded to 1 C 1 N and 1 O!
               !OR The other case is 1 C and 2 O's!

               Call Chemistry (LNEIGH(iCO,:),NNEIGH(iCO),&
                             & ITYPE,NAT,NNMAX,iHCNOS)

               OK = .TRUE.

               If (NNEIGH(iCO) .NE. 3)OK = .FALSE.
               If (iHCNOS(2) .NE. 1)OK = .FALSE.

               If (iHCNOS(3) .NE. 1)Then
               If (iHCNOS(4) .NE. 2)OK = .FALSE.
               Else
               If (iHCNOS(4) .NE. 1)OK = .FALSE.
               EndIf

               If (.NOT. OK)Then

                 !May Have C Beta and CO mixed up!

                 !Do We Have A C Beta?!

                 If (iCB .EQ. 0)Goto 10

                 j = iCO
                 iCO = iCB
                 iCB = j

                 Call Chemistry (LNEIGH(iCO,:),NNEIGH(iCO),&
                               & ITYPE,NAT,NNMAX,iHCNOS)

                 If (NNEIGH(iCO) .NE. 3)Goto 10
                 If (iHCNOS(2) .NE. 1)Goto 10

                 If (iHCNOS(3) .NE. 1)Then
                 If (iHCNOS(4) .NE. 2)Goto 10
                 Else
                 If (iHCNOS(4) .NE. 1)Goto 10
                 EndIf

              EndIf

              !OK This is a C Alpha!

              NRES = NRES + 1

              !Copy Atom Coordinates!

              IWRT(iNB) = IWRT(iNB) + 1

              iATM = iATM + 1

              IWRK(NRES) = iATM

              ITNEW(iATM) = ITYPE(iNB)
              ISWP(iATM) = iNB

              Do k=1,3
              RNEW(iATM,k) = RAT(iNB,k)
              EndDo

              Do k=1,NNEIGH(iNB)

                 j = LNEIGH(iNB,k)

                 If (ITYPE(j) .EQ. 1)Then

                    IWRT(j) = IWRT(j) + 1

                 EndIf

              EndDo

              IWRT(iCA) = IWRT(iCA) + 1

              iATM = iATM + 1

              ITNEW(iATM) = ITYPE(iCA)
              ISWP(iATM) = iCA

              Do k=1,3
              RNEW(iATM,k) = RAT(iCA,k)
              EndDo

              Do k=1,NNEIGH(iCA)

                 j = LNEIGH(iCA,k)

                 If (ITYPE(j) .EQ. 1)Then

                    IWRT(j) = IWRT(j) + 1

                 EndIf

              EndDo

              !Copy over CO Group!

              IWRT(iCO) = IWRT(iCO) + 1

              iATM = iATM + 1

              ITNEW(iATM) = ITYPE(iCO)
              ISWP(iATM) = iCO

              Do k=1,3
              RNEW(iATM,k) = RAT(iCO,k)
              EndDo

              Do k=1,NNEIGH(iCO)
              If (ITYPE(LNEIGH(iCO,k)) .EQ. 8)Then
              j = LNEIGH(iCO,k)
              EndIf
              EndDo

              IWRT(j) = IWRT(j) + 1

              iATM = iATM + 1

              ITNEW(iATM) = ITYPE(j)
              ISWP(iATM) = j

              Do k=1,3
              RNEW(iATM,k) = RAT(j,k)
              EndDo


              Do j=1,5
              iHCNOS(j) = 0
              EndDo

              iNEXT = iCB     !Next Non H Atom to Write Out!
              iPRES = iCB     !Present Non H Atom We Are On!
              iLAST = iCA     !Last Non H Atom Written Out!

              If (iCB .NE. 0)Then
              OK = .TRUE.
              Else
              OK = .FALSE.
              EndIf

              Do While (OK)

                 If (IWRT(iPRES) .EQ. 0)Then

                    Call Order (LNEIGH,NNEIGH,ITYPE,&
                              & NAT,NNMAX,iPRES,iLAST) 

                    IWRT(iPRES) = IWRT(iPRES) + 1

                    iATM = iATM + 1

                    ITNEW(iATM) = ITYPE(iPRES)
                    ISWP(iATM) = iPRES

                    Do k=1,3
                    RNEW(iATM,k) = RAT(iPRES,k)
                    EndDo
!TEMP
                    If (ITYPE(iPRES) .EQ. 1)Then
                    Write(4,*)'ERROR!!! ERROR!!! Writing out a hydrogen'
                    Stop
                    EndIf
!TEMP
                    If (ITYPE(iPRES) .EQ. 6)iHCNOS(2) = iHCNOS(2) + 1
                    If (ITYPE(iPRES) .EQ. 7)iHCNOS(3) = iHCNOS(3) + 1
                    If (ITYPE(iPRES) .EQ. 8)iHCNOS(4) = iHCNOS(4) + 1
                    If (ITYPE(iPRES) .EQ. 16)iHCNOS(5) = iHCNOS(5) + 1

                 EndIf

                 Do j=1,NNEIGH(iPRES)

                    iNEXT = LNEIGH(iPRES,j)

                    If (ITYPE(iNEXT) .EQ. 1)Then

                       If (IWRT(iNEXT) .EQ. 0)Then
                       IWRT(iNEXT) = IWRT(iNEXT) + 1
                       EndIf

                    Else

                       !CHECK FOR S-S DISULFIDE BOND!

                       If (ITYPE(iPRES) .EQ. 16)Then
                       If (ITYPE(iNEXT) .EQ. 16)Then
                       iHCNOS(5) = iHCNOS(5) + 1
                       OK = .FALSE.
                       Goto 5
                       EndIf
                       EndIf

                       If (IWRT(iNEXT) .EQ. 0)Goto 5

                    EndIf

                 EndDo

 5               If (iNEXT .EQ. iCA)OK = .FALSE.

                 iLAST = iPRES
                 iPRES = iNEXT

              EndDo

              !What Residue is this!

              iTOT = 0
              Do j=2,5
              iTOT = iTOT + iHCNOS(j)
              EndDo

              If (iTOT .EQ. 0)CWRK(NRES) = 'GLY'

              If (iHCNOS(2) .EQ. 1)Then

                 If (iHCNOS(4) .EQ. 1)CWRK(NRES) = 'SER'

                 If (iHCNOS(5) .EQ. 1)CWRK(NRES) = 'CYS'

                 If (iHCNOS(5) .EQ. 2)CWRK(NRES) = 'CYX'

                 If (iTOT .EQ. 1)CWRK(NRES) = 'ALA'

              EndIf

              If (iHCNOS(2) .EQ. 2)Then

                 If (iHCNOS(4) .EQ. 1)Then
                 If (iHCNOS(3) .EQ. 1)Then
                    CWRK(NRES) = 'ASN'
                 Else
                    CWRK(NRES) = 'THR'
                 EndIf
                 EndIf

                 If (iHCNOS(4) .EQ. 2)CWRK(NRES) = 'ASP'

              EndIf

              If (iHCNOS(2) .EQ. 3)Then

                 If (iHCNOS(3) .EQ. 1)CWRK(NRES) = 'GLN'

                 If (iHCNOS(4) .EQ. 2)CWRK(NRES) = 'GLU'

                 If (iHCNOS(5) .EQ. 1)CWRK(NRES) = 'MET'

                 If (iTOT .EQ. 3)Then

                    !Have to distinguish between!
                    !PRO NPRO VAL and NVAL!

                    !The WEIRD algorithm is to count number!
                    !of carbon neighbors of backbone N and!
                    !SUBTRACT number of oxygen neighbors of!
                    !the carbons that are neighbors with N!

                    k = 0
                    Do j=1,NNEIGH(iNB)
                    If (ITYPE(LNEIGH(iNB,j)) .EQ. 6)Then

                       k = k + 1
                       iPRES = LNEIGH(iNB,j)

                       Do jS=1,NNEIGH(iPRES)
                       If (ITYPE(LNEIGH(iPRES,jS)) .EQ. 8)k = k - 1
                       EndDo

                    EndIf
                    EndDo

                    If (k .EQ. 2)CWRK(NRES) = 'PRO'

                    If (k .EQ. 1)CWRK(NRES) = 'VAL'

                 EndIf

              EndIf

              If (iHCNOS(2) .EQ. 4)Then

                 If (iHCNOS(3) .EQ. 1)CWRK(NRES) = 'LYS'

                 If (iHCNOS(3) .EQ. 2)CWRK(NRES) = 'HIS'

                 If (iHCNOS(3) .EQ. 3)CWRK(NRES) = 'ARG'

                 If (iTOT .EQ. 4)Then

                    k = 0
                    Do j=1,NNEIGH(iCB)
                    If (ITYPE(LNEIGH(iCB,j)) .EQ. 6)k = k + 1
                    EndDo

                    If (k .EQ. 2)Then
                    CWRK(NRES) = 'LEU'
                    Else
                    CWRK(NRES) = 'ILE'
                    EndIf

                 EndIf

              EndIf

              If (iHCNOS(2) .EQ. 7)Then
              If (iHCNOS(4) .EQ. 1)Then
                 CWRK(NRES) = 'TYR'
              Else
                 CWRK(NRES) = 'PHE'
              EndIf
              EndIf

              If (iHCNOS(2) .EQ. 9)CWRK(NRES) = 'TRP'

              !Fix HIS PHE TRP TYR atom orders!

              If (CWRK(NRES) .EQ. 'HIS')Then

                 k = ISWP(iATM-2)
                 ISWP(iATM-2) = ISWP(iATM)
                 ISWP(iATM) = ISWP(iATM-1)
                 ISWP(iATM-1) = k

              EndIf

              If (CWRK(NRES) .EQ. 'PHE')Then

                 k = ISWP(iATM-3)
                 ISWP(iATM-3) = ISWP(iATM)
                 ISWP(iATM) = ISWP(iATM-2)
                 ISWP(iATM-2) = k

              EndIf

              If (CWRK(NRES) .EQ. 'TRP')Then

                 k = ISWP(iATM-6)
                 ISWP(iATM-6) = ISWP(iATM)
                 ISWP(iATM) = ISWP(iATM-3)
                 ISWP(iATM-3) = ISWP(iATM-1)
                 ISWP(iATM-1) = ISWP(iATM-2)
                 ISWP(iATM-2) = ISWP(iATM-4)
                 ISWP(iATM-4) = ISWP(iATM-5)
                 ISWP(iATM-5) = k

              EndIf

              If (CWRK(NRES) .EQ. 'TYR')Then

                 k = ISWP(iATM-4)
                 ISWP(iATM-4) = ISWP(iATM)
                 ISWP(iATM) = ISWP(iATM-2)
                 ISWP(iATM-2) = ISWP(iATM-1)
                 ISWP(iATM-1) = ISWP(iATM-3)
                 ISWP(iATM-3) = k

              EndIf

              !Write Out Terminal Oxygen Atom!

              Do k=1,NNEIGH(iCO)

                 j = LNEIGH(iCO,k)

                 If (ITYPE(j) .EQ. 8)Then
                 If (IWRT(j) .EQ. 0)Then

                    IWRT(j) = IWRT(j) + 1

                    iATM = iATM + 1

                    ITNEW(iATM) = ITYPE(j)
                    ISWP(iATM) = j

                    RNEW(iATM,1) = RAT(j,1)
                    RNEW(iATM,2) = RAT(j,2)
                    RNEW(iATM,3) = RAT(j,3)

                 EndIf
                 EndIf

              EndDo

           EndIf  !ENDIF  If (ITYPE(i) .EQ. 6)

 10        Continue

        EndDo


        !OK Have Located all aminos!
        !Now Put Into proper Order Nterm - Cterm!

        Allocate (RESN(NRES),IRES(NRES))

        !We rearanged atoms once, this rearangement is stored in ISWP!
        !Now we have to rearrange again, so temp store ISWP in IWRT!

        Do i=1,NAT
        IWRT(i) = ISWP(i)
        EndDo

        !Reallocate RAT, RNEW In Case We Striped of CH3 Groups!
        !Or there was water in file!

        NATOM = iATM

        Deallocate (RAT,ITYPE,ISWP)
        Allocate (RAT(NATOM,3),ITYPE(NATOM),ISWP(NATOM))

        Do i=1,NATOM

           ITYPE(i) = ITNEW(i)
           ISWP(i) = 0

           Do j=1,3
           RAT(i,j) = RNEW(i,j)
           EndDo

        EndDo

        Deallocate (LNEIGH,NNEIGH,RNEW,ITNEW)
        Allocate (RNEW(NATOM,3),ITNEW(NATOM))
        Allocate (NNEIGH(NATOM),LNEIGH(NATOM,NNMAX))

        Do i=1,NATOM

           ITNEW(i) = ITYPE(i)

           Do j=1,3
           RNEW(i,j) = RAT(i,j)
           EndDo

        EndDo

        Call Neighbors (RNEW,ITNEW,LNEIGH,NNEIGH,NATOM,NNMAX)

        iATM = 0
        iTOT = 0

        Do While (iATM .NE. NATOM)

           !Find an N Terminal!

           Do i=1,NRES
           If (IWRK(i) .NE. 0)Then

              k = 0
              Do j=1,NNEIGH(IWRK(i))
              If (ITNEW(LNEIGH(IWRK(i),j)) .EQ. 6)k = k + 1
              EndDo

              If (k .EQ. 1)Then

                 iPRES = i
                 OK = .TRUE.
                 Goto 20

              ElseIf (k .EQ. 2)Then

                 If (CWRK(i) .EQ. 'PRO')Then
                 iPRES = i
                 OK = .TRUE.
                 Goto 20
                 EndIf

              EndIf

           EndIf
           EndDo

 20        iTOT = iTOT + 1

           jS = IWRK(iPRES)
           IWRK(iPRES) = 0

           If (iPRES .NE. NRES)Then
           jE = IWRK(iPRES+1) - 1
           Else
           jE = NATOM
           EndIf

           RESN(iTOT) = CWRK(iPRES)
           IRES(iTOT) = iATM + 1

           !Make IRES negative If this is an N terminal!

           If (OK)Then
           IRES(iTOT) = -IRES(iTOT)
           OK = .FALSE.
           EndIf

           Do j=jS,jE
           iATM = iATM + 1
           ITYPE(iATM) = ITNEW(j)
           ISWP(iATM) = IWRT(j)
           Do k=1,3
           RAT(iATM,k) = RNEW(j,k)
           EndDo
           EndDo

           !Find Next Residue!

           Do i=1,NNEIGH(jS+2)

              j = LNEIGH(jS+2,i)

              If (ITNEW(j) .EQ. 7)Then

                 Do k=1,NRES
                 If (IWRK(k) .EQ. j)Then
                 iPRES = k
                 Goto 20
                 EndIf
                 EndDo

              EndIf

           EndDo

        EndDo

        Return

      End Subroutine
