! Subroutine: Chemistry
! Purpose: Calculates the "chemical formula" of the neighbors of an atom
! Written: April 21st 2006
! Last Update: April 21st 2006
! Author: Eric Dykeman

! NOTES: VARIABLES
!           LNEIGH - (NNMAX) List of Neighbors of an atom
!           NNEIGH - Number of neighbors that the atom has
!            ITYPE - (NAT) List of Atom Types
!              NAT - Total Number of Atoms in the system
!            NNMAX - Maximum Number of Neighbors per atom
!           iHCNOS - (5) Outputed Numbers of each atom type
!                    Example - 4,1,0,1,0 = CH3OH
!
!        DEPENDANCIES
!

! **********************************************************************

      Subroutine Chemistry (LNEIGH,NNEIGH,ITYPE,NAT,NNMAX,iHCNOS)

         Implicit None

      !Variable Declaration!

         Integer, Intent(In) :: LNEIGH,NNEIGH,ITYPE,NAT,NNMAX
         Integer, Intent(Out) :: iHCNOS

         Dimension LNEIGH(NNMAX),ITYPE(NAT),iHCNOS(5)

      !Local Variables!

         Integer i,j,k

      !ROUTINE!

         Do i=1,5
         iHCNOS(i) = 0
         EndDo

         Do i=1,NNEIGH

            j = LNEIGH(i)

            If (ITYPE(j) .EQ. 1)k = 1

            If (ITYPE(j) .EQ. 6)k = 2

            If (ITYPE(j) .EQ. 7)k = 3

            If (ITYPE(j) .EQ. 8)k = 4

            If (ITYPE(j) .EQ. 16)k = 5

            iHCNOS(k) = iHCNOS(k) + 1

         EndDo

         Return

      End Subroutine
