! Subroutine: GetName
! Purpose: Converts atom types to names
! Written: August 7th 2007
! Last Update: May 30th 2008
! Author: Eric Dykeman

! NOTES: VARIABLES
!
!        DEPENDANCIES
!

! **********************************************************************

      Subroutine GetName (ANAME,RESN,IRES,NATOM,NRES)

         Implicit None

      !Variable Declaration!

         Character*3, Intent(In) :: RESN
         Character*3, Intent(Out) :: ANAME
         Integer, Intent(In) :: IRES,NATOM,NRES

         Dimension ANAME(NATOM),IRES(NRES),RESN(NRES)

      !Local Variables!

         Integer i,j

      !ROUTINE!

         Do i=1,NRES

            j = Iabs(IRES(i))

            ANAME(j) = 'N  '
            ANAME(j+1) = 'CA '
            ANAME(j+2) = 'C  '
            ANAME(j+3) = 'O  '

            If (RESN(i) .EQ. 'ALA')Then
            ANAME(j+4) = 'CB '
            EndIf

            If (RESN(i) .EQ. 'ARG')Then
            ANAME(j+4) = 'CB '
            ANAME(j+5) = 'CG '
            ANAME(j+6) = 'CD '
            ANAME(j+7) = 'NE '
            ANAME(j+8) = 'CZ '
            ANAME(j+9) = 'NH1'
            ANAME(j+10)= 'NH2'
            EndIf

            If (RESN(i) .EQ. 'ASN')Then
            ANAME(j+4) = 'CB '
            ANAME(j+5) = 'CG '
            ANAME(j+6) = 'OD1'
            ANAME(j+7) = 'ND2'
            EndIf

            If (RESN(i) .EQ. 'ASP')Then
            ANAME(j+4) = 'CB '
            ANAME(j+5) = 'CG '
            ANAME(j+6) = 'OD1'
            ANAME(j+7) = 'OD2'
            EndIf

            If (RESN(i) .EQ. 'CYS' .OR. RESN(i) .EQ. 'CYX')Then
            ANAME(j+4) = 'CB '
            ANAME(j+5) = 'SG '
            EndIf

            If (RESN(i) .EQ. 'GLN')Then
            ANAME(j+4) = 'CB '
            ANAME(j+5) = 'CG '
            ANAME(j+6) = 'CD '
            ANAME(j+7) = 'OE1'
            ANAME(j+8) = 'NE2'
            EndIf

            If (RESN(i) .EQ. 'GLU')Then
            ANAME(j+4) = 'CB '
            ANAME(j+5) = 'CG '
            ANAME(j+6) = 'CD '
            ANAME(j+7) = 'OE1'
            ANAME(j+8) = 'OE2'
            EndIf

            If (RESN(i) .EQ. 'HIS')Then
            ANAME(j+4) = 'CB '
            ANAME(j+5) = 'CG '
            ANAME(j+6) = 'ND1'
            ANAME(j+7) = 'CD2'
            ANAME(j+8) = 'CE1'
            ANAME(j+9) = 'NE2'
            EndIf

            If (RESN(i) .EQ. 'ILE')Then
            ANAME(j+4) = 'CB '
            ANAME(j+5) = 'CG1'
            ANAME(j+6) = 'CG2'
            ANAME(j+7) = 'CD1'
            EndIf

            If (RESN(i) .EQ. 'LEU')Then
            ANAME(j+4) = 'CB '
            ANAME(j+5) = 'CG '
            ANAME(j+6) = 'CD1'
            ANAME(j+7) = 'CD2'
            EndIf

            If (RESN(i) .EQ. 'LYS')Then
            ANAME(j+4) = 'CB '
            ANAME(j+5) = 'CG '
            ANAME(j+6) = 'CD '
            ANAME(j+7) = 'CE '
            ANAME(j+8) = 'NZ '
            EndIf

            If (RESN(i) .EQ. 'MET')Then
            ANAME(j+4) = 'CB '
            ANAME(j+5) = 'CG '
            ANAME(j+6) = 'SD '
            ANAME(j+7) = 'CE '
            EndIf

            If (RESN(i) .EQ. 'PHE')Then
            ANAME(j+4) = 'CB '
            ANAME(j+5) = 'CG '
            ANAME(j+6) = 'CD1'
            ANAME(j+7) = 'CD2'
            ANAME(j+8) = 'CE1'
            ANAME(j+9) = 'CE2'
            ANAME(j+10)= 'CZ '
            EndIf

            If (RESN(i) .EQ. 'PRO')Then
            ANAME(j+4) = 'CB '
            ANAME(j+5) = 'CG '
            ANAME(j+6) = 'CD '
            EndIf

            If (RESN(i) .EQ. 'SER')Then
            ANAME(j+4) = 'CB '
            ANAME(j+5) = 'OG '
            EndIf

            If (RESN(i) .EQ. 'THR')Then
            ANAME(j+4) = 'CB '
            ANAME(j+5) = 'OG1'
            ANAME(j+6) = 'CG2'
            EndIf

            If (RESN(i) .EQ. 'TRP')Then
            ANAME(j+4) = 'CB '
            ANAME(j+5) = 'CG '
            ANAME(j+6) = 'CD1'
            ANAME(j+7) = 'CD2'
            ANAME(j+8) = 'NE1'
            ANAME(j+9) = 'CE2'
            ANAME(j+10)= 'CE3'
            ANAME(j+11)= 'CZ2'
            ANAME(j+12)= 'CZ3'
            ANAME(j+13)= 'CH2'
            EndIf

            If (RESN(i) .EQ. 'TYR')Then
            ANAME(j+4) = 'CB '
            ANAME(j+5) = 'CG '
            ANAME(j+6) = 'CD1'
            ANAME(j+7) = 'CD2'
            ANAME(j+8) = 'CE1'
            ANAME(j+9) = 'CE2'
            ANAME(j+10)= 'CZ '
            ANAME(j+11)= 'OH '
            EndIf

            If (RESN(i) .EQ. 'VAL')Then
            ANAME(j+4) = 'CB '
            ANAME(j+5) = 'CG1'
            ANAME(j+6) = 'CG2'
            EndIf

            !C-TERM OXYGEN!

            If (i .EQ. NRES)Then

               ANAME(NATOM) = 'OXT'

            ElseIf (IRES(i+1) .LT. 0)Then

               ANAME(Iabs(IRES(i+1))-1) = 'OXT'

            EndIf

         EndDo

         Return

      End Subroutine
