! Subroutine: Neighbors
! Purpose: Finds Nearest Neighbors for each atom that are bonded
! Written: April 17th 2006
! Last Update: January 20th 2009
! Author: Eric Dykeman

! NOTES: VARIABLES
!             RAT - (NAT,3) List of Coordinates for each atom
!           ITYPE - (NAT) List of Atom Types
!          LNEIGH - (i,NNMAX) List Of Neighbors
!          NNEIGH - (NAT) Number of Neighbors per atom
!             NAT - Total Number of Atoms in the system
!           NNMAX - Maximum Number of Neighbors per atom
!
!        DEPENDANCIES
!

! **********************************************************************

      Subroutine Neighbors (RAT,ITYPE,LNEIGH,NNEIGH,NAT,NNMAX)

         Implicit None

      !Variable Declaration!

         Double Precision, Intent(In) :: RAT
         Integer, Intent(Out) :: LNEIGH,NNEIGH
         Integer, Intent(In) :: ITYPE,NAT,NNMAX

         Dimension RAT(NAT,3),ITYPE(NAT),LNEIGH(NAT,NNMAX),NNEIGH(NAT)

      !Local Variables!

         Double Precision RCUT,RDEF,ROFF,DIST,R12
         Integer i,j,k,itp,jtp,iATM,jATM,iBAD,MAXBD

         Parameter (RDEF = 2.5d0)  !Default Bond Distance!
         Parameter (ROFF = 0.3d0)  !Bond Distance Offset!

         Dimension R12(3),RCUT(100,100),MAXBD(100)

      !ROUTINE!

         !Set Max Bonds!

         Do i=1,100
         MAXBD(i) = 4
         EndDo

         MAXBD(1) = 1
         MAXBD(6) = 4
         MAXBD(7) = 4
         MAXBD(8) = 2
         MAXBD(16) = 2

         !Set Cutoff Radius to Search For Bonds!

         Do i=1,100
         Do j=1,100
         RCUT(i,j) = RDEF
         EndDo
         EndDo

         !Reasonable Peptide Bond Lengths!

         RCUT(1,1) = 0.8d0 + ROFF
         RCUT(1,6) = 1.1d0 + ROFF
         RCUT(1,7) = 1.0d0 + ROFF
         RCUT(1,8) = 1.0d0 + ROFF 
         RCUT(1,16) = 1.1d0 + ROFF

         RCUT(6,6) = 1.4d0 + ROFF
         RCUT(6,7) = 1.4d0 + ROFF
         RCUT(6,8) = 1.2d0 + ROFF
         RCUT(6,16) = 1.8d0 + ROFF

         RCUT(7,7) = 1.2d0 + ROFF
         RCUT(7,8) = 1.2d0 + ROFF
         RCUT(7,16) = 1.3d0 + ROFF

         RCUT(8,8) = 1.0d0 + ROFF
!        RCUT(8,15) = 1.5d0 + ROFF
         RCUT(8,16) = 1.3d0 + ROFF

!        RCUT(15,15) = 2.1d0 + ROFF

         RCUT(16,16) = 1.9d0 + ROFF

         Do i=1,100
         Do j=1,i
         RCUT(i,j) = RCUT(j,i)
         EndDo
         EndDo


         Do i=1,NAT
         NNEIGH(i) = 0
         EndDo

         Do i=1,NAT-1
         Do j=i+1,NAT

            itp = ITYPE(i)
            jtp = ITYPE(j)

            Do k=1,3
            R12(k) = RAT(i,k) - RAT(j,k)
            If (Dabs(R12(k)) .GT. RCUT(itp,jtp))Goto 10
            EndDo

            DIST = R12(1)**2 + R12(2)**2 + R12(3)**2
            DIST = Dsqrt(DIST)

            If (DIST .GT. RCUT(itp,jtp))Goto 10

            !Atom j is a Neighbor of Atom i!

            !CASE 0 - TWO H ATOMS -> SKIP!

            If (itp .EQ. 1 .AND. jtp .EQ. 1)Goto 10


            NNEIGH(i) = NNEIGH(i) + 1
            NNEIGH(j) = NNEIGH(j) + 1


            !Check Chemistry!

            iATM = 0

            If (itp .EQ. 1)Then

               iATM = i
               jATM = j

            EndIf

            If (jtp .EQ. 1)Then

               iATM = j
               jATM = i
               jtp = itp
               itp = 1

            EndIf


            If (iATM .NE. 0)Then
            If (NNEIGH(iATM) .GT. MAXBD(itp))Then

               !CASE 1 - ONE H ATOM!

               Write(*,*)' '
               Write(*,*)'ERROR: ATOM #',iATM,'HAS TOO MANY NEIGHBORS'
               Write(*,*)'TYPE= ',itp,' # NEIGHBORS = ',NNEIGH(iATM)
               Write(*,*)' '

               !Reset number of neighbors!

               NNEIGH(iATM) = NNEIGH(iATM) - 1
                 
               Do k=1,NNEIGH(iATM)
               Write(*,*)'# ',LNEIGH(iATM,k),&
                         &' TYPE= ',ITYPE(LNEIGH(iATM,k))
               EndDo

               Write(*,*)'# ',jATM,' TYPE= ',jtp
               Write(*,*)' '

               Write(*,*)'PLEASE ENTER ATOM NUMBER THAT IS !!NOT!!'
               Write(*,*)'A NEIGHBOR OF THIS HYDROGEN ATOM'
               Read(*,*)iBAD
               Write(*,*)' '

               If (iBAD .EQ. jATM)Then

                  NNEIGH(jATM) = NNEIGH(jATM) - 1

                  Goto 10

               Else

                  Do k=1,NNEIGH(iBAD)
                  If (LNEIGH(iBAD,k) .EQ. iATM)Then
                  LNEIGH(iBAD,k) = LNEIGH(iBAD,NNEIGH(iBAD))
                  EndIf
                  EndDo

                  NNEIGH(iBAD) = NNEIGH(iBAD) - 1

                  LNEIGH(iATM,1) = 0

                  !Check Chemistry of atom jATM!

                  If (NNEIGH(jATM) .GT. MAXBD(jtp))Then

                     Write(*,*)' '
                     Write(*,*)'FATAL ERROR!!'
                     Write(*,*)'ATOM #',jATM,'HAS TOO MANY NEIGHBORS'
                     Write(*,*)'TYPE = ',jtp
                     Write(*,*)'# NEIGHBORS = ',NNEIGH(jATM)
                     Write(*,*)' '

                     Stop

                  EndIf

               EndIf

            EndIf
            Else

               !CASE 2 - NO H ATOMS!

               iBAD = 0

               If (NNEIGH(i) .GT. MAXBD(itp))Then

                  Write(*,*)' '
                  Write(*,*)'FATAL ERROR!!'
                  Write(*,*)'ATOM #',i,'HAS TOO MANY NEIGHBORS'
                  Write(*,*)'TYPE = ',itp
                  Write(*,*)'# NEIGHBORS = ',NNEIGH(i)
                  Write(*,*)' '

                  iBAD = 1

               EndIf

               If (NNEIGH(j) .GT. MAXBD(jtp))Then

                  Write(*,*)' '
                  Write(*,*)'FATAL ERROR!!'
                  Write(*,*)'ATOM #',j,'HAS TOO MANY NEIGHBORS'
                  Write(*,*)'TYPE = ',jtp
                  Write(*,*)'# NEIGHBORS = ',NNEIGH(j)
                  Write(*,*)' '

                  iBAD = 1

               EndIf

               If (iBAD .EQ. 1)Stop

            EndIf

            LNEIGH(i,NNEIGH(i)) = j
            LNEIGH(j,NNEIGH(j)) = i

 10         Continue

         EndDo
         EndDo

         Return

      End Subroutine
