! Program: Pdb4jmol
! Purpose: Makes a pdb file for use in jmol. This will allow one to draw
!          proteins in there secondary structure format.
! Written: August 7th 2007
! Last Update: March 20th 2009
! Author: Eric Dykeman

! NOTES:

! **********************************************************************

      Program Pdb4jmol

         Use SystemParam

         Implicit None

      !Variable Declaration!

         Double Precision, Dimension(:,:), Allocatable :: RTEMP
         Integer, Dimension (:), Allocatable :: iSHIFT

         Double Precision C,D,AMP,X,Y,Z,XOCC,TF
         Integer i,j,k,iS,jS,jE,iFRM,NFRM,MXFRMT,MXFRMV,NARG
         Integer iSITE,jATM,N,NUM,ISC,iFMT,iEV,iMOV,iTFAC,IZ

         Character*60 FILEIN,FILEOUT,JUNK,CNUM,ARG
         Character CIDN,ANAME*2,CWRK*3

      !ROUTINE!

         AMP = 15.0d0    !DEFAULT AMPLITUDE FOR VIBRATION!

         MXFRMT = 1000   !MAXIMUM NUMBER OF TRAJECTORY FRAMES!
         MXFRMV = 10     !MAXIMUM NUMBER OF FRAMES FOR VIBRATION!

         D = 8.0d0*Datan(1.0d0)/Dble(MXFRMV)


         !Get Special command Line Arguments!

         iTFAC = 0     !RUN TEMERATURE FACTOR COLORING!

         NARG = Iargc()

         If (NARG .NE. 0)Then

            Do i=1,NARG

            Call GetArg(i,ARG)

            Select Case (ARG)
               Case ('-T')
               iTFAC = 1
               Case Default
               Write(*,*)ARG,'Invalid Reference'
            End Select

            EndDo

         EndIf

         Write(*,*)' '
         Write(*,*)'PDB4JMOL SPECIAL TASKS'
         Write(*,*)' '

         If (iTFAC .EQ. 1)Then
         Write(*,*)'TEMPERATURE COLORING [-T option] (ON)'
         Else
         Write(*,*)'TEMPERATURE COLORING [-T option] (OFF)'
         EndIf
         Write(*,*)' '


         !START MAIN PROGRAM!

         Write(*,*)'WELCOME TO PDB4JMOL!'
         Write(*,*)' '
         Write(*,*)'WE WILL CONSTRUCT A PDB IN A SPECIAL FORMAT'
         Write(*,*)'THAT CAN BE DRAWN AS A SECONDARY STRUCTURE IN JMOL'
         Write(*,*)' '

         Write(*,*)'ENTER THE COORDINATE FILE NAME (GF2K OR XYZ)'
         Read(*,*)FILEIN
         Write(*,*)' '

         Write(*,*)'WHAT FORMAT IS THIS?'
         Write(*,*)'GF2K ----> ENTER 1'
         Write(*,*)'XYZ  ----> ENTER 2'
         Read(*,*)iFMT
         Write(*,*)' '

         NSITE = 1

         Write(*,*)'HOW MANY "SITES" OR IDENTICAL COPIES OF THE'
         Write(*,*)'PROTEIN ARE IN THIS COORD FILE?'
         Write(*,*)'FOR ICOSAHEDRON THIS IS ALWAYS 60'
         Write(*,*)'DEFAULT = 1'
         Read(*,*)NSITE
         Write(*,*)' '

         iEV = 2

         If (iFMT .EQ. 2)Then

            Write(*,*)'DOES THE XYZ FILE CONTAIN EIGENVECTOR INFO?'
            Write(*,*)' '
            Write(*,*)'YES -----> ENTER 1'
            Write(*,*)'NO  -----> ENTER 2'
            Read(*,*)iEV
            Write(*,*)' '

         EndIf


         !READ IN DATA FILE!

         Open(Unit=1,File=FILEIN,Status='Unknown')

         Read(1,*)NTOT

         NAT = NTOT/NSITE

         !ONLY READ IN ONE "SITE" FOR ANALYSIS!

         Allocate(ITYPE(NAT),RAT(NAT,3))

         If (iFMT .EQ. 1)Then

            Do i=1,NAT
            Read(1,*)ITYPE(i),RAT(i,1),RAT(i,2),RAT(i,3)
            EndDo

         ElseIf (iFMT .EQ. 2)Then

            Read(1,*)JUNK

            If (iEV .EQ. 1)Then

               Do i=1,NAT
               Read(1,*)ANAME,RAT(i,1),RAT(i,2),RAT(i,3),X,Y,Z
               Call GetType (ANAME,ITYPE(i))
               EndDo

            Else

               Do i=1,NAT
               Read(1,*)ANAME,RAT(i,1),RAT(i,2),RAT(i,3)
               Call GetType (ANAME,ITYPE(i))
               EndDo

            EndIf

         EndIf

         Rewind(Unit=1)

         !NOW READ IN ENTIRE FILE!

         Read(1,*)NTOT

         Allocate(RTEMP(NTOT,3),U(NTOT,3),TFAC(NTOT))

         If (iFMT .EQ. 1)Then

            Do i=1,NTOT
            Read(1,*)j,RTEMP(i,1),RTEMP(i,2),RTEMP(i,3)
            EndDo

         ElseIf (iFMT .EQ. 2)Then

            Read(1,*)JUNK

            If (iEV .EQ. 1)Then
            Read(1,*)(ANAME,RTEMP(i,1),RTEMP(i,2),RTEMP(i,3),&
                     &U(i,1),U(i,2),U(i,3),i=1,NTOT)
            Else
            Read(1,*)(ANAME,RTEMP(i,1),RTEMP(i,2),RTEMP(i,3),i=1,NTOT)
            EndIf

         EndIf

         !CALCULATE TFACTOR's FOR PDB?!
         !THIS HAS TO BE DONE BEFORE ANALYZE!
         !IS CALLED AS IT OVERWRITES ITYPE!

         Do i=1,NTOT
         TFAC(i) = 0.0d0
         EndDo

         If (iTFAC .EQ. 1)Then

            Call TFactor !(iEV)

         EndIf


         !Perform Analysis of Proteins!

         Call Analyze

         Allocate(PDBN(NATOM),CID(NATOM),RNUM(NATOM))

         Call GetName (PDBN,RESN,IRES,NATOM,NRES)

         !Get Chain ID's and RNUM!

         CIDN = 'A'
         ISC = 1

         Do i=1,NRES

            If (IRES(i) .LT. 0)Then

               ISC = 1

               If (CIDN .EQ. 'Z')Then
               Write(*,*)'ERROR - TOO MANY PROTEIN CHAINS'
               Stop
               EndIf

               If (CIDN .EQ. 'Y')CIDN = 'Z'
               If (CIDN .EQ. 'X')CIDN = 'Y'
               If (CIDN .EQ. 'W')CIDN = 'X'
               If (CIDN .EQ. 'V')CIDN = 'W'
               If (CIDN .EQ. 'U')CIDN = 'V'
               If (CIDN .EQ. 'T')CIDN = 'U'
               If (CIDN .EQ. 'S')CIDN = 'T'
               If (CIDN .EQ. 'R')CIDN = 'S'
               If (CIDN .EQ. 'Q')CIDN = 'R'
               If (CIDN .EQ. 'P')CIDN = 'Q'
               If (CIDN .EQ. 'O')CIDN = 'P'
               If (CIDN .EQ. 'N')CIDN = 'O'
               If (CIDN .EQ. 'M')CIDN = 'N'
               If (CIDN .EQ. 'L')CIDN = 'M'
               If (CIDN .EQ. 'K')CIDN = 'L'
               If (CIDN .EQ. 'J')CIDN = 'K'
               If (CIDN .EQ. 'I')CIDN = 'J'
               If (CIDN .EQ. 'H')CIDN = 'I'
               If (CIDN .EQ. 'G')CIDN = 'H'
               If (CIDN .EQ. 'F')CIDN = 'G'
               If (CIDN .EQ. 'E')CIDN = 'F'
               If (CIDN .EQ. 'D')CIDN = 'E'
               If (CIDN .EQ. 'C')CIDN = 'D'
               If (CIDN .EQ. 'B')CIDN = 'C'
               If (CIDN .EQ. 'A' .AND. i .NE. 1)CIDN = 'B'

            EndIf

            jS = Iabs(IRES(i))

            If (i .LT. NRES)Then
            jE = Iabs(IRES(i+1)) - 1
            Else
            jE = NATOM
            EndIf

            Do j=jS,jE
            CID(j) = CIDN
            RNUM(j) = ISC
            EndDo

            ISC = ISC + 1

         EndDo


         !MAKE A MOVIE?!

         iMOV = 2

         If (iEV .EQ. 1)Then

            Write(*,*)'DO YOU WISH TO MAKE A VIBRATIONAL MOVIE USING'
            Write(*,*)'THE EIGENVECTOR DATA IN THE XYZ FILE?'
            Write(*,*)'YES ---> ENTER 1'
            Write(*,*)'NO  ---> ENTER 2'
            Read(*,*)iMOV
            Write(*,*)' '

         EndIf

         !Get Vibration Amplitude For Movie!

         If (iEV .EQ. 1 .AND. iMOV .EQ. 1)Then

            C = 0.0d0

            Do i=1,NTOT
            Do j=1,3
            If (Dabs(U(i,j)) .GT. C)C = Dabs(U(i,j))
            EndDo
            EndDo

            AMP = AMP/C

         EndIf

         !IF GRP I, DECIDE WHICH SITES TO OUTPUT!

         Allocate(ISHIFT(NSITE))

         iSITE = 1

         If (NSITE .EQ. 60)Then

            Write(*,*)'IF YOU HAVE ICOSAHEDRAL SYMMETRY'
            Write(*,*)'THEN YOU CAN OUTPUT THE FOLLOWING'
            Write(*,*)'WHOLE THING ----> ENTER 1'
            Write(*,*)'C5 SITE     ----> ENTER 2'
            Write(*,*)'C3 SITE     ----> ENTER 3'
            Write(*,*)'C2 SITE     ----> ENTER 4'
            Write(*,*)'1 SITE      ----> ENTER 5'
            Write(*,*)'DEFAULT = 1'
            Read(*,*)iSITE
            Write(*,*)' '

         EndIf

         Select Case (iSITE)
            Case (1)
               Do i=1,NSITE
               iSHIFT(i) = i
               EndDo
            Case (2)
               NSITE = 5
               iSHIFT(1) = 1
               iSHIFT(2) = 2
               iSHIFT(3) = 3
               iSHIFT(4) = 14
               iSHIFT(5) = 15
            Case (3)
               NSITE = 6
               iSHIFT(1) = 1
               iSHIFT(2) = 2
               iSHIFT(3) = 6
               iSHIFT(4) = 30
               iSHIFT(5) = 31
               iSHIFT(6) = 47
            Case (4)
               NSITE = 2
               iSHIFT(1) = 1
               iSHIFT(2) = 47
            Case (5)
               NSITE = 1
               iSHIFT(1) = 1
            Case Default
               Write(*,*)'NOT A VALID CHOICE'
               Stop
         End Select


         !Write out PDB file!

         Write(*,*)'ENTER OUTPUT PDB FILE NAME'
         Read(*,*)FILEOUT
         Write(*,*)' '
         Write(*,*)'NOTE: BECAUSE THIS PROGRAM ALSO MAKES MOVIE'
         Write(*,*)'FILES THE FILE GETS A 1,2, .. IN FRONT.'
         Write(*,*)' '

         NFRM = MXFRMT

         If (iEV .EQ. 1 .AND. iMOV .EQ. 1)NFRM = MXFRMV

         Do iFRM=1,NFRM

            Write(JUNK,*)iFRM

            CNUM = Trim(JUNK)//FILEOUT
            Read(CNUM,*)JUNK

            If (iEV .EQ. 1 .AND. iMOV .EQ. 1)Then
            C = AMP*DSin(D*Dble(iFRM-1))
            EndIf

            Open(Unit=2,File=JUNK,Status='Unknown')

            Do iS=1,NSITE

               NUM = 0

            Do i=1,NRES

               jS = Iabs(IRES(i))

               If (i .LT. NRES)Then
               jE = Iabs(IRES(i+1)) - 1
               Else
               jE = NATOM
               EndIf

               If (IRES(i) .LT. 0 .AND. i .GT. 1)Then
               NUM = NUM + 1
               Write(2,111)'TER   ',NUM,'   ',RESN(i-1),&
                          &CID(jS-1),RNUM(jS-1)
               EndIf

               Do j=jS,jE

                  NUM = NUM + 1

                  jATM = ISWP(j) + (iSHIFT(iS) - 1)*NAT

                  CWRK = PDBN(j)
                  ANAME = CWRK(1:1)
                  Call GetType(ANAME,IZ)

                  XOCC = 1.0d0
                  TF = TFAC(jATM)

                  If (iEV .EQ. 1 .AND. iMOV .EQ. 1)Then
                  X = RTEMP(jATM,1) + C*U(jATM,1)
                  Y = RTEMP(jATM,2) + C*U(jATM,2)
                  Z = RTEMP(jATM,3) + C*U(jATM,3)
                  Else
                  X = RTEMP(jATM,1)
                  Y = RTEMP(jATM,2)
                  Z = RTEMP(jATM,3)
                  EndIf

                  Write(2,110)'ATOM  ',NUM,PDBN(j),RESN(i),&
                             &CID(j),RNUM(j),X,Y,Z,XOCC,TF,IZ

               EndDo

            EndDo

            NUM = NUM + 1
            Write(2,111)'TER   ',NUM,'   ',RESN(NRES),&
                       &CID(NATOM),RNUM(NATOM)

            EndDo

            Close(Unit=2)


            !Read in next Trajectory!

            If (iMOV .NE. 1)Then

               Read(1,*,End=10)j

            If (iFMT .EQ. 1)Then

               Read(1,*)(j,RTEMP(i,1),RTEMP(i,2),RTEMP(i,3),i=1,NTOT)

            ElseIf (iFMT .EQ. 2)Then

               Read(1,*)JUNK

               If (iEV .EQ. 1)Then
               Read(1,*)(ANAME,RTEMP(i,1),RTEMP(i,2),RTEMP(i,3),&
                        &U(i,1),U(i,2),U(i,3),i=1,NTOT)
               Else
               Read(1,*)(ANAME,RTEMP(i,1),RTEMP(i,2),&
                        &RTEMP(i,3),i=1,NTOT)
               EndIf

            EndIf

            EndIf

         EndDo

         If (iMOV .NE. 1)Then
         Write(*,*)'THERE ARE MORE THAN 1000 FRAMES'
         Write(*,*)'I CANT HANDLE THAT MANY YET!'
         Stop
         EndIf

  10     Close(Unit=1)
  
 110     Format(A6,I5,2X,A3,1X,A3,1X,A1,I4,1X,3X,3F8.3,2F6.2,I4)
 111     Format(A6,I5,2X,A3,1X,A3,1X,A1,I4)

      End Program
