! Subroutine: TFactor
! Purpose: Computes a number to place in the temperature column of the PDB
!          The number is computed by:
!          1) Calculating the BFACTOR of atoms using atomic vibrational
!             modes computed in Saguaro.
!          The result is stored in TFAC(NTOT) array.
! Written: March 20th 2009
! Last Update: March 20th 2009
! Author: Eric Dykeman

! NOTES: VARIABLES
!        SystemParam - Global system variables
!
!        DEPENDANCIES
!

! **********************************************************************

      Subroutine TFactor

         Use SystemParam, Only : U,TFAC,ITYPE,NAT,NTOT,NSITE

         Implicit None

      !Variable Declaration!

      !Local Variables!

         Double Precision AMASS,EVEC,FACTOR,W,X,STOT
         Integer i,j,k,NEV,NMAT,iSTART
         Character*60 VIBFILE

         Dimension AMASS(100),EVEC(NTOT,3)

      !ROUTINE!

         !8*(PI^2)*KT/M!

         FACTOR = 5.510561825d5

         Do i=1,100
         AMASS(i) = 0.0d0
         EndDo

         AMASS(1) = 1.008d0
         AMASS(6) = 1.201d1
         AMASS(7) = 1.401d1
         AMASS(8) = 1.599d1
         AMASS(15) = 3.097d1
         AMASS(16) = 3.207d1


         Write(*,*)'-------------------- TFACTOR ----------------------'
         Write(*,*)' '

         Write(*,*)'THIS UTILITY WILL COMPUTE A TFACTOR NUMBER FOR THE'
         Write(*,*)'PDB FILE ALLOWING THE PROTEIN TO BE COLORED'
         Write(*,*)'BLUE (0) - WHITE (50) - RED (100) ACCORDINGLY'
         Write(*,*)' '

         Write(*,*)'THE COLORING METHOD IS BY B FACTOR (T=300K)'
         Write(*,*)' '

         !COMPUTE BFACTOR!

         !GET VIBRATIONAL DATA!

         Write(*,*)'PLEASE ENTER THE VIBRATIONAL DATA FILE'
         Read(*,*)VIBFILE
         Write(*,*)VIBFILE
         Write(*,*)' '

         Write(*,*)'ENTER STARTING EVECTOR NUMBER'
         Write(*,*)'DEFAULT = 7'
         Read(*,*)iSTART
         Write(*,*)iSTART
         Write(*,*)' '

         Open (Unit=99,File=VIBFILE,Status='Unknown')

         Read(99,*)NMAT,NEV

         Do i=1,NEV

            Read(99,*)W,X

            Do j=1,NTOT
            Read(99,*)EVEC(j,1),EVEC(j,2),EVEC(j,3)
            EndDo

            If (i .GE. iSTART)Then
            Do j=1,NTOT

               X = EVEC(j,1)**2
               X = X + EVEC(j,2)**2
               X = X + EVEC(j,3)**2

               X = X/(W*W)

               TFAC(j) = TFAC(j) + X

            EndDo
            EndIf

         EndDo


         !NOTE: PDB4JMOL READS IN ONE PROTEIN SITE SO'
         !THE TOTAL NUMBER OF ATOMS (NTOT = NSITE*NAT)!

         !ITYPE RANGES FROM 1-NAT!

         Do i=1,NSITE
         Do j=1,NAT

            k = NAT*(i-1) + j

            X = AMASS(ITYPE(j))

            If (X .EQ. 0.0d0)Then
            Write(*,*)'ERROR - NO MASS IS ENTERED FOR ATOM TYPE'
            Write(*,*)'ATOM = ',j,' ITYPE = ',ITYPE(j)
            Stop
            EndIf

            X = FACTOR/X

            TFAC(k) = TFAC(k)*X

         EndDo
         EndDo

         Close (Unit=99)

         Return

      End Subroutine
