! ==============================================================================
! Program: FIXPDB
! 
! Description: Fixes a PDB file so that it can be used in pymol.
!
! Notes:
!
! History:
!
! Version    Date         Comment
! --------   ----------   -----------------------
!            07/25/2014   Original Code
!
! Dependancies:
!
! Modules -
! Functions -
! Subroutines -
!
! Author(s): Eric Dykeman
!
! ==============================================================================

      PROGRAM FIXPDB

        IMPLICIT NONE

        DOUBLE PRECISION, DIMENSION(:), ALLOCATABLE :: xr,yr,zr
        DOUBLE PRECISION, DIMENSION(:), ALLOCATABLE :: xat,yat,zat
        DOUBLE PRECISION, DIMENSION(:), ALLOCATABLE :: roc,rtf

        INTEGER, DIMENSION(:), ALLOCATABLE :: ires

        CHARACTER (LEN=6), DIMENSION(:), ALLOCATABLE :: recid
        CHARACTER (LEN=4), DIMENSION(:), ALLOCATABLE :: pdbn
        CHARACTER (LEN=3), DIMENSION(:), ALLOCATABLE :: resn
        CHARACTER (LEN=1), DIMENSION(:), ALLOCATABLE :: cid

        DOUBLE PRECISION :: grot(3,3),gt(3)

        INTEGER :: i,j,k,ios,nat,iatm,icnt
        INTEGER :: igrp,ngrp,ifmt,isym

        CHARACTER (LEN=6) :: rname
        CHARACTER (LEN=4) :: pname
        CHARACTER (LEN=3) :: segid
        CHARACTER (LEN=1) :: aloc,ains

        CHARACTER (LEN=70) :: pdbfile,symfile,outfile,fmat


        !=== WELCOME ===!

        WRITE(*,*)'---------------- Welcome To FIXPDB -----------------'
        WRITE(*,*)' '
        WRITE(*,*)'   This program fixes a PDB file for use in pymol   '
        WRITE(*,*)' '

        WRITE(*,*)'Enter the name of the PDB file to fix.'
        READ(*,*)pdbfile
        WRITE(*,*)' '

        WRITE(*,*)'Enter the name of the output PDB file.'
        READ(*,*)outfile
        WRITE(*,*)' '

        OPEN (UNIT = 1, FILE = pdbfile, STATUS = 'Unknown')
        OPEN (UNIT = 3, FILE = outfile, STATUS = 'Unknown')


        !=== Read in Asymmetric Unit ===!

        nat = 0
        ios = 0

        DO WHILE ( ios == 0 )

          READ(1,'(A6)',IOSTAT=ios)rname

          IF ( rname == 'ATOM  ' .or. rname == 'HETATM' ) THEN

            BACKSPACE (UNIT=1)

            READ(1,100,IOSTAT=ios)rname,iatm,pname,aloc

            IF ( aloc == ' ' ) nat = nat + 1
            IF ( aloc == 'A' ) nat = nat + 1

          ENDIF

        ENDDO

        !=== Allocate space ===!

        ALLOCATE (recid(nat),pdbn(nat),resn(nat),cid(nat),ires(nat))
        ALLOCATE (xat(nat),yat(nat),zat(nat),roc(nat))
        ALLOCATE (xr(nat),yr(nat),zr(nat),rtf(nat))

        i = 0
        ios = 0

        REWIND (UNIT=1)

        DO WHILE ( ios == 0 )

          READ(1,'(A6)',IOSTAT=ios)rname

          IF ( rname == 'ATOM  ' .or. rname == 'HETATM' ) THEN

            BACKSPACE (UNIT=1)

            i = i + 1

            READ(1,110,IOSTAT=ios)recid(i),iatm,pdbn(i),aloc,resn(i),&
            & cid(i),ires(i),ains,xat(i),yat(i),zat(i),roc(i),rtf(i)

            IF ( rname == 'HETATM' ) THEN
            IF ( cid(i) == ' ' ) cid(i) = '9'
            ENDIF

            IF ( aloc /= ' ' .and. aloc /= 'A' ) i = i - 1

          ENDIF

        ENDDO


        !=== WRITE OUT NEW PDB ===!

        icnt = 1

        !=== Apply Symmetry ===!

        WRITE(*,*)'Do you want to apply symmetry rotations to the file?'
        WRITE(*,*)'YES                                      --- ENTER 1'
        WRITE(*,*)'NO                                       --- ENTER 2'
        WRITE(*,*)' '
        READ(*,*)isym
        WRITE(*,*)' '

        IF ( isym == 1 ) THEN

          WRITE(*,*)'Enter the name of the symmetry file.'
          READ(*,*)symfile
          WRITE(*,*)' '

          !=== Rotations or R + Translations? ===!

          WRITE(*,*)'Does the symmetry file contain:'
          WRITE(*,*)'Rotations ONLY                         --- ENTER 1'
          WRITE(*,*)'Rotations AND Translations             --- ENTER 2'
          WRITE(*,*)' '
          READ(*,*)ifmt
          WRITE(*,*)' '

          IF ( ifmt < 1 .or. ifmt > 2 ) THEN

            WRITE(*,*)'ERROR: Invalid choice. You entered ',ifmt
            STOP

          ENDIF

          OPEN (UNIT = 2, FILE = symfile, STATUS = 'Unknown')

          !=== Read in Symmetry File ===!

          READ(2,*)ngrp

          DO igrp=1,ngrp

            IF ( ifmt == 1 ) THEN

              READ(2,*)grot(1,1),grot(1,2),grot(1,3)
              READ(2,*)grot(2,1),grot(2,2),grot(2,3)
              READ(2,*)grot(3,1),grot(3,2),grot(3,3)

            ELSEIF ( ifmt == 2 ) THEN

              READ(2,*)grot(1,1),grot(1,2),grot(1,3),gt(1)
              READ(2,*)grot(2,1),grot(2,2),grot(2,3),gt(2)
              READ(2,*)grot(3,1),grot(3,2),grot(3,3),gt(3)

            ENDIF

            !=== Rotate ===!

            DO i=1,nat

              xr(i) = grot(1,1) * xat(i) + grot(1,2) * yat(i) &
                  & + grot(1,3) * zat(i)

              yr(i) = grot(2,1) * xat(i) + grot(2,2) * yat(i) &
                  & + grot(2,3) * zat(i)

              zr(i) = grot(3,1) * xat(i) + grot(3,2) * yat(i) &
                  & + grot(3,3) * zat(i)

              IF ( ifmt == 2 ) THEN
                xr(i) = xr(i) + gt(1)
                yr(i) = yr(i) + gt(2)
                zr(i) = zr(i) + gt(3)
              ENDIF

            ENDDO

            !=== Write to PDB ===!

            iatm = 0

            DO i=1,nat

              iatm = iatm + 1

              WRITE(segid,'(I3)')icnt
              segid = ADJUSTL(segid)

              WRITE(3,300)recid(i),iatm,pdbn(i),resn(i),cid(i),ires(i),&
                        & xr(i),yr(i),zr(i),roc(i),rtf(i),cid(i),segid

              IF ( i < nat ) THEN
              IF ( cid(i+1) /= cid(i) ) THEN

                  icnt = icnt + 1
                  iatm = iatm + 1

                  WRITE(3,310)'TER   ',iatm,resn(i),cid(i),ires(i)

              ENDIF
              ENDIF

            ENDDO

            icnt = icnt + 1
            iatm = iatm + 1

            WRITE(3,310)'TER   ',iatm,resn(nat),cid(nat),ires(nat)

          ENDDO

          CLOSE (UNIT = 2)

        ELSE

          !=== Write to PDB ===!

          iatm = 0

          DO i=1,nat

            iatm = iatm + 1

            WRITE(segid,'(I3)')icnt
            segid = ADJUSTL(segid)

            WRITE(3,300)recid(i),iatm,pdbn(i),resn(i),cid(i),ires(i),&
                     & xat(i),yat(i),zat(i),roc(i),rtf(i),cid(i),segid

            IF ( i < nat ) THEN
            IF ( cid(i+1) /= cid(i) ) THEN

                icnt = icnt + 1
                iatm = iatm + 1

                WRITE(3,310)'TER   ',iatm,resn(i),cid(i),ires(i)

            ENDIF
            ENDIF

          ENDDO

          icnt = icnt + 1
          iatm = iatm + 1

          WRITE(3,310)'TER   ',iatm,resn(nat),cid(nat),ires(nat)

        ENDIF

        CLOSE (UNIT = 1)
        CLOSE (UNIT = 3)

        !=== DEALLOCATE ARRAYS ===!

        DEALLOCATE (recid,pdbn,resn,cid,ires,roc,rtf)
        DEALLOCATE (xat,yat,zat,xr,yr,zr)

 100    FORMAT(A6,I5,1X,A4,A1)
 110    FORMAT(A6,I5,1X,A4,A1,A3,1X,A1,I4,A1,3X,3F8.3,2F6.2)

 300    FORMAT(A6,I5,1X,A4,1X,A3,1X,A1,I4,4X,3F8.3,2F6.2,6X,A1,A3)
 310    FORMAT(A6,I5,6X,A3,1X,A1,I4)

        END PROGRAM FIXPDB
