! Subroutine: AddH
! Purpose: Adds Missing Hydrogen Atoms to Amino Acid Residues
! Written: April 12th 2006
! Last Update: October 26th 2007
! Author: Eric Dykeman

! NOTES: VARIABLES
!           RAT - (NAT,3) List of atomic coordinates
!         ITYPE - (NAT) List of Atom Types
!          RESN - (NRES) List of Residue Names
!          IRES - (NRES) List of First Atom Numbers For Each Amino Acid
!           NAT - Total Number of Atoms in the System
!          NRES - Total Number of Amino Acid Residues in the System
!
!        DEPENDANCIES
!        SystemParam - Global system parameters
!        CreateH TwoCoord ThreeCoord FourCoord -- Included At End
!

! **********************************************************************

      Subroutine AddH

         Use SystemParam, Only : RAT,ITYPE,RESN,IRES,NAT,NRES

         Implicit None

      !Variable Declaration!

      !Local Variables!

         Double Precision ROLD 
         Integer i,j,k,l,jS,jE,N,NH,iATM
         Integer ITOLD

         Dimension ROLD(NAT,3),ITOLD(NAT)

      !ROUTINE!

         !Make Backup Copy Of Coordinates!

         Do i=1,NAT
         Do j=1,3
         ROLD(i,j) = RAT(i,j)
         EndDo
         EndDo

         Do i=1,NAT
         ITOLD(i) = ITYPE(i)
         EndDo

         !First Figure Out How Many Hydrogens To Add!

         N = 0

         Do i=1,NRES

            jS = Iabs(IRES(i))

            If (i .NE. NRES)Then
            jE = Iabs(IRES(i+1)) - 1
            Else
            jE = NAT
            EndIf


            !Alanine - ALA!

            If (RESN(i) .EQ. 'ALA')k = 10

            !Arginine - ARG!

            If (RESN(i) .EQ. 'ARG')k = 24

            !Asparagine - ASN!

            If (RESN(i) .EQ. 'ASN')k = 14

            !Aspartic Acid - ASP!

            If (RESN(i) .EQ. 'ASP')k = 12

            !Cystine - CYS!

            If (RESN(i) .EQ. 'CYS')k = 11

            !Cystine DISULFIDE - CYX!

            If (RESN(i) .EQ. 'CYX')k = 10

            !Glutamine - GLN!

            If (RESN(i) .EQ. 'GLN')k = 17

            !Glutamic Acid - GLU!

            If (RESN(i) .EQ. 'GLU')k = 15

            !Glycine - GLY!

            If (RESN(i) .EQ. 'GLY')k = 7

            !Histidine - HIS!

            If (RESN(i) .EQ. 'HIS')k = 17

            !Isolucine - ILE!

            If (RESN(i) .EQ. 'ILE')k = 19

            !Leucine - LEU!

            If (RESN(i) .EQ. 'LEU')k = 19

            !Lysine - LYS!

            If (RESN(i) .EQ. 'LYS')k = 22

            !Methionine - MET!

            If (RESN(i) .EQ. 'MET')k = 17

            !Phenalyanine - PHE!

            If (RESN(i) .EQ. 'PHE')k = 20

            !Proline!

            If (RESN(i) .EQ. 'PRO')k = 14

            !Serine - SER!

            If (RESN(i) .EQ. 'SER')k = 11

            !Threonine - THR!

            If (RESN(i) .EQ. 'THR')k = 14

            !Tyrosine - TYR!

            If (RESN(i) .EQ. 'TYR')k = 21

            !Tryptophan - TRP!

            If (RESN(i) .EQ. 'TRP')k = 24

            !Valine - VAL!

            If (RESN(i) .EQ. 'VAL')k = 16

            If (IRES(i) .LT. 0)k = k + 2

            If (i .EQ. NRES)Then
               k = k + 1
            ElseIf (IRES(i+1) .LT. 0)Then
               k = k + 1
            EndIf

            N = N + (k - (jE - jS + 1))

         EndDo


         !OK Check For Proper Hydrogens On Each Amino!
         !Add Dummy Hydrogens to coordinates 0,0,0!

         !Reallocate Arrays!

         Deallocate (RAT,ITYPE)

         Allocate (RAT(NAT+N,3),ITYPE(NAT+N))

         !Note -- Atoms Are in STANDARD Order!

         iATM = 0

         Do i=1,NRES

            jS = Iabs(IRES(i))

            If (i .NE. NRES)Then
            jE = Iabs(IRES(i+1)) - 1
            Else
            jE = NAT
            EndIf

            j = jS

            !Get NEW IRES!

            If (IRES(i) .LT. 0)Then
            IRES(i) = -(iATM + 1)
            Else
            IRES(i) = iATM + 1
            EndIf

            If (RESN(i) .EQ. 'PRO')Then
               NH = 0
            Else
               NH = 1
            EndIf

            If (IRES(i) .LT. 0)NH = NH + 2

            Call CreateH (RAT,ITYPE,ROLD,ITOLD,NAT,N,j,iATM,NH)

            If (RESN(i) .EQ. 'GLY')Then
               NH = 2
            Else
               NH = 1
            EndIf

            Call CreateH (RAT,ITYPE,ROLD,ITOLD,NAT,N,j,iATM,NH)

            !Alanine - ALA!

            If (RESN(i) .EQ. 'ALA')Then

               NH = 3

               Call CreateH (RAT,ITYPE,ROLD,ITOLD,NAT,N,j,iATM,NH)

            EndIf

            !Arginine - ARG!

            If (RESN(i) .EQ. 'ARG')Then

               Do k=1,3

               NH = 2

               Call CreateH (RAT,ITYPE,ROLD,ITOLD,NAT,N,j,iATM,NH)

               EndDo

               NH = 1

               Call CreateH (RAT,ITYPE,ROLD,ITOLD,NAT,N,j,iATM,NH)

               iATM = iATM + 1

               ITYPE(iATM) = ITOLD(j)
               Do k=1,3
               RAT(iATM,k) = ROLD(j,k)
               EndDo

               j = j + 1

               Do k=1,2

               NH = 2

               Call CreateH (RAT,ITYPE,ROLD,ITOLD,NAT,N,j,iATM,NH)

               EndDo

            EndIf

            !Asparagine - ASN!

            If (RESN(i) .EQ. 'ASN')Then

               NH = 2

               Call CreateH (RAT,ITYPE,ROLD,ITOLD,NAT,N,j,iATM,NH)

               Do k=1,2

               iATM = iATM + 1

               ITYPE(iATM) = ITOLD(j)
               Do l=1,3
               RAT(iATM,l) = ROLD(j,l)
               EndDo

               j = j + 1

               EndDo

               NH = 2

               Call CreateH (RAT,ITYPE,ROLD,ITOLD,NAT,N,j,iATM,NH)

            EndIf

            !Aspartic Acid - ASP!

            If (RESN(i) .EQ. 'ASP')Then

               NH = 2

               Call CreateH (RAT,ITYPE,ROLD,ITOLD,NAT,N,j,iATM,NH)

               Do k=1,3

               iATM = iATM + 1

               ITYPE(iATM) = ITOLD(j)
               Do l=1,3
               RAT(iATM,l) = ROLD(j,l)
               EndDo

               j = j + 1

               EndDo

            EndIf

            !Cystine - CYS!

            If (RESN(i) .EQ. 'CYS')Then

               NH = 2

               Call CreateH (RAT,ITYPE,ROLD,ITOLD,NAT,N,j,iATM,NH)

               NH = 1

               Call CreateH (RAT,ITYPE,ROLD,ITOLD,NAT,N,j,iATM,NH)

            EndIf

            !Cystine DISULFIDE - CYX!

            If (RESN(i) .EQ. 'CYX')Then

               NH = 2

               Call CreateH (RAT,ITYPE,ROLD,ITOLD,NAT,N,j,iATM,NH)

               iATM = iATM + 1

               ITYPE(iATM) = ITOLD(j)
               Do k=1,3
               RAT(iATM,k) = ROLD(j,k)
               EndDo

               j = j + 1

            EndIf

            !Glutamine - GLN!

            If (RESN(i) .EQ. 'GLN')Then

               Do k=1,2

               NH = 2

               Call CreateH (RAT,ITYPE,ROLD,ITOLD,NAT,N,j,iATM,NH)

               EndDo

               Do k=1,2

               iATM = iATM + 1

               ITYPE(iATM) = ITOLD(j)
               Do l=1,3
               RAT(iATM,l) = ROLD(j,l)
               EndDo

               j = j + 1

               EndDo

               NH = 2

               Call CreateH (RAT,ITYPE,ROLD,ITOLD,NAT,N,j,iATM,NH)

            EndIf

            !Glutamic Acid - GLU'

            If (RESN(i) .EQ. 'GLU')Then

               Do k=1,2

               NH = 2

               Call CreateH (RAT,ITYPE,ROLD,ITOLD,NAT,N,j,iATM,NH)

               EndDo

               Do k=1,3

               iATM = iATM + 1

               ITYPE(iATM) = ITOLD(j)
               Do l=1,3
               RAT(iATM,l) = ROLD(j,l)
               EndDo

               j = j + 1

               EndDo

            EndIf

            !Histidine - HIS!

            If (RESN(i) .EQ. 'HIS')Then

               NH = 2

               Call CreateH (RAT,ITYPE,ROLD,ITOLD,NAT,N,j,iATM,NH)

               iATM = iATM + 1

               ITYPE(iATM) = ITOLD(j)
               Do k=1,3
               RAT(iATM,k) = ROLD(j,k)
               EndDo

               j = j + 1

               Do k=1,2

               NH = 1

               Call CreateH (RAT,ITYPE,ROLD,ITOLD,NAT,N,j,iATM,NH)

               EndDo

               iATM = iATM + 1

               ITYPE(iATM) = ITOLD(j)
               Do k=1,3
               RAT(iATM,k) = ROLD(j,k)
               EndDo

               j = j + 1

               !If HIS is HIP SKIP the H atom!

               If (ITOLD(j) .EQ. 1)j = j + 1

               NH = 1

               Call CreateH (RAT,ITYPE,ROLD,ITOLD,NAT,N,j,iATM,NH)

            EndIf

            !IsoLucine - ILE!

            If (RESN(i) .EQ. 'ILE')Then

               NH = 1

               Call CreateH (RAT,ITYPE,ROLD,ITOLD,NAT,N,j,iATM,NH)

               NH = 3

               Call CreateH (RAT,ITYPE,ROLD,ITOLD,NAT,N,j,iATM,NH)

               NH = 2

               Call CreateH (RAT,ITYPE,ROLD,ITOLD,NAT,N,j,iATM,NH)

               NH = 3

               Call CreateH (RAT,ITYPE,ROLD,ITOLD,NAT,N,j,iATM,NH)

            EndIf

            !Leucine - LEU!

            If (RESN(i) .EQ. 'LEU')Then

               NH = 2

               Call CreateH (RAT,ITYPE,ROLD,ITOLD,NAT,N,j,iATM,NH)

               NH = 1

               Call CreateH (RAT,ITYPE,ROLD,ITOLD,NAT,N,j,iATM,NH)

               Do k=1,2

               NH = 3

               Call CreateH (RAT,ITYPE,ROLD,ITOLD,NAT,N,j,iATM,NH)

               EndDo

            EndIf

            !Lysine - LYS!

            If (RESN(i) .EQ. 'LYS')Then

               Do k=1,4

               NH = 2

               Call CreateH (RAT,ITYPE,ROLD,ITOLD,NAT,N,j,iATM,NH)

               EndDo

               NH = 3

               Call CreateH (RAT,ITYPE,ROLD,ITOLD,NAT,N,j,iATM,NH)

            EndIf

            !Methionine - MET!

            If (RESN(i) .EQ. 'MET')Then

               Do k=1,2

               NH = 2

               Call CreateH (RAT,ITYPE,ROLD,ITOLD,NAT,N,j,iATM,NH)

               EndDo

               iATM = iATM + 1

               ITYPE(iATM) = ITOLD(j)
               Do k=1,3
               RAT(iATM,k) = ROLD(j,k)
               EndDo

               j = j + 1

               NH = 3

               Call CreateH (RAT,ITYPE,ROLD,ITOLD,NAT,N,j,iATM,NH)

            EndIf

            !Phenylalanine - PHE!

            If (RESN(i) .EQ. 'PHE')Then

               NH = 2

               Call CreateH (RAT,ITYPE,ROLD,ITOLD,NAT,N,j,iATM,NH)

               iATM = iATM + 1

               ITYPE(iATM) = ITOLD(j)
               Do k=1,3
               RAT(iATM,k) = ROLD(j,k)
               EndDo

               j = j + 1

               Do k=1,5

               NH = 1

               Call CreateH (RAT,ITYPE,ROLD,ITOLD,NAT,N,j,iATM,NH)

               EndDo

            EndIf

            !Proline - PRO!

            If (RESN(i) .EQ. 'PRO')Then

               Do k=1,3

               NH = 2

               Call CreateH (RAT,ITYPE,ROLD,ITOLD,NAT,N,j,iATM,NH)

               EndDo

            EndIf

            !Serine - SER!

            If (RESN(i) .EQ. 'SER')Then

               NH = 2

               Call CreateH (RAT,ITYPE,ROLD,ITOLD,NAT,N,j,iATM,NH)

               NH = 1

               Call CreateH (RAT,ITYPE,ROLD,ITOLD,NAT,N,j,iATM,NH)

            EndIf

            !Threonine - THR!

            If (RESN(i) .EQ. 'THR')Then

               Do k=1,2

               NH = 1

               Call CreateH (RAT,ITYPE,ROLD,ITOLD,NAT,N,j,iATM,NH)

               EndDo

               NH = 3

               Call CreateH (RAT,ITYPE,ROLD,ITOLD,NAT,N,j,iATM,NH)

            EndIf

            !Tryptophan - TRP!

            If (RESN(i) .EQ. 'TRP')Then

               NH = 2

               Call CreateH (RAT,ITYPE,ROLD,ITOLD,NAT,N,j,iATM,NH)

               iATM = iATM + 1

               ITYPE(iATM) = ITOLD(j)
               Do k=1,3
               RAT(iATM,k) = ROLD(j,k)
               EndDo

               j = j + 1

               Do k=1,2

               NH = 1

               Call CreateH (RAT,ITYPE,ROLD,ITOLD,NAT,N,j,iATM,NH)

               EndDo

               iATM = iATM + 1

               ITYPE(iATM) = ITOLD(j)
               Do k=1,3
               RAT(iATM,k) = ROLD(j,k)
               EndDo

               j = j + 1

               Do k=1,4

               NH = 1

               Call CreateH (RAT,ITYPE,ROLD,ITOLD,NAT,N,j,iATM,NH)

               EndDo

               iATM = iATM + 1

               ITYPE(iATM) = ITOLD(j)
               Do k=1,3
               RAT(iATM,k) = ROLD(j,k)
               EndDo

               j = j + 1

            EndIf

            !Tyrosine - TYR!

            If (RESN(i) .EQ. 'TYR')Then

               NH = 2

               Call CreateH (RAT,ITYPE,ROLD,ITOLD,NAT,N,j,iATM,NH)

               iATM = iATM + 1

               ITYPE(iATM) = ITOLD(j)
               Do k=1,3
               RAT(iATM,k) = ROLD(j,k)
               EndDo

               j = j + 1

               Do k=1,2

               NH = 1

               Call CreateH (RAT,ITYPE,ROLD,ITOLD,NAT,N,j,iATM,NH)

               EndDo

               iATM = iATM + 1

               ITYPE(iATM) = ITOLD(j)
               Do k=1,3
               RAT(iATM,k) = ROLD(j,k)
               EndDo

               j = j + 1

               Do k=1,3

               NH = 1

               Call CreateH (RAT,ITYPE,ROLD,ITOLD,NAT,N,j,iATM,NH)

               EndDo

            EndIf

            !Valine - VAL!

            If (RESN(i) .EQ. 'VAL')Then

               NH = 1

               Call CreateH (RAT,ITYPE,ROLD,ITOLD,NAT,N,j,iATM,NH)

               Do k=1,2

               NH = 3

               Call CreateH (RAT,ITYPE,ROLD,ITOLD,NAT,N,j,iATM,NH)

               EndDo

            EndIf

            !Write Out CO Group!

            Do k=1,2

               iATM = iATM + 1

               ITYPE(iATM) = ITOLD(j)
               Do l=1,3
               RAT(iATM,l) = ROLD(j,l)
               EndDo

               j = j + 1

            EndDo

            !Check to See if Chain is at end!
            !If So Write out another O!

            If (i .EQ. NRES)Then

               iATM = iATM + 1
               ITYPE(iATM) = 8

               Do k=1,3
               RAT(iATM,k) = 0.0d0
               EndDo

            ElseIf (IRES(i+1) .LT. 0)Then

               iATM = iATM + 1

               ITYPE(iATM) = 8
               Do k=1,3
               RAT(iATM,k) = 0.0d0
               EndDo

            EndIf

         EndDo

         !Now Fix Hydrogen Positions!

         NAT = NAT + N

         Do i=1,NRES

            jS = Iabs(IRES(i))

            If (i .NE. NRES)Then
            jE = Iabs(IRES(i+1)) - 1
            Else
            jE = NAT
            EndIf

            j = jS

            If (IRES(i) .LT. 0)Then

               If (RESN(i) .NE. 'PRO')Then

               Call FourCoord (RAT(j,:),RAT(j+1,:),RAT(j+2,:),&
                             & RAT(j+3,:),RAT(j+4,:))

               j = j + 4

               Else

               Call FourCoord (RAT(j,:),RAT(j+1,:),RAT(j+2,:),&
                             & RAT(j+3,:),RAT(jE-4,:))

               j = j + 3

               EndIf

            ElseIf (RESN(i) .NE. 'PRO')Then

               Call ThreeCoord (RAT(j,:),RAT(jS-2,:),&
                              & RAT(j+1,:),RAT(j+2,:))

               j = j + 2

            Else

               j = j + 1

            EndIf

            Call FourCoord (RAT(j,:),RAT(jS,:),RAT(j+1,:),&
                          & RAT(j+2,:),RAT(jE-1,:))

            j = j + 2

            !Alanine - ALA!

            If (RESN(i) .EQ. 'ALA')Then

               Call FourCoord (RAT(j,:),RAT(j-2,:),RAT(j+1,:),&
                             & RAT(j+2,:),RAT(j+3,:))

            EndIf

            !Arginine - ARG!

            If (RESN(i) .EQ. 'ARG')Then

                Call FourCoord (RAT(j,:),RAT(j-2,:),RAT(j+1,:),&
                              & RAT(j+2,:),RAT(j+3,:))

                j = j + 3

                Do k=1,2

                Call FourCoord (RAT(j,:),RAT(j-3,:),RAT(j+1,:),&
                              & RAT(j+2,:),RAT(j+3,:))

                j = j + 3

                EndDo

                Call ThreeCoord (RAT(j,:),RAT(j-3,:),&
                               & RAT(j+1,:),RAT(j+2,:))

                j = j + 3

                Call ThreeCoord (RAT(j,:),RAT(j-1,:),&
                               & RAT(j+1,:),RAT(j+2,:))

                j = j + 3

                Call ThreeCoord (RAT(j,:),RAT(j-4,:),&
                               & RAT(j+1,:),RAT(j+2,:))

            EndIf

            !Asparagine - ASN!

            If (RESN(i) .EQ. 'ASN')Then

               Call FourCoord (RAT(j,:),RAT(j-2,:),RAT(j+1,:),&
                             & RAT(j+2,:),RAT(j+3,:))

               j = j + 5

               Call ThreeCoord (RAT(j,:),RAT(j-2,:),&
                              & RAT(j+1,:),RAT(j+2,:))

            EndIf

            !Aspartic Acid - ASP!

            If (RESN(i) .EQ. 'ASP')Then

               Call FourCoord (RAT(j,:),RAT(j-2,:),RAT(j+1,:),&
                             & RAT(j+2,:),RAT(j+3,:))

            EndIf

            !Cystine - CYS!

            If (RESN(i) .EQ. 'CYS')Then

               Call FourCoord (RAT(j,:),RAT(j-2,:),RAT(j+1,:),&
                             & RAT(j+2,:),RAT(j+3,:))

               j = j + 3

               Call TwoCoord (RAT(j,:),RAT(j-3,:),RAT(j+1,:))

            EndIf

            !Cystine DISULFIDE - CYX!

            If (RESN(i) .EQ. 'CYX')Then

               Call FourCoord (RAT(j,:),RAT(j-2,:),RAT(j+1,:),&
                             & RAT(j+2,:),RAT(j+3,:))

               j = j + 3

            EndIf

            !Glutamine - GLN!

            If (RESN(i) .EQ. 'GLN')Then

               Call FourCoord (RAT(j,:),RAT(j-2,:),RAT(j+1,:),&
                             & RAT(j+2,:),RAT(j+3,:))

               j = j + 3

               Call FourCoord (RAT(j,:),RAT(j-3,:),RAT(j+1,:),&
                             & RAT(j+2,:),RAT(j+3,:))

               j = j + 5

               Call ThreeCoord (RAT(j,:),RAT(j-2,:),&
                              & RAT(j+1,:),RAT(j+2,:))

            EndIf

            !Glutamic Acid - GLU!

            If (RESN(i) .EQ. 'GLU')Then

               Call FourCoord (RAT(j,:),RAT(j-2,:),RAT(j+1,:),&
                             & RAT(j+2,:),RAT(j+3,:))

               j = j + 3

               Call FourCoord (RAT(j,:),RAT(j-3,:),RAT(j+1,:),&
                             & RAT(j+2,:),RAT(j+3,:))

            EndIf

            !Glycine - GLY!

            If (RESN(i) .EQ. 'GLY')j = j + 1

            !Histidine - HIS!

            If (RESN(i) .EQ. 'HIS')Then

               Call FourCoord (RAT(j,:),RAT(j-2,:),RAT(j+1,:),&
                             & RAT(j+2,:),RAT(j+3,:))

               j = j + 4

               Do k=1,2

               Call ThreeCoord (RAT(j,:),RAT(j-1,:),&
                              & RAT(j+1,:),RAT(j+2,:))

               j = j + 2

               EndDo

               j = j + 1

               Call ThreeCoord (RAT(j,:),RAT(j-1,:),&
                              & RAT(j+1,:),RAT(j-6,:))

            EndIf

            !Isolucine - ILE!

            If (RESN(i) .EQ. 'ILE')Then

               Call FourCoord (RAT(j,:),RAT(j-2,:),RAT(j+1,:),&
                             & RAT(j+2,:),RAT(j+6,:))

               j = j + 2

               Call FourCoord (RAT(j,:),RAT(j-2,:),RAT(j+1,:),&
                             & RAT(j+2,:),RAT(j+3,:))

               j = j + 4

               Call FourCoord (RAT(j,:),RAT(j-6,:),RAT(j+1,:),&
                             & RAT(j+2,:),RAT(j+3,:))

               j = j + 3

               Call FourCoord (RAT(j,:),RAT(j-3,:),RAT(j+1,:),&
                             & RAT(j+2,:),RAT(j+3,:))

            EndIf

            !Leucine - LEU!

            If (RESN(i) .EQ. 'LEU')Then

               Call FourCoord (RAT(j,:),RAT(j-2,:),RAT(j+1,:),&
                             & RAT(j+2,:),RAT(j+3,:))

               j = j + 3

               Call FourCoord (RAT(j,:),RAT(j-3,:),RAT(j+1,:),&
                             & RAT(j+2,:),RAT(j+6,:))

               j = j + 2

               Call FourCoord (RAT(j,:),RAT(j-2,:),RAT(j+1,:),&
                             & RAT(j+2,:),RAT(j+3,:))

               j = j + 4

               Call FourCoord (RAT(j,:),RAT(j-6,:),RAT(j+1,:),&
                             & RAT(j+2,:),RAT(j+3,:))

            EndIf

            !Lysine - LYS!

            If (RESN(i) .EQ. 'LYS')Then

               Call FourCoord (RAT(j,:),RAT(j-2,:),RAT(j+1,:),&
                             & RAT(j+2,:),RAT(j+3,:))

               j = j + 3

               Do k=1,4

               Call FourCoord (RAT(j,:),RAT(j-3,:),RAT(j+1,:),&
                             & RAT(j+2,:),RAT(j+3,:))

               j = j + 3

               EndDo

            EndIf

            !Methionine - MET!

            If (RESN(i) .EQ. 'MET')Then

               Call FourCoord (RAT(j,:),RAT(j-2,:),RAT(j+1,:),&
                             & RAT(j+2,:),RAT(j+3,:))

               j = j + 3

               Call FourCoord (RAT(j,:),RAT(j-3,:),RAT(j+1,:),&
                             & RAT(j+2,:),RAT(j+3,:))

               j = j + 4

               Call FourCoord (RAT(j,:),RAT(j-1,:),RAT(j+1,:),&
                             & RAT(j+2,:),RAT(j+3,:))

            EndIf

            !Phenalyanine - PHE!

            If (RESN(i) .EQ. 'PHE')Then

               Call FourCoord (RAT(j,:),RAT(j-2,:),RAT(j+1,:),&
                             & RAT(j+2,:),RAT(j+3,:))

               j = j + 4

               Call ThreeCoord (RAT(j,:),RAT(j-1,:),&
                              & RAT(j+1,:),RAT(j+2,:))

               j = j + 2
 
               Do k=1,3

               Call ThreeCoord (RAT(j,:),RAT(j-2,:),&
                              & RAT(j+1,:),RAT(j+2,:))

               j = j + 2

               EndDo

               Call ThreeCoord (RAT(j,:),RAT(j-2,:),&
                              & RAT(j+1,:),RAT(j-9,:))

            EndIf

            !Proline!

            If (RESN(i) .EQ. 'PRO')Then

               Call FourCoord (RAT(j,:),RAT(j-2,:),RAT(j+1,:),&
                             & RAT(j+2,:),RAT(j+3,:))

               j = j + 3

               Call FourCoord (RAT(j,:),RAT(j-3,:),RAT(j+1,:),&
                             & RAT(j+2,:),RAT(j+3,:))

               j = j + 3

               Call FourCoord (RAT(j,:),RAT(j-3,:),RAT(j+1,:),&
                             & RAT(j+2,:),RAT(jS,:))

            EndIf

            !Serine - SER!

            If (RESN(i) .EQ. 'SER')Then

               Call FourCoord (RAT(j,:),RAT(j-2,:),RAT(j+1,:),&
                             & RAT(j+2,:),RAT(j+3,:))

               j = j + 3

               Call TwoCoord (RAT(j,:),RAT(j-3,:),RAT(j+1,:))

            EndIf

            !Threonine - THR!

            If (RESN(i) .EQ. 'THR')Then

               Call FourCoord (RAT(j,:),RAT(j-2,:),RAT(j+1,:),&
                             & RAT(j+2,:),RAT(j+4,:))

               j = j + 2

               Call TwoCoord (RAT(j,:),RAT(j-2,:),RAT(j+1,:))

               j = j + 2

               Call FourCoord (RAT(j,:),RAT(j-4,:),RAT(j+1,:),&
                             & RAT(j+2,:),RAT(j+3,:))

            EndIf

            !Tyrosine - TYR!

            If (RESN(i) .EQ. 'TYR')Then

               Call FourCoord (RAT(j,:),RAT(j-2,:),RAT(j+1,:),&
                             & RAT(j+2,:),RAT(j+3,:))

               j = j + 4

               Call ThreeCoord (RAT(j,:),RAT(j-1,:),&
                              & RAT(j+1,:),RAT(j+2,:))

               j = j + 2

               Call ThreeCoord (RAT(j,:),RAT(j-2,:),&
                              & RAT(j+1,:),RAT(j+2,:))

               j = j + 3

               Call TwoCoord (RAT(j,:),RAT(j-1,:),RAT(j+1,:))

               j = j + 2

               Call ThreeCoord (RAT(j,:),RAT(j-3,:),&
                              & RAT(j+1,:),RAT(j+2,:))

               j = j + 2

               Call ThreeCoord (RAT(j,:),RAT(j-2,:),&
                              & RAT(j+1,:),RAT(j-10,:))

            EndIf

            !Tryptophan - TRP!

            If (RESN(i) .EQ. 'TRP')Then

               Call FourCoord (RAT(j,:),RAT(j-2,:),RAT(j+1,:),&
                             & RAT(j+2,:),RAT(j+3,:))

               j = j + 4

               Call ThreeCoord (RAT(j,:),RAT(j-1,:),&
                              & RAT(j+1,:),RAT(j+2,:))

               j = j + 2

               Call ThreeCoord (RAT(j,:),RAT(j-2,:),&
                              & RAT(j+1,:),RAT(j+2,:))

               j = j + 3

               Call ThreeCoord (RAT(j,:),RAT(j-1,:),&
                              & RAT(j+1,:),RAT(j+2,:))

               j = j + 2

               Do k=1,2

               Call ThreeCoord (RAT(j,:),RAT(j-2,:),&
                              & RAT(j+1,:),RAT(j+2,:))

               j = j + 2

               EndDo

               Call ThreeCoord (RAT(j,:),RAT(j-2,:),&
                              & RAT(j+1,:),RAT(j+2,:))

            EndIf

            !Valine - VAL!

            If (RESN(i) .EQ. 'VAL')Then

               Call FourCoord (RAT(j,:),RAT(j-2,:),RAT(j+1,:),&
                             & RAT(j+2,:),RAT(j+6,:))

               j = j + 2

               Call FourCoord (RAT(j,:),RAT(j-2,:),RAT(j+1,:),&
                             & RAT(j+2,:),RAT(j+3,:))

               j = j + 4

               Call FourCoord (RAT(j,:),RAT(j-6,:),RAT(j+1,:),&
                             & RAT(j+2,:),RAT(j+3,:))

            EndIf
 
            If (i .EQ. NRES)Then
 
               j = jS + 2
               If (RESN(i) .EQ. 'PRO')j = jS + 1
 
               Call ThreeCoord (RAT(jE-2,:),RAT(j,:),&
                              & RAT(jE-1,:),RAT(jE,:))
 
            ElseIf (IRES(i+1) .LT. 0)Then

               j = jS + 2
               If (RESN(i) .EQ. 'PRO')j = jS + 1

               Call ThreeCoord (RAT(jE-2,:),RAT(j,:),&
                              & RAT(jE-1,:),RAT(jE,:))

            EndIf
 
         EndDo

         Return

      End Subroutine
