! Subroutine: AdjustPH
! Purpose: Adjusts the protonation of acidic and basic residues
!          for a given PH. Also allows the user to specifiy specific
!          residue numbers to protonate or deprotonate.
! Written: September 4th 2007
! Last Update: September 4th 2007
! Author: Eric Dykeman

! NOTES: VARIABLES
!        SystemParam - Global variables
!
!        DEPENDANCIES
!        TwoCoord ThreeCoord
!

! **********************************************************************

      Subroutine AdjustPH

         Use SystemParam, Only : RAT,ITYPE,IRES,RESN,NAT,NRES

         Implicit None

      !Variable Declaration!

      !Local Variables!

         Double Precision, Dimension(:,:), Allocatable :: RNEW
         Integer, Dimension(:), Allocatable :: ITNEW,IRNEW

         Double Precision PH
         Integer i,j,k,jS,jE,iATM,NH,iCHOICE,iCHG
         Character RNAME*3,RESNEW*3

         Dimension RESNEW(NRES)

      !ROUTINE!

         !Copy residue names into temporary working array!

         Do i=1,NRES
         RESNEW(i) = RESN(i)
         EndDo

         !TWO CHOICES FOR PH ADJUSTMENT!

         !Choice 1 - User enters Defualt PH!
         !Choice 2 - User enters Specific residue number to alter!

         !ADJUST UNIVERSAL PH!

         Write(*,*)'WOULD YOU LIKE TO CHANGE THE "UNIVERSAL" PH'
         Write(*,*)'YES --> ENTER 1'
         Write(*,*)'NO  --> ENTER 0'
         Read(*,*)iCHOICE
         Write(*,*)' '

         If (iCHOICE .EQ. 1)Then

            Write(*,*)'PLEASE ENTER PH (0-14)'
            Read(*,*)PH
            Write(*,*)' '

            If (PH .LE. 5.0d0)Then

               Write(*,*)'ADDING A PROTON TO THE FOLOWING'
               Write(*,*)'HIS  ASP  GLU'
               Write(*,*)' '

               Do i=1,NRES
               If (RESN(i) .EQ. 'HID')RESNEW(i) = 'HIP'
               If (i < NRES)Then
               If (IRES(i) > 0 .and. IRES(i+1) > 0)Then
               If (RESN(i) .EQ. 'ASP')RESNEW(i) = 'ASH'
               If (RESN(i) .EQ. 'GLU')RESNEW(i) = 'GLH'
               EndIf
               EndIf
               EndDo

            ElseIf (PH .GE. 11.0d0)Then

               Write(*,*)'REMOVING A PROTON FROM THE FOLOWING'
               Write(*,*)'CYS  LYS'
               Write(*,*)' '

               Do i=1,NRES
               If (i < NRES)Then
               If (IRES(i) > 0 .and. IRES(i+1) > 0)Then
               If (RESN(i) .EQ. 'LYS')RESNEW(i) = 'LYN'
               If (RESN(i) .EQ. 'CYS')RESNEW(i) = 'CYM'
               EndIf
               EndIf
               EndDo

            ElseIf (PH .GE. 9.0d0)Then

               Write(*,*)'REMOVING A PROTON FROM CYS'
               Write(*,*)' '

               Do i=1,NRES
               If (i < NRES)Then
               If (IRES(i) > 0 .and. IRES(i+1) > 0)Then
               If (RESN(i) .EQ. 'CYS')RESNEW(i) = 'CYM'
               EndIf
               EndIf
               EndDo

            Else

               Write(*,*)'NO ADJUSTMENTS NEEDED AT THIS PH'

            EndIf

         EndIf

         !ADJUST SPECIFIC RESIDUE!

         Write(*,*)'YOU MAY ALSO CHANGE THE PROTONATION OF AN'
         Write(*,*)'INDIVIDUAL AMINO ACID. WOULD YOU LIKE TO DO THIS?'
         Write(*,*)'YES --> ENTER 1'
         Write(*,*)'NO  --> ENTER 0'
         Read(*,*)iCHOICE
         Write(*,*)' '

         !ADJUST PH MENU LOOP!

         Do While (iCHOICE .NE. 0)

         Write(*,*)'----------- ADJUST AMINO MAIN MENU ----------------'
         Write(*,*)' '
         Write(*,*)'CHOOSE AN AMINO ACID TO CHANGE'
         Write(*,*)'ASP -- (ACIDIC)  ENTER 1'
         Write(*,*)'GLU -- (ACIDIC)  ENTER 2'
         Write(*,*)'HIS -- (ACIDIC)  ENTER 3'
         Write(*,*)'LYS -- (BASIC)   ENTER 4'
         Write(*,*)'CYS -- (BASIC)   ENTER 5'
         Write(*,*)' '
         Write(*,*)'ENTER ZERO (0) TO QUIT ADJUST AMINO'
         Read(*,*)iCHOICE
         Write(*,*)' '

         Select Case (iCHOICE)
            Case (0)
            Write(*,*)'RETURNING TO PEPALYZE -- GOODBYE'
            Write(*,*)' '
            Case (1)
            RNAME = 'ASP'
            Case (2)
            RNAME = 'GLU'
            Case (3)
            RNAME = 'HID'
            Case (4)
            RNAME = 'LYS'
            Case (5)
            RNAME = 'CYS'
            Case Default
            Write(*,*)iCHOICE,' IS AN INVALID CHOICE'
         End Select

         !Find these amino acids and display them!

         If (iCHOICE .NE. 0)Then

            Do i=1,NRES

               If (RNAME .EQ. RESN(i))Then
               Write(*,*)RESNEW(i),i
               EndIf

            EndDo

            Write(*,*)'ENTER RESIDUE NUMBER'
            Read(*,*)j

            i = 0
            If (RNAME .NE. 'HID')Then

               i = 1
               If (j .LT. NRES)Then
               If (IRES(j) > 0 .AND. IRES(j+1) > 0)i = 0
               EndIf

            EndIf

            If (i .EQ. 1)Then
            Write(*,*)'CAN ONLY CHANGE PROTONATION OF NT OR CT HIS'
            RNAME = 'UNK'
            EndIf

            If (RNAME .EQ. 'ASP')Then

               If (RESNEW(j) .EQ. 'ASP')Then
               Write(*,*)'RESIDUE # ',j,' IS ASPARTIC ACID (COO-)'
               EndIf

               If (RESNEW(j) .EQ. 'ASH')Then
               Write(*,*)'RESIDUE # ',j,' IS ASPARTIC ACID (COOH)'
               EndIf

               Write(*,*)'CHANGE TO ASP (COO-)   -- ENTER 1'
               Write(*,*)'CHANGE TO ASH (COOH)   -- ENTER 2'
               Read(*,*)iCHG
               Write(*,*)' '

               If (iCHG .EQ. 1)RESNEW(j) = 'ASP'
               If (iCHG .EQ. 2)RESNEW(j) = 'ASH'

            EndIf

            If (RNAME .EQ. 'GLU')Then

               If (RESNEW(j) .EQ. 'GLU')Then
               Write(*,*)'RESIDUE # ',j,' IS GLUTAMIC ACID (COO-)'
               EndIf

               If (RESNEW(j) .EQ. 'GLH')Then
               Write(*,*)'RESIDUE # ',j,' IS GLUTAMIC ACID (COOH)'
               EndIf

               Write(*,*)'CHANGE TO GLU (COO-)   -- ENTER 1'
               Write(*,*)'CHANGE TO GLH (COOH)   -- ENTER 2'
               Read(*,*)iCHG
               Write(*,*)' '

               If (iCHG .EQ. 1)RESNEW(j) = 'GLU'
               If (iCHG .EQ. 2)RESNEW(j) = 'GLH'

            EndIf

            If (RNAME .EQ. 'HID')Then

               If (RESNEW(j) .EQ. 'HID')Then
               Write(*,*)'RESIDUE # ',j,' IS HISTIDINE (DELTA)'
               EndIf

               If (RESNEW(j) .EQ. 'HIE')Then
               Write(*,*)'RESIDUE # ',j,' IS HISTIDINE (EPSILON)'
               EndIf

               If (RESNEW(j) .EQ. 'HIP')Then
               Write(*,*)'RESIDUE # ',j,' IS HISTIDINE (PLUS +)'
               EndIf

               Write(*,*)'CHANGE TO HID (DELTA)   -- ENTER 1'
               Write(*,*)'CHANGE TO HIE (EPSILON) -- ENTER 2'
               Write(*,*)'CHANGE TO HIP (PLUS + ) -- ENTER 3'
               Read(*,*)iCHG
               Write(*,*)' '

               If (iCHG .EQ. 1)RESNEW(j) = 'HID'
               If (iCHG .EQ. 2)RESNEW(j) = 'HIE'
               If (iCHG .EQ. 3)RESNEW(j) = 'HIP'

            EndIf

            If (RNAME .EQ. 'LYS')Then

               If (RESNEW(j) .EQ. 'LYS')Then
               Write(*,*)'RESIDUE # ',j,' IS LYSINE (NH3+)'
               EndIf

               If (RESNEW(j) .EQ. 'LYN')Then
               Write(*,*)'RESIDUE # ',j,' IS LYSINE (NH2)'
               EndIf

               Write(*,*)'CHANGE TO LYS (NH3+)   -- ENTER 1'
               Write(*,*)'CHANGE TO LYN (NH2)    -- ENTER 2'
               Read(*,*)iCHG
               Write(*,*)' '

               If (iCHG .EQ. 1)RESNEW(j) = 'LYS'
               If (iCHG .EQ. 2)RESNEW(j) = 'LYN'

            EndIf

            If (RNAME .EQ. 'CYS')Then

               If (RESNEW(j) .EQ. 'CYS')Then
               Write(*,*)'RESIDUE # ',j,' IS CYSTINE (SH)'
               EndIf

               If (RESNEW(j) .EQ. 'CYM')Then
               Write(*,*)'RESIDUE # ',j,' IS CYSTINE (S-)'
               EndIf

               Write(*,*)'CHANGE TO CYS (SH)    -- ENTER 1'
               Write(*,*)'CHANGE TO CYM (S-)    -- ENTER 2'
               Read(*,*)iCHG
               Write(*,*)' '

               If (iCHG .EQ. 1)RESNEW(j) = 'CYS'
               If (iCHG .EQ. 2)RESNEW(j) = 'CYM'

            EndIf

         EndIf

         EndDo

         !END ADJUST PH MENU LOOP!

         !Copy over changes!

         Do i=1,NRES
         RESN(i) = RESNEW(i)
         EndDo

         !Now fix selected aminos!

         NH = 0

         Do i=1,NRES

            If (RESN(i) .EQ. 'ASH')NH = NH + 1
            If (RESN(i) .EQ. 'GLH')NH = NH + 1
            If (RESN(i) .EQ. 'HIP')NH = NH + 1
            If (RESN(i) .EQ. 'LYN')NH = NH - 1
            If (RESN(i) .EQ. 'CYM')NH = NH - 1

         EndDo

         Allocate (RNEW(NAT+NH,3),ITNEW(NAT+NH))
         Allocate (IRNEW(NRES))

         iATM = 0

         Do i=1,NRES

            !First Get NEW IRES assignemnt!

            IRNEW(i) = iATM + 1
            If (IRES(i) .LT. 0)IRNEW(i) = -IRNEW(i)

            !Now copy over amino acid!

            jS = Iabs(IRES(i))

            If (i .LT. NRES)Then
            jE = Iabs(IRES(i+1)) - 1
            Else
            jE = NAT
            EndIf

            If (RESN(i) .EQ. 'ASH')Then

               Do j=jS,jE-2

                  iATM = iATM + 1
                  ITNEW(iATM) = ITYPE(j)

                  Do k=1,3
                  RNEW(iATM,k) = RAT(j,k)
                  EndDo

               EndDo

               iATM = iATM + 1
               ITNEW(iATM) = 1

               Do k=1,3
               RNEW(iATM,k) = 0.0d0
               EndDo

               Call TwoCoord(RNEW(iATM-1,:),RNEW(iATM-3,:),RNEW(iATM,:))

               jS = jE - 1

            EndIf

            If (RESN(i) .EQ. 'GLH')Then

               Do j=jS,jE-2

                  iATM = iATM + 1
                  ITNEW(iATM) = ITYPE(j)

                  Do k=1,3
                  RNEW(iATM,k) = RAT(j,k)
                  EndDo

               EndDo

               iATM = iATM + 1
               ITNEW(iATM) = 1

               Do k=1,3
               RNEW(iATM,k) = 0.0d0
               EndDo

               Call TwoCoord(RNEW(iATM-1,:),RNEW(iATM-3,:),RNEW(iATM,:))

               jS = jE - 1

            EndIf

            If (RESN(i) .EQ. 'HIE')Then

               Do j=jS,jE-4
               If (j .NE. jE-7)Then

                  iATM = iATM + 1
                  ITNEW(iATM) = ITYPE(j)

                  Do k=1,3
                  RNEW(iATM,k) = RAT(j,k)
                  EndDo

               EndIf
               EndDo

               iATM = iATM + 1
               ITNEW(iATM) = 1

               Do k=1,3
               RNEW(iATM,k) = 0.0d0
               EndDo

               Call ThreeCoord (RNEW(iATM-1,:),RNEW(iATM-3,:),&
                              & RAT(jE-3,:),RNEW(iATM,:))

               jS = jE - 3

            EndIf

            If (RESN(i) .EQ. 'HIP')Then

               Do j=jS,jE-4

                  iATM = iATM + 1
                  ITNEW(iATM) = ITYPE(j)

                  Do k=1,3
                  RNEW(iATM,k) = RAT(j,k)
                  EndDo

               EndDo

               iATM = iATM + 1
               ITNEW(iATM) = 1

               Do k=1,3
               RNEW(iATM,k) = 0.0d0
               EndDo

               Call ThreeCoord (RNEW(iATM-1,:),RNEW(iATM-3,:),&
                              & RAT(jE-3,:),RNEW(iATM,:))

               jS = jE - 3

            EndIf

            If (RESN(i) .EQ. 'LYN' .OR. RESN(i) .EQ. 'CYM')Then

               Do j=jS,jE-3

                  iATM = iATM + 1
                  ITNEW(iATM) = ITYPE(j)

                  Do k=1,3
                  RNEW(iATM,k) = RAT(j,k)
                  EndDo

               EndDo

               jS = jE - 1

            EndIf

            !Finish copying over rest of atoms!
            !OR copy over entire amino acid if!
            !It is unchanged!

            Do j=jS,jE

               iATM = iATM + 1
               ITNEW(iATM) = ITYPE(j)

               Do k=1,3
               RNEW(iATM,k) = RAT(j,k)
               EndDo

            EndDo

         EndDo

         !Copy RNEW over to RAT!

         Deallocate (RAT,ITYPE)

         NAT = NAT + NH

         Allocate (RAT(NAT,3),ITYPE(NAT))

         Do i=1,NAT
         ITYPE(i) = ITNEW(i)
         Do j=1,3
         RAT(i,j) = RNEW(i,j)
         EndDo
         EndDo

         !Copy IRNEW over to IRES!

         Do i=1,NRES
         IRES(i) = IRNEW(i)
         EndDo

         Deallocate (RNEW,ITNEW,IRNEW)

         Return

      End Subroutine
