! Subroutine: AssignTC
! Purpose: Assigns types and charges for peptides following the 
!          Amino acid naming scheme. The peptides are in AMBER order
!          i.e. the same order that appears in AMBER all_amino.dat
!          There is one exception PRO
! Written: March 15th 2007
! Last Update: March 15th 2007
! Author: Eric Dykeman

! NOTES: VARIABLES
!        SystemParam - Global system parameters
!

! **********************************************************************

      Subroutine AssignTC

         Use SystemParam, Only : Q,ATMT,NAT,RESN,IRES,NRES

         Implicit None

      !Variable Declaration!

      !Local Variables!

         Double Precision QTMP
         Integer i,j,k,kS,kE,NARES,MAXR,MAXAT,iLOOP
         Character*72 NA,CA,AA,FNAME,STR1,STR2
         Character*3 RTMP
         Character*2 ATMP
         Logical OK

         Parameter (MAXR = 40)
         Parameter (MAXAT = 30)

         Dimension QTMP(MAXR,MAXAT),ATMP(MAXR,MAXAT),RTMP(MAXR)

      !ROUTINE!

         !File Locations!

         Write(*,*)'ENTERING Saguaro3.3/sdat/ FOR AMINO CHARGES'

         NA = '/home/eric/Saguaro3.3/sdat/namino94.dat'
         CA = '/home/eric/Saguaro3.3/sdat/camino94.dat'
         AA = '/home/eric/Saguaro3.3/sdat/amino94.dat'

         FNAME = NA
         iLOOP = 1

         !Apply N-Terminal Amino Info!

 20      Open (Unit=10,File=FNAME,Status='Unknown')

         Read(10,*)i
         Read(10,*)STR1

         NARES = 1

         Read(10,*)STR1

         Do While (STR1 .NE. 'STOP')

            Read(10,11)RTMP(NARES)

            Do i=1,5
            Read(10,*)STR1
            EndDo

            Do i=1,MAXAT

               Read(10,*)STR1

               If (STR1 .NE. 'IMPROPER')Then

                  BackSpace(Unit = 10)
                  Read(10,12)STR1,STR2

                  Write(ATMP(NARES,i),13)STR1(13:14)
                  Read(STR2,*)QTMP(NARES,i)

               Else

                  Do While (STR1 .NE. 'DONE')
                  Read(10,*)STR1
                  EndDo

                  Goto 30

               EndIf

            EndDo

 30         NARES = NARES + 1

            Read(10,*)STR1

         EndDo

         NARES = NARES - 1

         Close (Unit = 10)

         Do i=1,NRES

            Select Case (iLOOP)
               Case(1)

                  OK = IRES(i) .LT. 0
                  If (RESN(i) .EQ. 'ACE')OK = .FALSE.

               Case(2)

                  If (i .LT. NRES)OK = IRES(i+1) .LT. 0
                  If (i .EQ. NRES)OK = .TRUE.
                  If (RESN(i) .EQ. 'NME')OK = .FALSE.

               Case(3)

                  If (i .LT. NRES)Then
                  OK = (IRES(i) .GT. 0 .AND. IRES(i+1) .GT. 0)
                  Else
                  OK = .FALSE.
                  EndIf

                  If (RESN(i) .EQ. 'ACE')OK = .TRUE.
                  If (RESN(i) .EQ. 'NME')OK = .TRUE.

               Case Default
                  OK = .FALSE.
            End Select

            If (OK)Then

               Do j=1,NARES
               If (RESN(i) .EQ. RTMP(j))Then

                  kS = Iabs(IRES(i))

                  If (i .NE. NRES)Then
                  kE = Iabs(IRES(i+1)) - 1
                  Else
                  kE = NAT
                  EndIf

                  Do k=kS,kE
                  Q(k) = QTMP(j,k-kS+1)
                  ATMT(k) = ATMP(j,k-kS+1)
                  EndDo

               EndIf
               EndDo

            EndIf

         EndDo

         If (iLOOP .EQ. 1)Then
         iLOOP = iLOOP + 1
         FNAME = CA
         Goto 20
         EndIf

         If (iLOOP .EQ. 2)Then
         iLOOP = iLOOP + 1
         FNAME = AA
         Goto 20
         EndIf

 11      Format(1X,A3) 
 12      Format(A62,A10)
 13      Format(A2)

         Return

      End Subroutine
