! Subroutine: FourCoord
! Purpose: Checks to make sure that a set of atoms are Four Coordinated
! Written: April 24th 2006
! Last Update: April 24th 2006
! Author: Eric Dykeman

! NOTES: VARIABLES
!            RC - (3) Center Atom Coordinates
!            R1 - (3) 1st attached atom
!            R2 - (3) 2nd attached atom
!            R3 - (3) 3rd attached atom
!            R4 - (3) 4th attached atom
!
!        DEPENDANCIES
!

! **********************************************************************

      Subroutine FourCoord (RC,R1,R2,R3,R4)

         Implicit None

      !Variable Declaration!

         Double Precision, Intent (InOut) :: RC,R1,R2,R3,R4

         Dimension RC(3),R1(3),R2(3),R3(3),R4(3)

      !Local Variables!

         Double Precision A,B,X,R12,R13,R14,VEC
         Double Precision RBOND,THETA
         Integer i,N,LIST

         Dimension R12(3),R13(3),R14(3),VEC(3),LIST(4)

      !ROUTINE!

         RBOND = 1.0d0      !Default H-? Bond Distance!
         THETA = 1.9111d0   !Default Angle in Radians!

         !First Find Troubled Atoms ... Located at (0,0,0)!

         Do i=1,4
         LIST(i) = 0
         EndDo

         If (R1(1) .EQ. 0.0d0 .AND. R1(2) .EQ. 0.0d0 &
           & .AND. R1(3) .EQ. 0.0d0)LIST(1) = 1

         If (R2(1) .EQ. 0.0d0 .AND. R2(2) .EQ. 0.0d0 &
           & .AND. R2(3) .EQ. 0.0d0)LIST(2) = 1

         If (R3(1) .EQ. 0.0d0 .AND. R3(2) .EQ. 0.0d0 &
           & .AND. R3(3) .EQ. 0.0d0)LIST(3) = 1

         If (R4(1) .EQ. 0.0d0 .AND. R4(2) .EQ. 0.0d0 &
           & .AND. R4(3) .EQ. 0.0d0)LIST(4) = 1

         !How Many Bad Atoms (Should Be Either 1 2 or 3)!

         N = 0

         Do i=1,4
         N = N + LIST(i)
         EndDo

         !Very RARE Possabilty!

         If (N .EQ. 4)Then
         LIST(1) = 0
         N = 3
         EndIf

 10      Continue

         If (N .EQ. 1)Then

            If (LIST(1) .EQ. 1)Then

               Do i=1,3
               R12(i) = RC(i) - R2(i)
               R13(i) = RC(i) - R3(i)
               R14(i) = RC(i) - R4(i)
               EndDo

            EndIf

            If (LIST(2) .EQ. 1)Then

               Do i=1,3
               R12(i) = RC(i) - R1(i)
               R13(i) = RC(i) - R3(i)
               R14(i) = RC(i) - R4(i)
               EndDo

            EndIf

            If (LIST(3) .EQ. 1)Then

               Do i=1,3
               R12(i) = RC(i) - R1(i)
               R13(i) = RC(i) - R2(i)
               R14(i) = RC(i) - R4(i)
               EndDo

            EndIf

            If (LIST(4) .EQ. 1)Then

               Do i=1,3
               R12(i) = RC(i) - R1(i)
               R13(i) = RC(i) - R2(i)
               R14(i) = RC(i) - R3(i)
               EndDo

            EndIf

            !Normalize Vectors!

            X = R12(1)**2 + R12(2)**2 + R12(3)**2
            X = 1.0d0/Dsqrt(X)

            Do i=1,3
            R12(i) = R12(i)*X
            EndDo

            X = R13(1)**2 + R13(2)**2 + R13(3)**2
            X = 1.0d0/Dsqrt(X)

            Do i=1,3
            R13(i) = R13(i)*X
            EndDo

            X = R14(1)**2 + R14(2)**2 + R14(3)**2
            X = 1.0d0/Dsqrt(X)

            Do i=1,3
            R14(i) = R14(i)*X
            EndDo

            !Get new Direction Vector!

            Do i=1,3
            VEC(i) = R12(i) + R13(i) + R14(i)
            EndDo

            X = 0.0d0
            Do i=1,3
            X = X + VEC(i)*VEC(i)
            EndDo
            X = RBOND/Dsqrt(X)

            Do i=1,3
            VEC(i) = VEC(i)*X
            EndDo

            If (LIST(1) .EQ. 1)Then

               Do i=1,3
               R1(i) = RC(i) + VEC(i)
               EndDo

            EndIf

            If (LIST(2) .EQ. 1)Then

               Do i=1,3
               R2(i) = RC(i) + VEC(i)
               EndDo

            EndIf

            If (LIST(3) .EQ. 1)Then

               Do i=1,3
               R3(i) = RC(i) + VEC(i)
               EndDo

            EndIf

            If (LIST(4) .EQ. 1)Then

               Do i=1,3
               R4(i) = RC(i) + VEC(i)
               EndDo

            EndIf

         ElseIf (N .EQ. 2)Then

            If (LIST(1) .EQ. 0)Then

               Do i=1,3
               R12(i) = RC(i) - R1(i)
               EndDo

               If (LIST(2) .EQ. 0)Then

                  Do i=1,3
                  R13(i) = RC(i) - R2(i)
                  EndDo

               EndIf

               If (LIST(3) .EQ. 0)Then

                  Do i=1,3
                  R13(i) = RC(i) - R3(i)
                  EndDo

               EndIf

               If (LIST(4) .EQ. 0)Then

                  Do i=1,3
                  R13(i) = RC(i) - R4(i)
                  EndDo

               EndIf

            ElseIf (LIST(2) .EQ. 0)Then

               Do i=1,3
               R12(i) = RC(i) - R2(i)
               EndDo

               If (LIST(3) .EQ. 0)Then

                  Do i=1,3
                  R13(i) = RC(i) - R3(i)
                  EndDo

               EndIf

               If (LIST(4) .EQ. 0)Then

                  Do i=1,3
                  R13(i) = RC(i) - R4(i)
                  EndDo

               EndIf

            Else

               Do i=1,3
               R12(i) = RC(i) - R3(i)
               R13(i) = RC(i) - R4(i)
               EndDo

            EndIf

            !Get Vector Perpendicular!

            VEC(1) = R12(2)*R13(3) - R12(3)*R13(2)
            VEC(2) = R12(3)*R13(1) - R12(1)*R13(3)
            VEC(3) = R12(1)*R13(2) - R12(2)*R13(1)

            X = 0.0d0
            Do i=1,3
            X = X + VEC(i)*VEC(i)
            EndDo
            X = 1.0d0/Dsqrt(X)

            Do i=1,3
            VEC(i) = VEC(i)*X
            EndDo

            !Now Get Other Perpendicular Piece!

            X = R12(1)**2 + R12(2)**2 + R12(3)**2
            X = 1.0d0/Dsqrt(X)

            Do i=1,3
            R12(i) = R12(i)*X
            EndDo

            X = R13(1)**2 + R13(2)**2 + R13(3)**2
            X = 1.0d0/Dsqrt(X)

            Do i=1,3
            R13(i) = R13(i)*X
            EndDo

            Do i=1,3
            R14(i) = R12(i) + R13(i)
            EndDo

            !Make Sure its Perpendicular to VEC!

            X = 0.0d0
            Do i=1,3
            X = X + VEC(i)*R14(i)
            EndDo

            Do i=1,3
            R14(i) = R14(i) - X*VEC(i)
            EndDo

            !Normalize!

            X = 0.0d0
            Do i=1,3
            X = X + R14(i)**2
            EndDo
            X = 1.0d0/Dsqrt(X)

            Do i=1,3
            R14(i) = R14(i)*X
            EndDo

            A = RBOND*DCos(0.5d0*THETA)
            B = RBOND*DSin(0.5d0*THETA)
            X = 1.0d0

            If (LIST(1) .EQ. 1)Then

               Do i=1,3
               R1(i) = RC(i) + A*R14(i) + B*VEC(i)
               EndDo

               X = -1.0d0

            EndIf

            If (LIST(2) .EQ. 1)Then

               Do i=1,3
               R2(i) = RC(i) + A*R14(i) + X*B*VEC(i)
               EndDo

               X = -1.0d0

            EndIf

            If (LIST(3) .EQ. 1)Then

               Do i=1,3
               R3(i) = RC(i) + A*R14(i) + X*B*VEC(i)
               EndDo

               X = -1.0d0

            EndIf

            If (LIST(4) .EQ. 1)Then

               Do i=1,3
               R4(i) = RC(i) + A*R14(i) + X*B*VEC(i)
               EndDo

            EndIf

         ElseIf (N .EQ. 3)Then

            !Fix One Atom Then go to N = 2 Case!

            If (LIST(1) .EQ. 0)Then

               Do i=1,3
               R12(i) = RC(i) - R1(i)
               EndDo

            EndIf

            If (LIST(2) .EQ. 0)Then

               Do i=1,3
               R12(i) = RC(i) - R2(i)
               EndDo

            EndIf

            If (LIST(3) .EQ. 0)Then

               Do i=1,3
               R12(i) = RC(i) - R3(i)
               EndDo

            EndIf

            If (LIST(4) .EQ. 0)Then

               Do i=1,3
               R12(i) = RC(i) - R4(i)
               EndDo

            EndIf

            X = R12(1)**2 + R12(2)**2 + R12(3)**2
            X = 1.0d0/Dsqrt(X)

            Do i=1,3
            R12(i) = R12(i)*X
            EndDo

            !Find A perpendicular vector to R12!

            Do i=1,3
            VEC(i) = 0.0d0
            EndDo

            If (R12(1) .NE. 0.0d0)Then

               VEC(3) = 1.0d0

            ElseIf (R12(2) .NE. 0.0d0)Then

               VEC(3) = 1.0d0

            Else

               VEC(2) = 1.0d0

            EndIf

            !Remove any component along R12 and Normalize!

            X = 0.0d0
            Do i=1,3
            X = X + VEC(i)*R12(i)
            EndDo

            Do i=1,3
            VEC(i) = VEC(i) - X*R12(i)
            EndDo

            X = 0.0d0
            Do i=1,3
            X = X + VEC(i)*VEC(i)
            EndDo
            X = 1.0d0/Dsqrt(X)

            Do i=1,3
            VEC(i) = VEC(i)*X
            EndDo

            B = -RBOND*DCos(THETA)
            A = RBOND**2 - B*B
            A = Dsqrt(A)

            If (LIST(1) .EQ. 1)Then

               Do i=1,3
               R1(i) = RC(i) + A*VEC(i) + B*R12(i)
               EndDo

               LIST(1) = 0

            Else

               Do i=1,3
               R2(i) = RC(i) + A*VEC(i) + B*R12(i)
               EndDo

               LIST(2) = 0

            EndIf

            N = 2
            Goto 10

         EndIf

         Return

      End Subroutine
