! Subroutine: GetType
! Purpose: Converts atom names to numerical numbers
! Written: April 26th 2006
! Last Update: January 7th 2009
! Author: Eric Dykeman

! NOTES: VARIABLES
!          ANAME - Atom Name
!          ITYPE - Numerical Atom types
!
!        DEPENDANCIES
!

! **********************************************************************

      Subroutine GetType (ANAME,ITYPE)

         Implicit None

      !Variable Declaration!

         Character*2, Intent(In) :: ANAME
         Integer, Intent(Out) :: ITYPE

      !Local Variables!

         Integer IZ

      !ROUTINE!

         iZ = 0

         If (ANAME .EQ. 'h')IZ = 1
         If (ANAME .EQ. 'H')IZ = 1

         If (ANAME .EQ. 'li')IZ = 3
         If (ANAME .EQ. 'Li')IZ = 3
         If (ANAME .EQ. 'lI')IZ = 3
         If (ANAME .EQ. 'LI')IZ = 3

         If (ANAME .EQ. 'c')IZ = 6
         If (ANAME .EQ. 'C')IZ = 6

         If (ANAME .EQ. 'n')IZ = 7
         If (ANAME .EQ. 'N')IZ = 7

         If (ANAME .EQ. 'o')IZ = 8
         If (ANAME .EQ. 'O')IZ = 8

         If (ANAME .EQ. 'f')IZ = 9
         If (ANAME .EQ. 'F')IZ = 9

         If (ANAME .EQ. 'na')IZ = 11
         If (ANAME .EQ. 'Na')IZ = 11
         If (ANAME .EQ. 'nA')IZ = 11
         If (ANAME .EQ. 'NA')IZ = 11

         If (ANAME .EQ. 'mg')IZ = 12
         If (ANAME .EQ. 'Mg')IZ = 12
         If (ANAME .EQ. 'mG')IZ = 12
         If (ANAME .EQ. 'MG')IZ = 12

         If (ANAME .EQ. 'al')IZ = 13
         If (ANAME .EQ. 'Al')IZ = 13
         If (ANAME .EQ. 'aL')IZ = 13
         If (ANAME .EQ. 'AL')IZ = 13

         If (ANAME .EQ. 'si')IZ = 14
         If (ANAME .EQ. 'Si')IZ = 14
         If (ANAME .EQ. 'sI')IZ = 14
         If (ANAME .EQ. 'SI')IZ = 14

         If (ANAME .EQ. 'p')IZ = 15
         If (ANAME .EQ. 'P')IZ = 15

         If (ANAME .EQ. 's')IZ = 16
         If (ANAME .EQ. 'S')IZ = 16

         If (ANAME .EQ. 'cl')IZ = 17
         If (ANAME .EQ. 'Cl')IZ = 17
         If (ANAME .EQ. 'cL')IZ = 17
         If (ANAME .EQ. 'CL')IZ = 17

         If (ANAME .EQ. 'k')IZ = 19
         If (ANAME .EQ. 'K')IZ = 19

         If (ANAME .EQ. 'ca')IZ = 20
         If (ANAME .EQ. 'Ca')IZ = 20
         If (ANAME .EQ. 'cA')IZ = 20
         If (ANAME .EQ. 'CA')IZ = 20

         If (ANAME .EQ. 'cu')IZ = 29
         If (ANAME .EQ. 'Cu')IZ = 29
         If (ANAME .EQ. 'cU')IZ = 29
         If (ANAME .EQ. 'CU')IZ = 29

         If (ANAME .EQ. 'ge')IZ = 32
         If (ANAME .EQ. 'Ge')IZ = 32
         If (ANAME .EQ. 'gE')IZ = 32
         If (ANAME .EQ. 'GE')IZ = 32

         If (ANAME .EQ. 'au')IZ = 79
         If (ANAME .EQ. 'Au')IZ = 79
         If (ANAME .EQ. 'aU')IZ = 79
         If (ANAME .EQ. 'AU')IZ = 79

         If (iZ .EQ. 0)Then

            Write(*,*)'GETTYPE: UNKNOWN ATOM NAME IN COORDINATE&
                     & FILE, NAME = ',ANAME

            Stop

         Else

            ITYPE = IZ

         EndIf

         !DONE WITH CONVERSION!

         Return

      End Subroutine
