! Subroutine: Linker
! Purpose: Links two peptides that are broken and RE-orders the atom list
! Written: January 8th 2009
! Last Update: January 8th 2009
! Author: Eric Dykeman

! NOTES: VARIABLES
!        SystemParam - Global variables
!
!        DEPENDANCIES
!

! **********************************************************************

      Subroutine Linker

         Use SystemParam, Only : RAT,ITYPE,IRES,RESN,ILINK,NAT,NRES,NPRO

         Implicit None

      !Variable Declaration!

      !Local Variables!

         Integer, Dimension(:), Allocatable :: LNR,IWRT,IWRKC,IWRKN
         Character*3, Dimension(:), Allocatable :: RNTN,RCTN

         Double Precision RNEW
         Integer i,j,iS,iE,jS,jE,iP,iR,iATM,iCNT
         Integer iPCT,iPNT,IRNEW,ITNEW,iCHOICE,iOK
         Character*3 RESNEW

         Dimension RNEW(NAT,3),ITNEW(NAT)
         Dimension IRNEW(NRES),RESNEW(NRES)

      !ROUTINE!

         !Count Number of Protein Segments!

         NPRO = 0

         Do i=1,NRES
         If (IRES(i) .LT. 0)NPRO = NPRO + 1
         EndDo

         If (NPRO .EQ. 1)Then

            Write(*,*)'LINKER: THERE IS ONLY ONE PROTEIN PRESENT'
            Write(*,*)'CANNOT PERFORM LINKING'
            Write(*,*)'RETURNING TO PEPALYZE -- GOODBYE'
            Write(*,*)' '

            Allocate (ILINK(NPRO))
            ILINK(1) = 0

            Return

         EndIf

         Allocate (ILINK(NPRO),IWRT(NPRO),LNR(NPRO),RCTN(NPRO))
         Allocate (RNTN(NPRO),IWRKC(NPRO),IWRKN(NPRO))

         j = 0

         Do i=1,NRES
         If (IRES(i) .LT. 0)Then

            j = j + 1

            LNR(j) = i

            RNTN(j) = RESN(i)

            If (j .GT. 1)Then
            RCTN(j-1) = RESN(i-1)
            EndIf

         EndIf
         EndDo

         RCTN(NPRO) = RESN(NRES)

         !Initialize IWRKC and IWRKN!

         Do i=1,NPRO
         IWRKC(i) = 0
         IWRKN(i) = 0
         EndDo


         iCHOICE = 1

         !LINKER MENU LOOP!

         Do While (iCHOICE .NE. 0)

         Write(*,*)'---------------- LINKER MAIN MENU -----------------'
         Write(*,*)' '
         Write(*,*)'CHOOSE ONE OF THE FOLLOWING'
         Write(*,*)' '
         Write(*,*)'DISPLAY CTERM AND NTERM RESIDUE NAMES OF EACH'
         Write(*,*)'PROTIEN WITH CURRENT LINKING STATUS    --- ENTER 1'
         Write(*,*)' '
         Write(*,*)'LINK TWO PROTEINS                      --- ENTER 2'
         Write(*,*)'UN-LINK TWO PROTEINS                   --- ENTER 3'
         Write(*,*)' '
         Write(*,*)'ENTER ZERO (0) TO QUIT LINKER'
         Read(*,*)iCHOICE
         Write(*,*)' '

         If (iCHOICE .EQ. 0)Then

            Write(*,*)'RETURNING TO PEPALYZE -- GOODBYE'
            Write(*,*)' '

         ElseIf (iCHOICE .EQ. 1)Then

            Do i=1,NPRO

            Write(*,*)'PROTEIN # ',i
            Write(*,*)'N TERMINAL RESIDUE = ',RNTN(i)
            Write(*,*)'C TERMINAL RESIDUE = ',RCTN(i)
            Write(*,*)' '

            If (IWRKN(i) .NE. 0)Then
            Write(*,*)'THE N TERMINAL OF THIS PROTEIN IS LINKED TO'
            Write(*,*)'THE C TERMINAL OF PROTEIN # ',IWRKN(i)
            Write(*,*)' '
            EndIf

            If (IWRKC(i) .NE. 0)Then
            Write(*,*)'THE C TERMINAL OF THIS PROTEIN IS LINKED TO'
            Write(*,*)'THE N TERMINAL OF PROTEIN # ',IWRKC(i)
            Write(*,*)' '
            EndIf

            EndDo

         ElseIf (iCHOICE .EQ. 2)Then

            Write(*,*)'--------------------------------------'
            Write(*,*)'PROTEIN A (CT)          (NT) PROTEIN B'
            Write(*,*)' '
            Write(*,*)' '
            Write(*,*)'    PRO A WILL BE LINKED TO PRO B     '
            Write(*,*)' '
            Write(*,*)' '
            Write(*,*)'PROTEIN A (CT) - LINK - (NT) PROTEIN B'
            Write(*,*)'--------------------------------------'
            Write(*,*)' '

            iOK = 0

            Do While (iOK .NE. 1)

            Write(*,*)'ENTER THE PROTEIN NUMBER FOR PRO A (CT)'
            Write(*,*)'A NUMBER FROM 1 - ',NPRO
            Read(*,*)iPCT
            Write(*,*)' '
            Write(*,*)'ENTER THE PROTEIN NUMBER FOR PRO B (NT)'
            Write(*,*)'A NUMBER FROM 1 - ',NPRO
            Read(*,*)iPNT
            Write(*,*)' '

            Write(*,*)'WE ARE LINKING THE FOLLOWING .....'
            Write(*,*)' '
            Write(*,*)'C TERMINAL PRO#',iPCT
            Write(*,*)'C TERMINAL RESIDUE = ',RCTN(iPCT)
            Write(*,*)' '
            Write(*,*)'N TERMINAL PRO#',iPNT
            Write(*,*)'N TERMINAL RESIDUE = ',RNTN(iPNT)
            Write(*,*)' '

            Write(*,*)'IS THIS CORRECT?'
            Write(*,*)'YES --> ENTER 1'
            Write(*,*)'NO  --> ENTER 2'
            Read(*,*)iOK
            Write(*,*)' '

            EndDo

            IWRKC(iPCT) = iPNT
            IWRKN(iPNT) = iPCT

            Write(*,*)'THE TWO PROTEINS HAVE BEEN LINKED'
            Write(*,*)' '

         ElseIf (iCHOICE .EQ. 3)Then

            Write(*,*)'--------------------------------------'
            Write(*,*)'PROTEIN A (CT) - LINK - (NT) PROTEIN B'
            Write(*,*)' '
            Write(*,*)' '
            Write(*,*)'  PRO A WILL BE UN-LINKED FROM PRO B  '
            Write(*,*)' '
            Write(*,*)' '
            Write(*,*)'PROTEIN A (CT)          (NT) PROTEIN B'
            Write(*,*)'--------------------------------------'
            Write(*,*)' '

            iOK = 0

            Do While (iOK .NE. 1)

            Write(*,*)'ENTER THE PROTEIN NUMBER FOR PRO A (CT)'
            Write(*,*)'A NUMBER FROM 1 - ',NPRO
            Read(*,*)iPCT
            Write(*,*)' '
            Write(*,*)'ENTER THE PROTEIN NUMBER FOR PRO B (NT)'
            Write(*,*)'A NUMBER FROM 1 - ',NPRO
            Read(*,*)iPNT
            Write(*,*)' '

            Write(*,*)'WE ARE UN-LINKING THE FOLLOWING .....'
            Write(*,*)' '
            Write(*,*)'C TERMINAL PRO#',iPCT
            Write(*,*)'C TERMINAL RESIDUE = ',RCTN(iPCT)
            Write(*,*)' '
            Write(*,*)'N TERMINAL PRO#',iPNT
            Write(*,*)'N TERMINAL RESIDUE = ',RNTN(iPNT)
            Write(*,*)' '

            Write(*,*)'IS THIS CORRECT?'
            Write(*,*)'YES --> ENTER 1'
            Write(*,*)'NO  --> ENTER 2'
            Read(*,*)iOK
            Write(*,*)' '

            EndDo

            IWRKC(iPCT) = 0
            IWRKN(iPNT) = 0

            Write(*,*)'THE TWO PROTEINS HAVE BEEN UN-LINKED'

         Else

            Write(*,*)iCHOICE,' IS AN INVALID CHOICE'

         EndIf

         EndDo


         !END LINKER MENU LOOP!

         !Re-Order Proteins According to Links!

         iR = 0
         iATM = 0
         iCNT = 0

         Do i=1,NPRO
         IWRT(i) = 0
         EndDo

         Do While (iCNT .NE. NPRO)

            !Find a protein with FREE N-TERMINAL!
            !That has not been written out!

            iP = 0

            Do i=NPRO,1,-1
            If (IWRKN(i) .EQ. 0)Then
            If (IWRT(i) .EQ. 0)iP = i
            EndIf
            EndDo

            If (iP .EQ. 0)Then

               Write(*,*)'FATAL ERROR IN LINKER!'
               Write(*,*)'A PROTEIN WITH A FREE N-TERM DOES NOT EXIST'

               Stop

            EndIf

            iCNT = iCNT + 1

            IWRT(iP) = 1

            ILINK(iCNT) = 0

            !Copy over Protein Number iP!

            iS = LNR(iP)

            If (iP .LT. NPRO)Then
            iE = LNR(iP+1) - 1
            Else
            iE = NRES
            EndIf

            Do i=iS,iE

               iR = iR + 1

               !First Get NEW IRES assignemnt!

               IRNEW(iR) = iATM + 1
               If (IRES(i) .LT. 0)IRNEW(iR) = -IRNEW(iR)

               !Now copy over each amino acid in protein!

               RESNEW(iR) = RESN(i)

               jS = Iabs(IRES(i))

               If (i .LT. NRES)Then
               jE = Iabs(IRES(i+1)) - 1
               Else
               jE = NAT
               EndIf

               Do j=jS,jE
               iATM = iATM + 1
               ITNEW(iATM) = ITYPE(j)
               RNEW(iATM,1) = RAT(j,1)
               RNEW(iATM,2) = RAT(j,2)
               RNEW(iATM,3) = RAT(j,3)
               EndDo

            EndDo

            !NOW WRITE OUT THE PROTEINS THAT!
            !HAVE BEEN LINKED TO THIS ONE!

            iP = IWRKC(iP)

            Do While (iP .NE. 0)

               iCNT = iCNT + 1

               !Store the Residue Number of the N-TERM being!
               !linked.... This requires an extra bond later!

               ILINK(iCNT) = iR + 1

               IWRT(iP) = 1

               !Copy over Protein Number iP!

               iS = LNR(iP)

               If (iP .LT. NPRO)Then
               iE = LNR(iP+1) - 1
               Else
               iE = NRES
               EndIf

               Do i=iS,iE

                  iR = iR + 1

                  !First Get NEW IRES assignemnt!

                  IRNEW(iR) = iATM + 1

                  !Now copy over each amino acid in protein!

                  RESNEW(iR) = RESN(i)

                  jS = Iabs(IRES(i))

                  If (i .LT. NRES)Then
                  jE = Iabs(IRES(i+1)) - 1
                  Else
                  jE = NAT
                  EndIf

                  Do j=jS,jE
                  iATM = iATM + 1
                  ITNEW(iATM) = ITYPE(j)
                  RNEW(iATM,1) = RAT(j,1)
                  RNEW(iATM,2) = RAT(j,2)
                  RNEW(iATM,3) = RAT(j,3)
                  EndDo

               EndDo

               iP = IWRKC(iP)

            EndDo

         EndDo


         !Copy RNEW over to RAT!

         Do i=1,NAT
         ITYPE(i) = ITNEW(i)
         Do j=1,3
         RAT(i,j) = RNEW(i,j)
         EndDo
         EndDo

         !Copy IRNEW over to IRES!

         Do i=1,NRES
         IRES(i) = IRNEW(i)
         RESN(i) = RESNEW(i)
         EndDo

         Deallocate (IWRKC,IWRKN,IWRT,LNR,RCTN,RNTN)

         Return

      End Subroutine
