! Subroutine: Order
! Purpose: Orders the neighbors of an atom to a specific format that
!          Is nessacary to find all atoms associated with the residue
! Written: April 21st 2006
! Last Update: April 21st 2006
! Author: Eric Dykeman

! NOTES: VARIABLES
!           LNEIGH - (NAT,NNMAX) List of Neighbors of each atom
!           NNEIGH - (NAT) Number of neighbors that each atom has
!            ITYPE - (NAT) List of Atom Types
!              NAT - Total Number of Atoms in the System
!            NNMAX - Maximum Number of Neighbors Per atom
!            iPRES - Present Atom Number to order
!            iLAST - Last Atom number
!
!             NOTE - ORDER IS GIVEN BY
!                    1) HYDROGENS
!                    2) SULFERS
!                    3) OXYGENS (DOUBLE BONDED)
!                    4) OXYGENS (SINGLE BONDED)
!                    5) NITROGENS
!                    6) CARBONS (FROM LEAST # OF C NEIGHBORS TO MOST)
!
!        DEPENDANCIES
!        Chemistry
!

! **********************************************************************

      Subroutine Order (LNEIGH,NNEIGH,ITYPE,NAT,NNMAX,iPRES,iLAST)

         Implicit None

      !Variable Declaration!

         Integer, Intent(In) :: NNEIGH,ITYPE,NAT,NNMAX,iPRES,iLAST
         Integer, Intent(InOut) :: LNEIGH

         Dimension LNEIGH(NAT,NNMAX),NNEIGH(NAT),ITYPE(NAT)

      !Local Variables!

         Integer i,j,k,N,M,LTMP,ISKIP,iHCNOS

         Dimension LTMP(NNMAX),ISKIP(NNMAX),iHCNOS(5)

      !ROUTINE!

         k = 0

         Do i=1,NNMAX
         ISKIP(i) = 0
         EndDo

         !First Find Any Hydrogens!

         Do i=1,NNEIGH(iPRES)

            j = LNEIGH(iPRES,i)

            If (j .NE. iLAST .AND. ISKIP(i) .NE. 1)Then

               If (ITYPE(j) .EQ. 1)Then
                  k = k + 1
                  LTMP(k) = j
                  ISKIP(i) = 1
               EndIf

            EndIf

         EndDo

         !Now Find Any Sulfers!

         Do i=1,NNEIGH(iPRES)

            j = LNEIGH(iPRES,i)

            If (j .NE. iLAST .AND. ISKIP(i) .NE. 1)Then

               If (ITYPE(j) .EQ. 16)Then
                  k = k + 1
                  LTMP(k) = j
                  ISKIP(i) = 1
               EndIf

            EndIf

         EndDo

         !Now Find Any Oxygens with a Double Bond!

         Do i=1,NNEIGH(iPRES)

            j = LNEIGH(iPRES,i)

            If (j .NE. iLAST .AND. ISKIP(i) .NE. 1)Then

               If (ITYPE(j) .EQ. 8)Then
               If (NNEIGH(j) .EQ. 1)Then
                  k = k + 1
                  LTMP(k) = j
                  ISKIP(i) = 1
               EndIf
               EndIf

            EndIf

         EndDo

         !Now Find Any Oxygens with No Double Bonds!

         Do i=1,NNEIGH(iPRES)

            j = LNEIGH(iPRES,i)

            If (j .NE. iLAST .AND. iSKIP(i) .NE. 1)Then

               If (ITYPE(j) .EQ. 8)Then
               If (NNEIGH(j) .EQ. 2)Then
                  k = k + 1
                  LTMP(k) = j
                  ISKIP(i) = 1
               EndIf
               EndIf

            EndIf

         EndDo

         !Now Find Any Nitrogens!

         Do i=1,NNEIGH(iPRES)

            j = LNEIGH(iPRES,i)

            If (j .NE. iLAST .AND. ISKIP(i) .NE. 1)Then

               If (ITYPE(j) .EQ. 7)Then
                  k = k + 1
                  LTMP(k) = j
                  ISKIP(i) = 1
               EndIf

            EndIf

         EndDo

         !Now Find Any Carbons!

         !Carbons Neighbor Order is from Least Number!
         !of Carbon Neighbors To the Greatest!

         Do While (k .NE. NNEIGH(iPRES) - 1)

            N = NNMAX

            Do i=1,NNEIGH(iPRES)

               j = LNEIGH(iPRES,i)

               If (j .NE. iLAST .AND. ISKIP(i) .NE. 1)Then

                  If (ITYPE(j) .EQ. 6)Then
                  Call Chemistry (LNEIGH(j,:),NNEIGH(j),&
                                & ITYPE,NAT,NNMAX,iHCNOS)

                  If (iHCNOS(2) .LT. N)Then
                     N = iHCNOS(2)
                     M = i
                  EndIf

                  EndIf

               EndIf

            EndDo

            k = k + 1
            ISKIP(M) = 1
            LTMP(k) = LNEIGH(iPRES,M)

         EndDo

         !Now Place in Last Neighbor!

         k = k + 1

         LTMP(k) = iLAST

         !Copy Over to LNEIGH!

         Do i=1,NNEIGH(iPRES)

            LNEIGH(iPRES,i) = LTMP(i)

         EndDo

         Return

      End Subroutine
