! Program: Pepalyze
! Purpose: Analyzes a protein and does one or more of the following tasks
!          1) Outputs the proteins sequence
!          2) Outputs the proteins ramachandran angles
!          3) Builds a Saguaro Coordinate and Parameter file
!             for the protein.
! Written: May 3rd 2006
! Last Update: January 8th 2009
! Author: Eric Dykeman

! NOTES: DEPENDANCIES
!        
!

! **********************************************************************

      Program Pepalyze

         Use SystemParam

         Implicit None

      !Variable Declaration!

         Character, Dimension(:), Allocatable :: RTYPE,RCODE
         Integer, Dimension (:), Allocatable :: IWRK

         Double Precision AMASS
         Integer i,j,k,iS,iE,iCRD,iCHOICE
         Integer iADDH,MAXTP,iPH,iLN,NARG
         Character*60 INFILE,OUTFILE,PARMFILE
         Character*60 MOLFILE,CRDFILE,ARG

         Parameter (MAXTP = 100)

         Dimension AMASS(MAXTP)

      !ROUTINE!

         !Get Special command Line Arguments!

         iPH = 0     !RUN PROTONATION ADJUSTER!
         iLN = 0     !RUN PROTIEN LINKER!

         NARG = Iargc()

         If (NARG .NE. 0)Then

            Do i=1,NARG

            Call GetArg(i,ARG)

            Select Case (ARG)
               Case ('-P')
               iPH = 1
               Case ('-L')
               iLN = 1
               Case Default
               Write(*,*)ARG,'Invalid Reference'
            End Select

            EndDo

         EndIf

         Write(*,*)' '
         Write(*,*)'PEPALYZE SPECIAL TASKS'

         If (iPH .EQ. 1)Then
         Write(*,*)'PROTONATION ADJUSTER [-P option] (ON)'
         Else
         Write(*,*)'PROTONATION ADJUSTER [-P option] (OFF)'
         EndIf

         If (iLN .EQ. 1)Then
         Write(*,*)'PEPTIDE LINKER [-L option] (ON)'
         Else
         Write(*,*)'PEPTIDE LINKER [-L option] (OFF)'
         EndIf

         Write(*,*)' '
         Write(*,*)' '

         !MASSES!

         Do i=1,MAXTP
         AMASS(i) = 0.0d0
         EndDo

         AMASS(1)=1.008d0
         AMASS(3)=6.941d0
         AMASS(6)=1.201d1
         AMASS(7)=1.401d1
         AMASS(8)=1.599d1
         AMASS(9)=1.899d1
         AMASS(11)=2.299d1
         AMASS(12)=2.431d1
         AMASS(13)=2.698d1
         AMASS(14)=2.809d1
         AMASS(15)=3.097d1
         AMASS(16)=3.207d1
         AMASS(19)=3.909d1
         AMASS(20)=4.0078d1
         AMASS(29)=6.355d1
         AMASS(32)=7.261d1
         AMASS(79)=1.969d2

         Write(*,*)'------------WELCOME TO PEPALYZE---------------'
         Write(*,*)' '
         Write(*,*)'WE WILL ANALYZE A GIVEN PEPTIDE THEN DO ONE'
         Write(*,*)'OR MORE OF THE FOLLOWING TASKS:'
         Write(*,*)'1) OUTPUT THE AMINO ACID SEQUENCE OF THE PEPTIDE'
         Write(*,*)'2) OUTPUT THE RAMACHANDRAN ANGLES OF THE PEPTIDE'
         Write(*,*)'3) BUILD A SAGUARO PARM, MOL, AND GF2K FILE'
         Write(*,*)' '

         Write(*,*)'PLEASE ENTER THE FILE NAME'
         Read(*,*)INFILE
         Write(*,*)INFILE
         Write(*,*)' '

         Write(*,*)'WHAT FORMAT IS THIS IN?'
         Write(*,*)'PDB  ---> ENTER 1'
         Write(*,*)'XYZ  ---> ENTER 2'
         Write(*,*)'GF2K ---> ENTER 3'
         Read(*,*)iCRD
         Write(*,*)iCRD
         Write(*,*)' '

         Open(Unit=1,File=INFILE,Status='Unknown')

         Select Case (iCRD)
            Case (1)
            Call Readpdb
            Case (2)
            Call Readxyz
            Case (3)
            Call Readgf2k
            Case Default
            Write(*,*)'ERROR: NOT A VALID CHOICE!'
            Stop
         End Select

         Call Analyze

         If (iLN .EQ. 1)Then

            Write(*,*)'WOULD YOU LIKE TO LINK THE CTERM-NTERM?'
            Write(*,*)'YES ---> ENTER 1'
            Write(*,*)'NO  ---> ENTER 0 (DEFAULT)'
            Write(*,*)' '
            write(*,*)'NOTE: This option is for a backbone that is in'
            write(*,*)'parts. Be sure that any CTERMS are terminated'
            write(*,*)'with an OXT.'
            Read(*,*)iCHOICE
            Write(*,*)iCHOICE
            Write(*,*)' '

            If (iCHOICE .EQ. 1)Call Linker

         EndIf

         Write(*,*)'DO YOU WANT TO CHECK FOR MISSING HYDROGENS?'
         Write(*,*)' '
         Write(*,*)'------------------NOTE--------------------'
         Write(*,*)'THE DEFAULT AMINO ACID PROTONATION IS (PH 7)'
         Write(*,*)'AND HAS THE FOLLOWING CHARGED AMINOS:'
         Write(*,*)'ASP = -1e GLU = -1e ARG = +1e LYS = +1e'
         Write(*,*)' '
         Write(*,*)'YES ---> ENTER 1'
         Write(*,*)'NO  ---> ENTER 0'
         Read(*,*)iCHOICE
         Write(*,*)iCHOICE
         Write(*,*)' '

         iADDH = 0

         If (iCHOICE .EQ. 1)Then

            Call AddH

            iADDH = 1

         EndIf

         !Do Various Tasks One at a Time!

         Write(*,*)'WOULD YOU LIKE TO OUTPUT THE SEQUENCE?'
         Write(*,*)'YES ---> ENTER 1'
         Write(*,*)'NO  ---> ENTER 0'
         Read(*,*)iCHOICE
         Write(*,*)iCHOICE
         Write(*,*)' '

         If (iCHOICE .EQ. 1)Then

            !Output Amino Acid Sequence!

            Write(*,*)'PLEASE ENTER OUTPUT FILE FOR SEQUENCE INFO'
            Read(*,*)OUTFILE
            Write(*,*)OUTFILE
            Write(*,*)' '

            Open(Unit=2,File=OUTFILE,Status='Unknown')

            !Get Hydrophillic, Hydrophobic, Basic and Acidic Info!
            !As Well As Single Letter Atom names for aminos!

            Allocate(RTYPE(NRES),RCODE(NRES))

            Do i=1,NRES

               RTYPE(i) = ' '

               If (RESN(i) .EQ. 'ASP')RTYPE(i) = '-'
               If (RESN(i) .EQ. 'GLU')RTYPE(i) = '-'

               If (RESN(i) .EQ. 'HIS')RTYPE(i) = '+'
               If (RESN(i) .EQ. 'LYS')RTYPE(i) = '+'
               If (RESN(i) .EQ. 'ARG')RTYPE(i) = '+'

               If (RESN(i) .EQ. 'ASN')RTYPE(i) = 'W'
               If (RESN(i) .EQ. 'GLN')RTYPE(i) = 'W'
               If (RESN(i) .EQ. 'SER')RTYPE(i) = 'W'
               If (RESN(i) .EQ. 'THR')RTYPE(i) = 'W'

               If (RESN(i) .EQ. 'ALA')RCODE(i) = 'A'
               If (RESN(i) .EQ. 'ARG')RCODE(i) = 'R'
               If (RESN(i) .EQ. 'ASN')RCODE(i) = 'N'
               If (RESN(i) .EQ. 'ASP')RCODE(i) = 'D'
               If (RESN(i) .EQ. 'CYS')RCODE(i) = 'C'
               If (RESN(i) .EQ. 'CYX')RCODE(i) = 'C'
               If (RESN(i) .EQ. 'GLN')RCODE(i) = 'Q'
               If (RESN(i) .EQ. 'GLU')RCODE(i) = 'E'
               If (RESN(i) .EQ. 'GLY')RCODE(i) = 'G'
               If (RESN(i) .EQ. 'HIS')RCODE(i) = 'H'
               If (RESN(i) .EQ. 'ILE')RCODE(i) = 'I'
               If (RESN(i) .EQ. 'LEU')RCODE(i) = 'L'
               If (RESN(i) .EQ. 'LYS')RCODE(i) = 'K'
               If (RESN(i) .EQ. 'MET')RCODE(i) = 'M'
               If (RESN(i) .EQ. 'PHE')RCODE(i) = 'F'
               If (RESN(i) .EQ. 'PRO')RCODE(i) = 'P'
               If (RESN(i) .EQ. 'SER')RCODE(i) = 'S'
               If (RESN(i) .EQ. 'THR')RCODE(i) = 'T'
               If (RESN(i) .EQ. 'TRP')RCODE(i) = 'W'
               If (RESN(i) .EQ. 'TYR')RCODE(i) = 'Y'
               If (RESN(i) .EQ. 'VAL')RCODE(i) = 'V'

            EndDo

            Write(2,*)'AMINO ACID SEQUENCE OF COORDINATE FILE: ',INFILE

            iS = 1

            Do While (iS .LE. NRES)

            Write(2,*)' '

            iE = iS + 1

            If (iE .LE. NRES)Then
            Do While (IRES(iE) .GT. 0 .AND. iE .LT. NRES)
            iE = iE + 1
            EndDo
            EndIf

            If (iE .NE. NRES)iE = iE - 1

            !First Output Single Atom Code and Type!

            Write(2,21)(RCODE(j),j=iS,iE)
            Write(2,21)(RTYPE(j),j=iS,iE)
            Write(2,*)' '

            Write(2,20)(RESN(j),j=iS,iE)

            iS = iE + 1

            EndDo

            Close (Unit = 2)

         EndIf

         Write(*,*)'WOULD YOU LIKE TO OUTPUT THE RAMA ANGLES?'
         Write(*,*)'YES ---> ENTER 1'
         Write(*,*)'NO  ---> ENTER 0'
         Read(*,*)iCHOICE
         Write(*,*)iCHOICE
         Write(*,*)' '

         If (iCHOICE .EQ. 1)Then

            If (iADDH .NE. 1)Then

               Call AddH

               iADDH = 1

            EndIf

            Write(*,*)'PLEASE ENTER OUTPUT FILE FOR RAMA ANGLES'
            Read(*,*)OUTFILE
            Write(*,*)OUTFILE
            Write(*,*)' '

            Open(Unit=3,File=OUTFILE,Status='Unknown')

            Call WriteRama

            Close(Unit = 3)

         EndIf

         Write(*,*)'WOULD YOU LIKE TO BUILD SAGUARO FILES?'
         Write(*,*)'YES ---> ENTER 1'
         Write(*,*)'NO  ---> ENTER 0'
         Read(*,*)iCHOICE
         Write(*,*)iCHOICE
         Write(*,*)' '

         If (iCHOICE .EQ. 1)Then

            If (iADDH .NE. 1)Then

               Call AddH

               iADDH = 1

            EndIf

            !NOTE!! ON HIS THERE ARE 2 POSIBILITIES HID OR HIE!
            !THE DEFAULT IS HID, WE CHANGE THE NAME FOR PARAMETER!
            !BUILDING!

            Do i=1,NRES
            If (RESN(i) .EQ. 'HIS')RESN(i) = 'HID'
            EndDo

            !PROTATION ADJUSTMENT OPTION -P!

            If (iPH .EQ. 1)Then

               Write(*,*)'WOULD YOU LIKE TO CHANGE THE PROTONATION'
               Write(*,*)'OF ANY AMINO ACIDS?'
               Write(*,*)'YES --> ENTER 1'
               Write(*,*)'NO  --> ENTER 0'
               Read(*,*)iCHOICE
               Write(*,*)iCHOICE
               Write(*,*)' '

               If (iCHOICE .EQ. 1)Call AdjustPH

            EndIf

            Call SetupParms(iLN)

            Write(*,*)'PLEASE ENTER SAGUARO PARM FILE NAME'
            Read(*,*)PARMFILE
            Write(*,*)PARMFILE
            Write(*,*)' '

            Write(*,*)'PLEASE ENTER SAGUARO MOL FILE NAME'
            Read(*,*)MOLFILE
            Write(*,*)MOLFILE
            Write(*,*)' '

            Write(*,*)'PLEASE ENTER SAGUARO GF2K FILE NAME'
            Read(*,*)CRDFILE
            Write(*,*)CRDFILE
            Write(*,*)' '

            Open(Unit=7,File=PARMFILE,Status='Unknown')
            Open(Unit=8,File=MOLFILE,Status='Unknown')
            Open(Unit=9,File=CRDFILE,Status='Unknown')

            !First need to put bonds in order!
            !hbonds first - others second!

            If (NBD .NE. 0)Then

            NHBD = 0

            Allocate (IWRK(NBD))

            Do i=1,NBD

               j = ITYPE(LBOND(i,1))
               k = ITYPE(LBOND(i,2))

               If (j .EQ. 1)Then
               NHBD = NHBD + 1
               IWRK(i) = 1
               ElseIf (k .EQ. 1)Then
               NHBD = NHBD + 1
               IWRK(i) = 1
               Else
               IWRK(i) = 0
               EndIf

            EndDo

            EndIf

            Write(7,70)NAT,NBD,NHBD,NAG,NDH+NIDH,NEX,N14

            Do i=1,NAT
            j = ITYPE(i)
            If (AMASS(j) .EQ. 0.0d0)Then
            Write(*,*)'ERROR: UNKNOWN ATOM MASS FOR ATOM # ',i
            Write(*,*)'ATOMIC NUMBER IS ',j
            Stop
            EndIf
            Write(7,71)AMASS(j),Q(i),DVDW(i,1),DVDW(i,2)
            EndDo

            If (NBD .NE. 0)Then

            !BONDS CONTAINING HYDROGEN!

            Do i=1,NBD
            If (IWRK(i) .EQ. 1)Then
            Write(7,72)LBOND(i,1),LBOND(i,2),DBOND(i,1),DBOND(i,2)
            EndIf
            EndDo

            !BONDS WITH NO HYDROGEN!

            Do i=1,NBD
            If (IWRK(i) .EQ. 0)Then
            Write(7,72)LBOND(i,1),LBOND(i,2),DBOND(i,1),DBOND(i,2)
            EndIf
            EndDo

            Deallocate(IWRK)

            EndIf

            If (NAG .NE. 0)Then

            Do i=1,NAG
            Write(7,73)LANGL(i,1),LANGL(i,2),LANGL(i,3),DANGL(i,1),&
                      &DANGL(i,2)
            EndDo

            EndIf

            If (NDH .NE. 0)Then

            !PROPER DIHEDRAL!

            Do i=1,NDH
            Write(7,74)LDIHD(i,1),LDIHD(i,2),LDIHD(i,3),LDIHD(i,4),&
                      &DDIHD(i,1),DDIHD(i,2),DDIHD(i,3)
            EndDo

            EndIf

            !IMPROPER DIHEDRAL!

            If (NIDH .NE. 0)Then

            Do i=1,NIDH
            Write(7,74)LIDIHD(i,1),LIDIHD(i,2),LIDIHD(i,3),LIDIHD(i,4),&
                      &DIDIHD(i,1),DIDIHD(i,2),DIDIHD(i,3)
            EndDo

            EndIf

            If (NEX .NE. 0)Then

            Do i=1,NEX
            Write(7,75)LEX(i,1),LEX(i,2)
            EndDo

            EndIf

            If (N14 .NE. 0)Then

            Do i=1,N14
            Write(7,75)L14(i,1),L14(i,2)
            EndDo

            EndIf

            Write(8,80)NAT,NMOL
            Do i=1,NAT
            Write(8,81)MOLN(i),MTYPE(i)
            EndDo

            Write(9,90)NAT,0.0d0
            Do i=1,NAT
            Write(9,91)ITYPE(i),RAT(i,1),RAT(i,2),RAT(i,3)
            EndDo

            Close(Unit = 7)
            Close(Unit = 8)
            Close(Unit = 9)

         EndIf

         Write(*,*)'GOODBYE FROM PEPALYZE!!!'

         Close (Unit = 1)

 20      Format(10(1X,A3))
 21      Format(50A1)
 30      Format(I6,E16.8)
 31      Format(2F12.6)
 70      Format(7I8)
 71      Format(4E16.8)
 72      Format(2I8,16X,2E16.8)
 73      Format(3I8,8X,2E16.8)
 74      Format(4I8,3E16.8)
 75      Format(2I8)
 80      Format(I8,I6)
 81      Format(I6,2X,A1)
 90      Format(I8,E16.8)
 91      Format(I3,3F13.7)
 92      Format(3F13.7)

      End Program
