! Subroutine: Readxyz
! Purpose: Reads in a coordinate file that is in xyz format then converts
!          atom names to numerical numbers
! Written: April 26th 2006
! Last Update: April 26th 2006
! Author: Eric Dykeman

! NOTES: VARIABLES
!            RAT - (NAT,3) List of Atomic Coordinates
!          ITYPE - (NAT) List of Atom types
!            NAT - Total Number of atoms in the system
!
!        DEPENDANCIES
!        Systemparam - Module Contaning global system variables
!        GetType
!

! **********************************************************************

      Subroutine Readxyz

         Use SystemParam, Only : RAT,ITYPE,NAT

         Implicit None

      !Variable Declaration!

      !Local Variables!

         Integer i
         Character*2 JUNK,ANAME

      !ROUTINE!

         Read(1,*)NAT

         Read(1,*)JUNK

         Allocate(RAT(NAT,3),ITYPE(NAT))

         Do i=1,NAT

            Read(1,*)ANAME,RAT(i,1),RAT(i,2),RAT(i,3)

            Call GetType (ANAME,ITYPE(i))

         EndDo

         Return

      End Subroutine
