! Subroutine: SetupParms
! Purpose: Sets up paramters for bonds, angles, dihedrals and sets up
!          partial charges and excluded and 1-4 lists for amino acids.
! Written: May 3rd 2006
! Last Update: January 20th 2009
! Author: Eric Dykeman

! NOTES: VARIABLES
!            RESN - (NRES) List of amino acid residue names
!            IRES - (NRES) List containing the first atom number (N)
!                   corresponding to each amino acid. A negative
!                   sign denotes the N-Terminal amino of a chain
!                   Analyize put these in order N-terminal to C-terminal
!            NRES - Total number of amino acid residues
!
!        DEPENDANCIES
!        SystemParam - Global system variables
!

! **********************************************************************

      Subroutine SetupParms(iLN)

         Use SystemParam

         Implicit None

      !Variable Declaration!

         Integer, Intent(In) :: iLN

      !Local Variables!

         Integer i,j,k,m,iCNT,iTST,NNEIGH,LNEIGH,NNMAX
         Integer iAT1,iAT2,iAT3,iAT4
         Logical OK

         Parameter (NNMAX = 4)

         Dimension LNEIGH(NAT,NNMAX),NNEIGH(NAT)

      !ROUTINE!

         !The List of AMBER Parmeters!

         !AMBER ATOM TYPES- ATYPE(NAAT)!
         !VDW DATA       -- AVDW(NAAT)!
         !BOND NAMES     -- ABDN(NABD,2)!
         !BOND DATA      -- ABDD(NABD,2)!
         !ANGLE NAMES    -- AAGN(NAAG,3)!
         !ANGLE DATA     -- AAGD(NAAG,2)!
         !DIHEDRAL NAMES -- ADHN(NADH,4)!
         !DIHEDRAL DATA  -- ADHD(NADH,3)!
         !IMPROPER NAMES -- AIDHN(NAIDH,4)!
         !IMPROPER DATA  -- AIDHD(NAIDH,3)!

         !First Allocate some duh stuff!

         Allocate (DVDW(NAT,2),Q(NAT),ATMT(NAT))

         !Read in AMBER parmeter files i.e parm94.dat!

         Call ReadAP

         !Assign Atom TYPES CHARGES From amino file!
         !i.e. all_amino94.dat all_aminoct.dat etc.!

         Call AssignTC

         !NOW ALL THAT REMAINS IS TO FIND BONDED TERMS!
         !AND ASSIGN VDW DATA ... 

         !VDW!

         Do i=1,NAT

            OK = .FALSE.

            Do j=1,NAAT
            If (ATYPE(j) .EQ. ATMT(i))Then
            DVDW(i,1) = AVDW(j,1)
            DVDW(i,2) = AVDW(j,2)
            OK = .TRUE.
            EndIf
            EndDo

            If (.NOT. OK)Then
            Write(*,*)'ERROR: NO ATOM OF TYPE ',ATMT(i)
            Write(*,*)'IS LISTED IN PARAMETER FILE'
            Stop
            EndIf

         EndDo

         !CALL NEIGHBORS TO FIND BONDS!

         Call Neighbors (RAT,ITYPE,LNEIGH,NNEIGH,NAT,NNMAX)

         !LINKER OPTION!

         If (iLN .EQ. 1)Then

            !Make Bonds Between Linked Proteins!

            Do i=1,NPRO
            If (ILINK(i) .NE. 0)Then

               j = IRES(ILINK(i))
               k = j - 2

               NNEIGH(j) = NNEIGH(j) + 1
               NNEIGH(k) = NNEIGH(k) + 1
               LNEIGH(j,NNEIGH(j)) = k
               LNEIGH(k,NNEIGH(k)) = j

            EndIf
            EndDo

         EndIf

         !BONDS!

         NBD = 0

         Do i=1,NAT
         Do j=1,NNEIGH(i)
         If (LNEIGH(i,j) .GT. i)NBD = NBD + 1
         EndDo
         EndDo

         If (NBD .EQ. 0)Then
         Write(*,*)'ERROR: NO BONDS?? SOMETHING IS STRANGE'
         Write(*,*)'CHECK NEIGHBORS.F90'
         Stop
         EndIf

         Allocate(DBOND(NBD,2),LBOND(NBD,2))

         iCNT = 0

         Do i=1,NAT
         Do j=1,NNEIGH(i)

            m = LNEIGH(i,j)

            If (m .GT. i)Then

               iCNT = iCNT + 1
               LBOND(iCNT,1) = i
               LBOND(iCNT,2) = m

               !Which type of bond?!

               OK = .FALSE.

               Do k=1,NABD
               If (ABDN(k,1) .EQ. ATMT(i))Then

                  If (ABDN(k,2) .EQ. ATMT(m))Then
                  DBOND(iCNT,1) = ABDD(k,1)
                  DBOND(iCNT,2) = ABDD(k,2)
                  OK = .TRUE.
                  EndIf

               ElseIf (ABDN(k,2) .EQ. ATMT(i))Then

                  If (ABDN(k,1) .EQ. ATMT(m))Then
                  DBOND(iCNT,1) = ABDD(k,1)
                  DBOND(iCNT,2) = ABDD(k,2)
                  OK = .TRUE.
                  EndIf

               EndIf
               EndDo

               If (.NOT. OK)Then
               Write(*,*)'ERROR: NO BOND LISTED IN PARAMETER FILE'
               Write(*,*)'FOR TYPE ',ATMT(m),'-',ATMT(i)
               Stop
               EndIf

            EndIf

         EndDo
         EndDo

         !ANGLES!

         !Angles are simply two bonds!
         !that share a common atom!

         NAG = 0

         Do i=1,NBD-1
         Do j=i+1,NBD

            If (LBOND(i,1) .EQ. LBOND(j,1))NAG = NAG + 1
            If (LBOND(i,1) .EQ. LBOND(j,2))NAG = NAG + 1
            If (LBOND(i,2) .EQ. LBOND(j,1))NAG = NAG + 1
            If (LBOND(i,2) .EQ. LBOND(j,2))NAG = NAG + 1

         EndDo
         EndDo

         If (NAG .EQ. 0)Then
         Write(*,*)'ERROR: NO ANGLES?? SOMETHING IS STRANGE'
         Write(*,*)'CHECK SETUPPARAMS.F90'
         Stop
         EndIf

         Allocate (DANGL(NAG,2),LANGL(NAG,3))

         iCNT = 0

         Do i=1,NBD-1
         Do j=i+1,NBD

            iAT1 = 0

            If (LBOND(i,1) .EQ. LBOND(j,1))Then
            iAT1 = LBOND(i,2)
            iAT2 = LBOND(i,1)
            iAT3 = LBOND(j,2)
            EndIf

            If (LBOND(i,1) .EQ. LBOND(j,2))Then
            iAT1 = LBOND(i,2)
            iAT2 = LBOND(i,1)
            iAT3 = LBOND(j,1)
            EndIf

            If (LBOND(i,2) .EQ. LBOND(j,1))Then
            iAT1 = LBOND(i,1)
            iAT2 = LBOND(i,2)
            iAT3 = LBOND(j,2)
            EndIf

            If (LBOND(i,2) .EQ. LBOND(j,2))Then
            iAT1 = LBOND(i,1)
            iAT2 = LBOND(i,2)
            iAT3 = LBOND(j,1)
            EndIf

            If (iAT1 .NE. 0)Then

               iCNT = iCNT + 1

               LANGL(iCNT,1) = iAT1
               LANGL(iCNT,2) = iAT2
               LANGL(iCNT,3) = iAT3

               !Which Type of Angle?!

               OK = .FALSE.

               Do k=1,NAAG
               If (AAGN(k,2) .EQ. ATMT(iAT2))Then
               If (AAGN(k,1) .EQ. ATMT(iAT1))Then

                  If (AAGN(k,3) .EQ. ATMT(iAT3))Then
                  DANGL(iCNT,1) = AAGD(k,1)
                  DANGL(iCNT,2) = AAGD(k,2)
                  OK = .TRUE.
                  EndIf

               ElseIf (AAGN(k,1) .EQ. ATMT(iAT3))Then

                  If (AAGN(k,3) .EQ. ATMT(iAT1))Then
                  DANGL(iCNT,1) = AAGD(k,1)
                  DANGL(iCNT,2) = AAGD(k,2)
                  OK = .TRUE.
                  EndIf

               EndIf
               EndIf
               EndDo

               If (.NOT. OK)Then
               Write(*,*)'ERROR: NO ANGLE LISTED IN PARAMETER FILE'
               Write(*,*)'FOR TYPE ',ATMT(iAT1),'-',ATMT(iAT2),&
                        &'-',ATMT(iAT3)
               Stop
               EndIf

            EndIf

         EndDo
         EndDo

         !DIHEDRALS!

         !Dihedrals are Angles That!
         !Share a single bond!

         !Since all angles are unique, there are 2 cases!

!                       (1)*
!                             *
!         CASE 1                 *(2)--------(3)
!         PROPER                                *
!                                                 *
!                                                   *(4)
!
!                                          *(4)
!                                       *
!         CASE 2        (1)-------(2)*
!         IMPROPER                      *
!                                          *(3)
!
         !CASE 1!

         NDH = 0
 3       iCNT = 0

         If (NDH .NE. 0)Then
         Allocate (LDIHD(NDH,4),DDIHD(NDH,3))
         EndIf

         Do i=1,NAG-1
         Do j=i+1,NAG

            iAT1 = 0

            If (LANGL(i,2) .EQ. LANGL(j,1))Then

               iAT2 = LANGL(j,1)
               iAT3 = LANGL(j,2)
               iAT4 = LANGL(j,3)

               If (iAT3 .EQ. LANGL(i,1))iAT1 = LANGL(i,3)
               If (iAT3 .EQ. LANGL(i,3))iAT1 = LANGL(i,1)

            EndIf

            If (LANGL(i,2) .EQ. LANGL(j,3))Then

               iAT2 = LANGL(j,3)
               iAT3 = LANGL(j,2)
               iAT4 = LANGL(j,1)

               If (iAT3 .EQ. LANGL(i,1))iAT1 = LANGL(i,3)
               If (iAT3 .EQ. LANGL(i,3))iAT1 = LANGL(i,1)

            EndIf

            If (iAT1 .NE. 0)Then

               !Which Type of Dihedral?!

               OK = .FALSE.

               !First Search For SPECIFIC!
               !e.g. CT-CT-CT-CT!

               Do k=1,NADH

                  iTST = 0

                  If (ADHN(k,1) .EQ. ATMT(iAT1))iTST = iTST + 1
                  If (ADHN(k,2) .EQ. ATMT(iAT2))iTST = iTST + 1
                  If (ADHN(k,3) .EQ. ATMT(iAT3))iTST = iTST + 1
                  If (ADHN(k,4) .EQ. ATMT(iAT4))iTST = iTST + 1

                  If (iTST .EQ. 4)Then

                     iCNT = iCNT + 1
                     OK = .TRUE.

                     If (NDH .NE. 0)Then
                     LDIHD(iCNT,1) = iAT1
                     LDIHD(iCNT,2) = iAT2
                     LDIHD(iCNT,3) = iAT3
                     LDIHD(iCNT,4) = iAT4
                     DDIHD(iCNT,1) = ADHD(k,1)
                     DDIHD(iCNT,2) = ADHD(k,2)
                     DDIHD(iCNT,3) = Dabs(ADHD(k,3))
                     EndIf

                  EndIf

                  iTST = 0

                  If (ADHN(k,1) .EQ. ATMT(iAT4))iTST = iTST + 1
                  If (ADHN(k,2) .EQ. ATMT(iAT3))iTST = iTST + 1
                  If (ADHN(k,3) .EQ. ATMT(iAT2))iTST = iTST + 1
                  If (ADHN(k,4) .EQ. ATMT(iAT1))iTST = iTST + 1

                  If (iTST .EQ. 4)Then

                     iCNT = iCNT + 1
                     OK = .TRUE.

                     If (NDH .NE. 0)Then
                     LDIHD(iCNT,1) = iAT1
                     LDIHD(iCNT,2) = iAT2
                     LDIHD(iCNT,3) = iAT3
                     LDIHD(iCNT,4) = iAT4
                     DDIHD(iCNT,1) = ADHD(k,1)
                     DDIHD(iCNT,2) = ADHD(k,2)
                     DDIHD(iCNT,3) = Dabs(ADHD(k,3))
                     EndIf

                  EndIf

               EndDo

               !Now if SPECIFIC Was not found look!
               !for a GENERAL e.g. X-CT-CT-X!

               If (.NOT. OK)Then
               Do k=1,NADH
               If (ADHN(k,1) .EQ. 'X ' .AND. ADHN(k,4) .EQ. 'X ')Then

                  If (ADHN(k,2) .EQ. ATMT(iAT2))Then

                     If (ADHN(k,3) .EQ. ATMT(iAT3))Then

                        iCNT = iCNT + 1
                        OK = .TRUE.

                        If (NDH .NE. 0)Then
                        LDIHD(iCNT,1) = iAT1
                        LDIHD(iCNT,2) = iAT2
                        LDIHD(iCNT,3) = iAT3
                        LDIHD(iCNT,4) = iAT4
                        DDIHD(iCNT,1) = ADHD(k,1)
                        DDIHD(iCNT,2) = ADHD(k,2)
                        DDIHD(iCNT,3) = Dabs(ADHD(k,3))
                        EndIf

                     EndIf

                  ElseIf (ADHN(k,3) .EQ. ATMT(iAT2))Then

                     If (ADHN(k,2) .EQ. ATMT(iAT3))Then

                        iCNT = iCNT + 1
                        OK = .TRUE.

                        If (NDH .NE. 0)Then
                        LDIHD(iCNT,1) = iAT1
                        LDIHD(iCNT,2) = iAT2
                        LDIHD(iCNT,3) = iAT3
                        LDIHD(iCNT,4) = iAT4
                        DDIHD(iCNT,1) = ADHD(k,1)
                        DDIHD(iCNT,2) = ADHD(k,2)
                        DDIHD(iCNT,3) = Dabs(ADHD(k,3))
                        EndIf

                     EndIf

                  EndIf

               EndIf
               EndDo
               EndIf

               If (.NOT. OK)Then
               Write(*,*)'ERROR: NO PROPER DIHEDRAL LISTED IN PARAMETER'
               Write(*,*)'FILE FOR TYPE ',ATMT(iAT1),'-',ATMT(iAT2),&
                        &'-',ATMT(iAT3),'-',ATMT(iAT4)
               Stop
               EndIf

            EndIf

         EndDo
         EndDo

         If (NDH .EQ. 0)Then
         If (iCNT .EQ. 0)Then
         Write(*,*)'ERROR: NO DIHEDRALS?? SOMETHING IS STRANGE'
         Write(*,*)'CHECK SETUPPARAMS.F90'
         Stop
         EndIf
         NDH = iCNT
         Goto 3
         EndIf

         !CASE 2!

         NIDH = 0
 4       iCNT = 0

         If (NIDH .NE. 0)Then
         Allocate(DIDIHD(NIDH,3),LIDIHD(NIDH,4))
         EndIf


         Do i=1,NAT
         If (NNEIGH(i) .EQ. 3)Then

            OK = .FALSE.

            iAT3 = i

            !Search for SPECIFIC First!
            !e.g. CT-CT-CT-CT!

            Do j=1,NAIDH
            If (AIDHN(j,1) .NE. 'X ' .AND. AIDHN(j,2) .NE. 'X ')Then
            If (AIDHN(j,3) .EQ. ATMT(i))Then

               !Find Atom 4, 2 and 1!

               iAT4 = 0
               iAT2 = 0
               iAT1 = 0

               Do k=1,NNEIGH(i)

                  m = LNEIGH(i,k)

                  If (iAT4 .EQ. 0)Then
                  If (iAT2 .NE. m .AND. iAT1 .NE. m)Then
                  If (AIDHN(j,4) .EQ. ATMT(m))iAT4 = m
                  EndIf
                  EndIf

                  If (iAT2 .EQ. 0)Then
                  If (iAT4 .NE. m .AND. iAT1 .NE. m)Then
                  If (AIDHN(j,2) .EQ. ATMT(m))iAT2 = m
                  EndIf
                  EndIf

                  If (iAT1 .EQ. 0)Then
                  If (iAT4 .NE. m .AND. iAT2 .NE. m)Then
                  If (AIDHN(j,1) .EQ. ATMT(m))iAT1 = m
                  EndIf
                  EndIf

               EndDo

               iTST = 1
               If (iAT1 .EQ. 0)iTST = 0
               If (iAT2 .EQ. 0)iTST = 0
               If (iAT4 .EQ. 0)iTST = 0

               If (iTST .EQ. 1)Then

                  iCNT = iCNT + 1
                  OK = .TRUE.

                  If (NIDH .NE. 0)Then
                  DIDIHD(iCNT,1) = AIDHD(j,1)
                  DIDIHD(iCNT,2) = AIDHD(j,2)
                  DIDIHD(iCNT,3) = AIDHD(j,3)
                  LIDIHD(iCNT,1) = iAT1
                  LIDIHD(iCNT,2) = iAT2
                  LIDIHD(iCNT,3) = iAT3
                  LIDIHD(iCNT,4) = iAT4
                  EndIf

               EndIf

            EndIf
            EndIf
            EndDo

            If (.NOT. OK)Then

            !Search for next Case!
            !e.g. X-CT-CT-CT!

            Do j=1,NAIDH
            If (AIDHN(j,1) .EQ. 'X ' .AND. AIDHN(j,2) .NE. 'X ')Then
            If (AIDHN(j,3) .EQ. ATMT(i))Then

               !Find Atom 4 and 2!

               iAT4 = 0
               iAT2 = 0
               iAT1 = 0

               Do k=1,NNEIGH(i)

                  m = LNEIGH(i,k)

                  If (iAT4 .EQ. 0 .AND. iAT2 .NE. m)Then
                  If (AIDHN(j,4) .EQ. ATMT(m))iAT4 = m
                  EndIf

                  If (iAT2 .EQ. 0 .AND. iAT4 .NE. m)Then
                  If (AIDHN(j,2) .EQ. ATMT(m))iAT2 = m
                  EndIf

               EndDo

               iTST = 1
               If (iAT4 .EQ. 0)iTST = 0
               If (iAT2 .EQ. 0)iTST = 0

               If (iTST .EQ. 1)Then

                  Do k=1,NNEIGH(i)
                  m = LNEIGH(i,k)
                  If (m .NE. iAT4 .AND. m .NE. iAT2)iAT1 = m
                  EndDo

                  iCNT = iCNT + 1
                  OK = .TRUE.

                  If (NIDH .NE. 0)Then
                  DIDIHD(iCNT,1) = AIDHD(j,1)
                  DIDIHD(iCNT,2) = AIDHD(j,2)
                  DIDIHD(iCNT,3) = AIDHD(j,3)
                  LIDIHD(iCNT,1) = iAT1
                  LIDIHD(iCNT,2) = iAT2
                  LIDIHD(iCNT,3) = iAT3
                  LIDIHD(iCNT,4) = iAT4
                  EndIf

               EndIf

            EndIf
            EndIf
            EndDo

            EndIf

            If (.NOT. OK)Then

            !Search for the last Possibility!
            !e.g. X-X-CT-CT!

            Do j=1,NAIDH
            If (AIDHN(j,1) .EQ. 'X ' .AND. AIDHN(j,2) .EQ. 'X ')Then
            If (AIDHN(j,3) .EQ. ATMT(i))Then

               !Find Atom 4!

               iAT4 = 0
               iAT2 = 0
               iAT1 = 0

               Do k=1,NNEIGH(i)

                  m = LNEIGH(i,k)

                  If (iAT4 .EQ. 0)Then
                  If (AIDHN(j,4) .EQ. ATMT(m))iAT4 = m
                  EndIf

               EndDo

               iTST = 1
               If (iAT4 .EQ. 0)iTST = 0

               If (iTST .EQ. 1)Then

                  Do k=1,NNEIGH(i)

                     m = LNEIGH(i,k)

                     If (iAT4 .NE. m)Then
                     If (iAT1 .EQ. 0 .AND. iAT2 .NE. m)iAT1 = m
                     If (iAT2 .EQ. 0 .AND. iAT1 .NE. m)iAT2 = m
                     EndIf

                  EndDo

                  iCNT = iCNT + 1
                  OK = .TRUE.

                  If (NIDH .NE. 0)Then
                  DIDIHD(iCNT,1) = AIDHD(j,1)
                  DIDIHD(iCNT,2) = AIDHD(j,2)
                  DIDIHD(iCNT,3) = AIDHD(j,3)
                  LIDIHD(iCNT,1) = iAT1
                  LIDIHD(iCNT,2) = iAT2
                  LIDIHD(iCNT,3) = iAT3
                  LIDIHD(iCNT,4) = iAT4
                  EndIf

               EndIf

            EndIf
            EndIf
            EndDo

            EndIf

         EndIf
         EndDo

         If (NIDH .EQ. 0)Then
         If (iCNT .EQ. 0)Then
         Write(*,*)'ERROR: NO IMP DIHEDRALS?? SOMETHING IS STRANGE'
         Write(*,*)'CHECK SETUPPARAMS.F90'
         Stop
         EndIf
         NIDH = iCNT
         Goto 4
         EndIf

         !FIND 1-4 PAIRS!

         N14 = 0

         Do i=1,NDH

            iAT1 = LDIHD(i,1)
            iAT4 = LDIHD(i,4)

            OK = .TRUE.

            Do j=i,NDH
            If (i .NE. j)Then

               If (iAT1 .EQ. LDIHD(j,1))Then
               If (iAT4 .EQ. LDIHD(j,4))OK = .FALSE.
               EndIf

               If (iAT1 .EQ. LDIHD(j,4))Then
               If (iAT4 .EQ. LDIHD(j,1))OK = .FALSE.
               EndIf

            EndIf
            EndDo

            !Check for pentagonal rings!

            Do j=1,NAG

               If (iAT1 .EQ. LANGL(j,1))Then
               If (iAT4 .EQ. LANGL(j,3))OK = .FALSE.
               EndIf

               If (iAT1 .EQ. LANGL(j,3))Then
               If (iAT4 .EQ. LANGL(j,1))OK = .FALSE.
               EndIf

            EndDo

            If (OK)N14 = N14 + 1

         EndDo

         Allocate (L14(N14,2))

         iCNT = 0

         Do i=1,NDH

            iAT1 = LDIHD(i,1)
            iAT4 = LDIHD(i,4)

            OK = .TRUE.

            Do j=i,NDH
            If (i .NE. j)Then

               If (iAT1 .EQ. LDIHD(j,1))Then
               If (iAT4 .EQ. LDIHD(j,4))OK = .FALSE.
               EndIf

               If (iAT1 .EQ. LDIHD(j,4))Then
               If (iAT4 .EQ. LDIHD(j,1))OK = .FALSE.
               EndIf

            EndIf
            EndDo

            !Check for pentagonal rings!

            Do j=1,NAG

               If (iAT1 .EQ. LANGL(j,1))Then
               If (iAT4 .EQ. LANGL(j,3))OK = .FALSE.
               EndIf

               If (iAT1 .EQ. LANGL(j,3))Then
               If (iAT4 .EQ. LANGL(j,1))OK = .FALSE.
               EndIf

            EndDo

            If (OK)Then
            iCNT = iCNT + 1
            L14(iCNT,1) = LDIHD(i,1)
            L14(iCNT,2) = LDIHD(i,4)
            EndIf

         EndDo

         !FIND EXCLUDED PAIRS!

         NEX = NBD + NAG

         Allocate (LEX(NEX,2))

         Do i=1,NBD
         LEX(i,1) = LBOND(i,1)
         LEX(i,2) = LBOND(i,2)
         EndDo

         j = NBD

         Do i=1,NAG
         LEX(i+j,1) = LANGL(i,1)
         LEX(i+j,2) = LANGL(i,3)
         EndDo


         !NOW FINISH BY SETTING UP MOLECULE FILE!

         NMOL = 0

         Allocate(MOLN(NAT),MTYPE(NAT))

         Do i=1,NRES

            If (IRES(i) .LT. 0)NMOL = NMOL + 1

            j = Iabs(IRES(i))

            If (i .NE. NRES)Then
            k = Iabs(IRES(i+1)) - 1
            Else
            k = NAT
            EndIf

            Do m=j,k
            MOLN(m) = NMOL
            MTYPE(m) = 'A'
            EndDo

         EndDo

      Return

      End Subroutine
