! Subroutine: TwoCoord
! Purpose: Checks to make sure that a set of atoms are Two Coordinated
! Written: April 24th 2006
! Last Update: April 24th 2006
! Author: Eric Dykeman

! NOTES: VARIABLES
!            RC - (3) Center Atom Coordinates
!            R1 - (3) 1st attached atom
!            R2 - (3) 2nd attached atom
!
!        DEPENDANCIES
!

! **********************************************************************

      Subroutine TwoCoord (RC,R1,R2)

         Implicit None

      !Variable Declaration!

         Double Precision, Intent (InOut) :: RC,R1,R2

         Dimension RC(3),R1(3),R2(3)

      !Local Variables!

         Double Precision A,B,X,R12,VEC
         Double Precision RBOND,THETA
         Integer i,N,LIST

         Dimension R12(3),VEC(3),LIST(2)

      !ROUTINE!

         RBOND = 1.0d0      !Default H-? Bond Distance!
         THETA = 2.0944d0   !Default Angle in Radians!

         !First Find Troubled Atoms ... Located at (0,0,0)!

         Do i=1,2
         LIST(i) = 0
         EndDo

         If (R1(1) .EQ. 0.0d0 .AND. R1(2) .EQ. 0.0d0 &
           & .AND. R1(3) .EQ. 0.0d0)LIST(1) = 1

         If (R2(1) .EQ. 0.0d0 .AND. R2(2) .EQ. 0.0d0 &
           & .AND. R2(3) .EQ. 0.0d0)LIST(2) = 1

         !Find Number of Bad atoms!

         N = 0
         Do i=1,2
         N = N + LIST(i)
         EndDo

         !Very RARE possability!

         If (N .EQ. 2)Then
         LIST(1) = 0
         N = 1
         EndIf

         !Fix Hydrogen. Do this by moving along RC-R? Bond!
         !Then At an angle of 120 degrees!

         If (N .EQ. 1)Then

            If (LIST(1) .EQ. 1)Then

               Do i=1,3
               R12(i) = RC(i) - R2(i)
               EndDo

            Else

               Do i=1,3
               R12(i) = RC(i) - R1(i)
               EndDo

            EndIf

            X = R12(1)**2 + R12(2)**2 + R12(3)**2
            X = 1.0d0/Dsqrt(X)

            Do i=1,3
            R12(i) = R12(i)*X
            EndDo

            !Find A perpendicular vector to R12!

            Do i=1,3
            VEC(i) = 0.0d0
            EndDo

            If (R12(1) .NE. 0.0d0)Then

               VEC(3) = 1.0d0

            ElseIf (R12(2) .NE. 0.0d0)Then

               VEC(3) = 1.0d0

            Else

               VEC(2) = 1.0d0

            EndIf

            !Remove any component along R12 and Normalize!

            X = 0.0d0
            Do i=1,3
            X = X + VEC(i)*R12(i)
            EndDo

            Do i=1,3
            VEC(i) = VEC(i) - X*R12(i)
            EndDo

            X = 0.0d0
            Do i=1,3
            X = X + VEC(i)*VEC(i)
            EndDo
            X = 1.0d0/Dsqrt(X)

            Do i=1,3
            VEC(i) = VEC(i)*X
            EndDo

            !Calculate A and B!

            B = -RBOND*Cos(THETA)
            A = RBOND**2 - B*B
            A = DSqrt(A)

            If (LIST(1) .EQ. 1)Then

               Do i=1,3
               R1(i) = RC(i) + A*VEC(i) + B*R12(i)
               EndDo

            ElseIf (LIST(2) .EQ. 1)Then

               Do i=1,3
               R2(i) = RC(i) + A*VEC(i) + B*R12(i)
               EndDo

            EndIf

         EndIf

         Return

      End Subroutine
