! 10. Controlling Program Flow.				   File: control10.f90
!------------------------------------------------------------------------------!

PROGRAM blockif
	IMPLICIT NONE

	! example: protecting against zero divisors

	! declarations
	INTEGER :: numerator, denominator, quotient

	! inputs
	PRINT *, 'Numerator (integer please)?'
	READ *, numerator
	PRINT *
	PRINT *, 'Denominator (integer please) ?'
	READ *, denominator
	PRINT *

	IF (denominator == 0) THEN
		PRINT *, 'Sorry - I can''t divide by zero!'
		STOP
	ELSE
		quotient = numerator / denominator
	ENDIF

	PRINT *, 'Quotient is ', quotient

END PROGRAM blockif


!! 1.	The above is an example of a program using the `block IF' statement.
!!	Note that the whole IF...THEN...ELSE...ENDIF structure contains two
!!	main clauses: the IF...THEN clause, telling what to do if the logical
!!	expression (denominator == 0) is .TRUE. ; and the ELSE...ENDIF clause 
!!	telling what to do if the logical expression is .FALSE. . The telling
!!	what to do part consists of a `block of statements'.

!! 2.	The general Fortran syntax for a block IF statement is
!!
!!		IF (logical expression) THEN
!!			statement-block 1
!!		ELSE
!!			statement-block 2
!!		END IF
!!
!!	Notes:
!!	i) parenthesis required around the logical expression
!!	ii) each statement block consists of zero or more statements
!!	iii) although not required by Fortran, it is good practice to indent
!!	the statement blocks: your code should be easy to read.

!! 3.	The STOP statement
!!
!!	This is useful when you wish to stop the execution of a program at a
!!	point other than at the END statement. When STOP is executed, it 
!!	halts the run completely.

!! 4.	Programming concepts.
!!
!!	It is worthwhile at this stage to pause and take stock of the general
!!	aspects of what you have seen exhibited in the programs so far and what
!!	you are about to encounter.
!!
!!	Computers perform only 4 basic operations:
!!
!!		* input/output operations
!!		* arithmetic operations
!!		* movement of data operations
!!		* comparison/branch operations
!!
!!	Any instruction in any language consists of one or more of these 4 basic
!!	operations. The skill (art/science?) of programming is in decomposing a
!!	given problem into these simple operations. These are the bricks from
!!	which more complex structures will be built. Divide and conquer!
!!
!!	It can be proved that any program comprises only three processes:
!!
!!		* sequence
!!		* choice
!!		* repetition
!!
!!	Computers execute instructions in sequence unless told to do otherwise.
!!	(In fact, nowadays, there are computers which can execute instructions 
!!	in parallel; this need not concern us here.) The program above  
!!	illustrates sequence and choice. However the real ability of a computer 
!!	is to repeat a group of instructions time and again at high speed. 
!!	We will meet this shortly when we discuss LOOPS.
!!
!!	Program planning: There is a maxim in programming to the effect that the
!!	sooner you code, the longer it takes to program. In other words, the 
!!	more thought that goes into the planning and design of the program, the 
!!	easier and more quickly the program can be coded CORRECTLY!
!!
!!	Pseudocode: We will adopt a `top-down' method of program design in which
!!	complex programming tasks are first broken down into smaller tasks. This
!!	will continue until we have units which are easily programmed. Such 
!!	plans are written in a quasi-English quasi-Fortran language which will 
!!	allow us to describe the overall structure of the program to be written
!!	without having to worry about the detailed syntax etc. . That will 
!!	follow once the structure is established.
!!
!!	DIVIDE AND CONQUER!

!! 5.	Pseudocode for the above program.
!!
!!	Writing, in plain English, the actions to be performed we can say
!!
!!		If the denominator is zero, then
!!			print an error message and stop the program
!!		otherwise
!!			divide the numerator by the denominator and
!!			place the quotient in a variable called quotient
!!
!!	The pseudocode version of this would be
!!
!!		IF denominator = 0 THEN
!!			DISPLAY 'Sorry - I can't divide by zero!'
!!		ELSE
!!			quotient = numerator/denominator
!!		END IF
!!
!!	Pseudocode comes into its own when the CONTROL STRUCTUREs involved in
!!	the program become complex, not for simple programs (or blocks of 
!!	statements) sequentially executed.

!! 6.	The sequence of steps taken to solve a given problem is often called an
!!	`algorithm'. These are generally designed to be general in nature; why
!!	bother to write such a program if it were not - a one-off specific 
!!	calculation would suffice. We could describe the design phases for 
!!	solving the problem to be
!!
!!		1. State the problem clearly
!!		2. Describe the input and output
!!		3. Work the problem by hand for a specific simple set of data
!!		4. Develop an algorithm that is general in nature
!!		5. Test the algorithm with a variety of data sets
!!
!!	We will use a set of standard structures to describe algorithms. Each 
!!	structure will be descibed in terms of pseudocode. The three major 
!!	structures are 
!!
!!		1. SEQUENCE
!!		2. IF THEN ELSE
!!		3. DO loop
!!
!!	These are just the three program processes mentioned before: sequence,
!!	choice, repetition. The first two we have now met in previous sections, 
!!	the third we have yet to meet.

!! 7.	Exercise:
!!
!!	Problem: input a value of x (real number) between 0.0 and 1.0 and
!!	arrange for an error message to be displayed if a value outside this
!!	range is entered. 
!!	[Protecting a program from illegal inputs is called BULLETPROOFING 
!!	or ERROR-TRAPPING, insulation against the idiots or careless of this 
!!	world. We all fall into these categories at some time or other.] 
!!	If in range then just have it printed out again, suitably identified.
!!
!!	Pseudocode program:
!!
!!	DISPLAY		'Input value of x between 0 and 1'
!!	READ		x
!!	IF  x lies between 0.0 and 1.0  THEN
!!		print x
!!	ELSE
!!		DISPLAY  `out of range'
!!	ENDIF
!!
!!	Convert this into Fortran code and execute. Call the file bullet.f

!!	END OF FILE:	control10.f90

