! 11. Multiple Choices.					File: multiple11.f90
!------------------------------------------------------------------------------!

PROGRAM multiple
	IMPLICIT NONE

	! example of multiple alternative decisions: simultaneous equations
	! Input variables:
	! a1, b1, c1 	: coefficients of equation 1, a1*x+b1*y=c1
	! a2, b2, c2	: coefficients of equation 2, a2*x+b2*y=c2
	! Other variables:
	! delta		: determinant of coeffs of x,y = a1*b2-a2*b1
	! numx		: numerator in solution for x = numx/delta
	! numy		: numerator in solution for y = numy/delta
	! Output variables:
	! x,y		: point of intersection of lines if it exists

	! declarations
	REAL :: a1,b1,c1,a2,b2,c2,delta,numx,numy

	! inputs
	PRINT *
	PRINT *, 'This program finds the point of intersection of two '
	PRINT *, 'straight lines'
	PRINT * 
	PRINT *, 'input coefficients a1,b1,c1 of equation 1 : a1*x+b1*y=c1'
	READ *, a1,b1,c1
	PRINT *
	PRINT *, 'input coefficients a2,b2,c2 of equation 2 : a2*x+b2*y=c2'
	READ *, a2,b2,c2

	delta = a1*b2-a2*b1
	numx = b2*c1-b1*c2
	numy = a2*c1-a1*c2

	IF ( (ABS(numx) < 1.0E-10) .AND. (ABS(numy) .LT. 1.0E-10) ) THEN
		PRINT *, 'lines are coincident'
	ELSE IF (ABS(delta) .LT. 1.0E-10) THEN
		PRINT *, 'lines are parallel'
	ELSE
		PRINT *, 'lines intersect at '
		PRINT *
		PRINT *, '    x= ', numx/delta, ' y =  ',numy/delta
	ENDIF

END PROGRAM multiple

!! 1.	The general syntax of the Fortran 'block IF' IF...THEN...ELSE IF...
!!	ELSE...END IF STRUCTURE:
!!
!!		IF (logical expression 1) THEN
!!			statement-block 1
!!		ELSE IF (logical expression 2) THEN
!!			statement-block 2
!!		....
!!		ELSE IF (logical expression n) THEN
!!			statement-block n
!!		ELSE
!!			statement-block n+1
!!		END IF
!!
!!	Notes:
!!		At most one block will be executed, but never more than one.
!!		There must always be an IF...THEN clause; there can be zero 
!!		or more ELSE IF clauses; there can be zero or ONE clause.
!!		One can write ELSEIF and ENDIF, leaving the spaces out.

!! 2.	The single alternative decision.
!!
!!	This is included within $1. above when no action is required if the 
!!	logical expression is false. Then the ELSE may be omitted completely..
!!	The syntax is
!!
!!		IF (logical expression) THEN
!!			statement-block
!!		ENDIF

!! 3.	The logical IF statement
!!
!!	This is exactly equivalent to the single alternative decision but where 
!!	there is only ONE statement. Its syntax is 
!!
!!		IF (logical expression) Fortran90_statement
!!

!! 4.	Exercises:
!!
!!	a) Write a program, first in pseudocode and then in Fortran, using 
!!	the single alternative decision, to calculate the absolute value of 
!!	a real number (without using the ABS intrinsic function).
!!
!!	b) State in a few words what the following program would do
!!
!!	PROGRAM hot
!!		IMPLICIT NONE
!!
!!		REAL :: temp
!!
!!		PRINT *, 'What''s the Celsius temperature?'
!!		READ *, temp
!!
!!		IF ( temp > 1550.0 ) THEN
!!			PRINT *, 'I need an air conditioner!!!!'
!!		ELSE IF ( temp >= 1475.0 ) THEN
!!			PRINT *, 'My sword just melted!!!'
!!		ELSE IF ( temp >= 1100.0 ) THEN
!!			PRINT *, 'My pennies just melted!!'
!!		ELSE IF ( temp >= 275.0 ) THEN
!!			PRINT *, 'That would melt solder!'
!!		ELSE
!!			PRINT *, 'So what?'
!!		END IF
!!
!!	END PROGRAM hot
!!
!!	Copy this program and execute it using inputs which would give each of
!!	the possible outputs.
!!
!!	(c) If the lengths of the sides of a triangle are a,b, and c, then 
!!	the area of the triangle can be computed from Heron's formula, which is
!!
!!			area = square root of s(s-a)(s-b)(s-c)
!!
!!	where s is one half the sum of the lengths of the sides of the triangle.
!!	Write pseudocode and Fortran programs that asks for and READs the 
!!	lengths of the three sides, then determines whether those three sides
!!	can form a triangle. If they can, the program should display the area. 
!!	If not, it should say they do not form a triangle.
!!
!!	(d) Computers are constructed from logic circuits - electronic circuits
!!	that act out logical operations. One such circuit is called TTL, the 
!!	transistor-transistor logic. In such circuitry, a positive voltage 
!!	greater than a certain threshold value is regarded as symbolizing the
!!	logical value TRUE, while a voltage that is essentially zero is regarded
!!	as symbolizing the logical value FALSE. On the other hand, there is a 
!!	maximum allowable voltage above which the integrated circuits will be 
!!	destroyed. One standard manual categorizes the voltage levels as follows
!!
!!		Above +5.5 volts 		Not allowed
!!		+2.0<=voltage<=+5.5 volts	Logic TRUE
!!		+0.8<voltage<+2.0 volts		Logic value undefined
!!		0.0<=voltage<=+0.8 volts	Logic FALSE
!!		Below 0.0volts			Not allowed
!!
!!	Write a Fortran program that asks for and receives from the keyboard 
!!	a voltage (a real number), and then calculates and displays the 
!!	significance of that voltage according to the above table.
!!
!!	(e) Write a block IF structure to determine and display in which 
!!	quadrant a given real ANGLE lies. Allow for input specified in 
!!	either degrees or radians.

!! 	END OF FILE:	multiple11.f90
