! 1. An Introductory Program.				File: read1.f90
!------------------------------------------------------------------------------!

PROGRAM polynomial
	IMPLICIT NONE

	! This program evaluates a given polynomial for a value of x 
	! which is read in as input

	! Variable declarations
	REAL :: x, poly

	! Step 1: inputs
	PRINT*, " This program evaluates a given polynomial "
	PRINT*, " for a value of x specified by the user"
	PRINT*
	PRINT*, "Specify the value of x"
	READ*, x				! Specify the value of x

	! Step2: evaluate polynomial
	poly = 2.0*x**4 - 15.0*x**3 -2.0*x**2 + 120.0*x -130.0

	! Step3: outputs
	PRINT*, "For x= ",x, "the value of the polynomial is ",poly

END PROGRAM polynomial


!! 1.	Convention used in these sessions: all comments following a DOUBLE 
!!	exclamation are explanatory and are NOT part of the program proper.

!! 2.	COMMENTS. A "!" appearing anywhere in a line of a Fortran program 
!!	causes the rest of that line to be ignored as far as the program 
!!	is concerned. If it appears at the start of a line then the whole 
!!	line is ignored. Comments should always be included to help you 
!!	follow the program logic more easily. It is good programming practice 
!!	to be liberal in the use of comments.

!! 3.	FORTRAN FILES: all FORTRAN files must have the extension  '.f90'. 
!!	This program is called  read1.f90

!! 4.	Use indentation (the Tab key) to give visual structure to programs.
!!	When we begin to write more complex programs you will see how this 
!!	helps to make programs more readable.
 
!! 5.	The Fortran character set consists of  
!!			
!!			the 26 uppercase letters  A - Z
!!			the 10 digits  0 -9
!!			the 5 arithmetic symbols  + - * / **
!!			the 17 special characters  =(),.$':!%"&;<>?_
!!			and the space, or blank.
!!
!!	Only these characters may be used in Fortran programs.
!!
!!	Fortran treats lower case letters identically to uppercase letters. 
!!	However, again to improve readability, it is a common convention to 
!!	write Fortran KEYWORDS in uppercase and use lower case letters 
!!	otherwise. The only exception to this is anything enclosed within 
!!	apostrophes or quotation marks where the ordinary conventions apply
!!	and other keyboard characters not in the Fortran character set may 
!! 	be used.

!! 6.	The above program is an example of a "main program" or "main program 
!!	unit". Let us examine it line by line. 
!!
!!	PROGRAM polynomial
!!
!!	Every program must start with a PROGRAM statement which consists of 
!!	the word PROGRAM followed by a program name. The name must begin with 
!!	a letter, may only contain the letters A-Z, a-z, digits 0-9, or the 
!!	underscore character _, and consist of no more than 31 characters.
!!	
!!	IMPLICIT NONE
!!
!!	ALWAYS include this statement immediately after the PROGRAM statement.
!!	It is present for historical reasons. 
!!
!!	! ... Comment lines - see above.
!!
!!	REAL :: x, poly
!!
!!	This is a specification statement which declares to the compiler that 
!!	the variables "x" and "poly" are to be stored as REAL numbers. All 
!!	variables MUST be declared at the beginning of a program. 
!!	x and poly are Fortran variables and are ,in some sense, analogous to 
!!	those in algebra. But they are NOT the same. A Fortran variable is a 
!!	named memory cell where values are stored. As such, they may be 
!!	configured to hold different kinds of data, such as integers, real 
!!	numbers, characters, etc. The purpose then of the REAL statement is 
!!	to identify which of these types the variables x and poly are 
!!	(here they are real numbers).
!!
!!	PRINT*, "....."
!!
!!	These are the first executable statements in the program. They cause 
!!	the text between the quotes to be output to the standard output device 
!!	(usually the screen). 
!!	The * specifies that printing will be performed using automatic 
!!	formatting, i.e. you do not have to specify the exact layout of the
!!	displayed line. Do not forget the  , after the *.
!!	The PRINT statement with no following text (and no comma) causes a 
!!	blank line to occur on the screen and is useful in separating 
!!	successive lines to make the output more readable.
!!
!!	READ*, x	! Specify the value of x
!!
!!	This is one way to give a value to a variable. The READ statement 
!!	suspends execution of the program as it waits for data from some input
!!	device. The * indicates that the input is to come from the standard 
!!	input device (usually the keyboard), and give that value to the variable
!!	x named in the READ after the , . The * also indicates that the number 
!!	may be written in any convenient form.
!!
!!	poly = 2.0*x**4 - 15.0*x**3 -2.0*x**2 + 120.0*x -130.0
!!
!!	This is an assignment statement. It causes the expression to the right 
!!	of the "=" sign to be evaluated and the answer to be assigned to the 
!!	variable named on the left. Any value which that variable had before 
!!	this operation is overwritten and lost. The form of all assignment 
!!	statements is
!!
!!		variable_name = expression to be evaluated
!!
!!	Our expression involved the variable x and several Fortran constants, 
!!	2.0, 15.0, 120.0, 130.0, whose values cannot change during the 
!!	execution of a program. These are real constants and are 
!!	distinguishable from integer constants such as 2, 4, 153 .
!! 
!!	A variable name follows the same rules as the PROGRAM name, i.e. it
!!	must begin with a letter, may only contain the letters A-Z, a-z, 
!!	digits 0-9, or the underscore character _, and consist of no more 
!!	than 31 characters, e.g.
!!			x, poly, term1, first_coefficient_of_polynomial
!!
!!	Arithmetic operations:
!!
!!	It is obvious what the + and - signify. The * indicates multiplication,
!!	while / indicates division (not used in this example). The double 
!!	asterisk ** means 'raise to a power' (exponentiation).
!!	Note that all operations must be explicitly shown!!! Blank spaces in 
!!	Fortran are almost never of any significance. They may be used to 
!!	improve the look or readability of the program.
!!
!!	PRINT*, "For x= ",x, "the value of the polynomial is ",poly
!!
!!	The value of poly is output to the screen. Note how text and the 
!!	actual values of x, poly are output to screen.
!!
!!	END PROGRAM polynomial
!!
!!	The final statement of a program must be an END statement.

!! 7.	Main program unit structure:
!!
!!		PROGRAM name
!!			IMPLICIT NONE
!!			Specification statements
!!			...
!!			Executable statements
!!			...
!!		END PROGRAM name
!! 
!!	This order must be adhered to.

!! 8.	The compilation of a Fortran program:
!!
!!	The Fortran program which is written above is known as Fortran `source 
!!	code'. The computer does not understand this high level language. You 
!!	must submit your Fortran source code to a program called the Fortran 
!!	compiler to be translated into `object code' (machine language 
!!	instructions) which your computer will understand. The object code is 
!!	a complete translation into machine language of your source code. 
!!
!!	The compiler also diagnoses your Fortran code for mistakes and possibly
!!	displays error messages telling you what needs to be corrected. You 
!!	must then go back to the editor and correct these mistakes before 
!!	submitting your program once again to the compiler. This is the 
!!	`compile-edit' cycle. When all mistakes have been corrected, you have 
!!	the executable code.
!!
!!	To compile the above program type
!!
!!			f90 read1.f90
!!
!!	This will create an "executable" file called "a.out". To execute the 
!!	file, type
!!
!!			a.out
!!
!!	The program starts to run but will suspend at the read statement where
!!	it expects you to input some value for x. Type a real number, e.g. 3.0
!!	The execution proceeds and finally outputs to the screen what is 
!!	instructed by the PRINT statement.

!! 9.	Exercises 1
!!
!!	a) Make a copy of the above program, giving it the filename  ex1.f90
!!	b) Delete all the comment lines beginning with a !! 
!!	c) Edit the file to include a second fourth order polynomial, poly2,
!!	   which is  (x*x-1.0)**2
!!	   Insert a statement to calculate the ratio of the two polynomials  
!!			ratio =	poly/poly2
!!	d) Adapt the print statement appropriately
!!	e) Compile and execute the program for values of x=0.0, 0.5, 1.0
!!	   What happens when x=1.0?
!!
!!	You will undoubtedly make errors in editing your files. The compiler 
!!	will identify most of these. Do not worry if you make lots of them: 
!!	through these errors you will learn all the more rapidly (I hope).

!! 10.	Now read Chapter 1 and 2 of the textbook (Ellis et al.)

!! 	End of file: read1.f90
