
MODULE pie
	IMPLICIT NONE

	! this is a program unit called a MODULE which makes available 
	! constants and variables (in this case only pi) for USE in other 
	! program units where needed

	! constant declarations
	REAL :: pi = 3.1415926

END MODULE pie


MODULE circle_properties
	USE pie	     ! makes pi available to all program units in this module
	IMPLICIT NONE

	! the second use of a module is to CONTAIN or encapsulate groups of 
	! related program units. This is done for organisational, checking 
	! and security reasons. Here we contain two external functions within 
	! the module circle_properties; each function requires knowledge of pi 
	! which is made available from the module pi

CONTAINS

	REAL FUNCTION area(r)
		IMPLICIT NONE

		!declarations
		REAL, INTENT(IN) :: r

		area = pi*r*r

	END FUNCTION area

	REAL FUNCTION circumference(r)
		IMPLICIT NONE

		!declarations
		REAL, INTENT(IN) :: r

		circumference = 2.0*pi*r

	END FUNCTION circumference

END MODULE circle_properties

PROGRAM circle_10
	USE circle_properties
	IMPLICIT NONE

	! this main program unit uses the module circle_properties. Note how 
	! simple it is.
	! the main program must appear after modules.

	! declarations
	REAL :: r

	! inputs
	PRINT *, 'This program calculates the area and circumference of '
	PRINT *, 'a circle of specified radius'
	PRINT *
	PRINT *, 'Specify the radius r'
	READ *, r
	PRINT *

	!outputs
	PRINT *, 'Radius 	= ',r
	PRINT *, 'Area   	= ',area(r)
	PRINT *, 'Circumference = ',circumference(r)

END PROGRAM circle_10
