
PROGRAM external_function_7
	IMPLICIT NONE

	! This program demonstrates an external function i.e. one created
	! by the user

	! declarations
	REAL :: x,y,z,distance
	REAL, EXTERNAL :: my_function

	! inputs
	PRINT *,'Enter the x,y and z coordinates of your position in metres'
	READ *, x,y,z

	! example of external function 'my_function'
	distance = my_function(x,y,z)

	! outputs
	PRINT *,'Your distance from the origin is ', distance,' metres'

END PROGRAM external_function_7

REAL FUNCTION my_function(x,y,z)
	IMPLICIT NONE

	! This function evaluates the distance from the origin to (x,y,z)

	! declarations. Note the INTENT(IN) attribute for x,y,z. This 
	! means that x,y,z values must be supplied to the function before 
	! it can be evaluated 
	REAL, INTENT(IN) :: x,y,z

	my_function = SQRT( x*x + y*y + z*z )

END FUNCTION my_function
