
PROGRAM subroutine_8
	IMPLICIT NONE

	! A basic idea in programming is to think 'modular' and to divide 
	! programs into small (but not too small) manageable units: 
	! 'subprograms' either as functions or, as here, subroutines.

	! This program illustrates the use of a subroutine to translate
	! rectangular coordinates into polar coordinates

	! declarations
	REAL :: x,y
	REAL :: r,theta

	! inputs
	PRINT *, 'enter the x and y coordinates'
	READ *, x,y

	! a call to a subroutine
	CALL polar_coords(x,y,r,theta)

	! outputs
	PRINT *,'Polar coordinates are: (',r,',',theta,')'

END PROGRAM subroutine_8


SUBROUTINE polar_coords(x,y,r,theta)
	IMPLICIT NONE

	! Note the arguments in the subroutine call. The number of these, 
	! their type plus the subroutine name form the INTERFACE of the 
	! subroutine. 

	! This subroutine translates rectangular coordinates into polar

	! declarations. Now note that r, theta have the INTENT(OUT) attribute
	! This means that these variables can only be used to output values 
	! calculated within the subroutine. Much of this is to do with 
	! security: although you are not aware of it, the compiler carries out
	! many checks on your programs. Errors will be reported to you.
	REAL, INTENT(IN) :: x,y
	REAL, INTENT(OUT) :: r,theta

	r = SQRT( x*x + y*y )
	theta = ATAN( y/x )

END SUBROUTINE polar_coords
