! 16. Array Input and Output.				File: arrayio16.f90
!------------------------------------------------------------------------------!

MODULE section
	IMPLICIT NONE
CONTAINS
	SUBROUTINE item(number)

		! to interrupt program until you are ready for next section

		! declarations
		CHARACTER(LEN=1) :: yes
		INTEGER, INTENT(IN) :: number

		! item  
		PRINT *
		PRINT *, 'Are you ready for the next item?'
		PRINT *, 'If yes, type y'
		READ *, yes
		IF (yes /= 'y') THEN
			PRINT *,'...exiting the program.'
			STOP
		ELSE
			PRINT *
			PRINT *, 'Item ',number
			PRINT *
		END IF

	END SUBROUTINE item
END MODULE section


PROGRAM arrayio
	USE section
	IMPLICIT NONE

	! This program illustrates how to input and output arrays.
	! Run the following program and study carefully the following 
	! methods of reading data into and printing data out from arrays. 		
	INTEGER :: n,m
	INTEGER, PARAMETER :: nrows=2,ncols=3
	INTEGER, DIMENSION(nrows) :: x
	INTEGER, DIMENSION(ncols) :: y,z
	INTEGER, DIMENSION (nrows,ncols) :: array

	PRINT *
	PRINT *, 'This program illustrates various aspects of the input and '
	PRINT *, 'output of arrays. Execute the program item by item relating '
	PRINT *, 'results with the relevent program section.'
	PRINT *

	! item 1
	! reading in a vector
	PRINT *, 'Type in ',nrows, '  integers one after the other'
	READ *, x
	PRINT *

	PRINT *, 'Type in ',ncols, '  integers one after the other'
	READ *, y
	PRINT *

	! Note that all values may be typed on a single line (with
	! space or comma between) without a carriage return being needed.

	! output x,y
	PRINT *,'x = ', x
	PRINT *,'y = ', y

	! item 2
	! input and output of a 2D array
	CALL item(2)

	PRINT *, 'Type in elements of 2D array, column by column'
	PRINT *, 'array has ',nrows,' rows and ',ncols,' columns'
	PRINT *
	READ *, array
	PRINT *

	! output array column by column in one long string
	PRINT *, array
	PRINT *

	! output array in matrix format using implied DO
	DO n=1,nrows
		PRINT *, (array(n,m),m=1,ncols)	! this is the implied DO
	END DO

	! output array row by row using a nested implied DO
	! output appears as one long string
	PRINT *
	PRINT *, ( (array(n,m),m=1,ncols),n=1,nrows)
	PRINT *

	! input array row by row using implied DO
	PRINT *, 'Type in elements of 2D array, row by row'
	PRINT *, 'pressing RETURN after each row'
	PRINT *
	PRINT *, 'array has ',nrows,' rows and ',ncols,' columns'
	PRINT *
	DO n=1,nrows
		READ *, (array(n,m),m=1,ncols)	! this is implied DOloop
	END DO

	! print out array in matrix form 
	DO n=1,nrows
		PRINT *, (array(n,m),m=1,ncols)
	END DO

	! item 3
	! setting an initial value for a 1D array using 
	! the ARRAY CONSTRUCTOR (/...../)
	CALL item(3)

	x = (/1,2/)
	y = (/10,15,20/)
	! setting an initial value for a 1D array using an implied DO
	! expressions may be used in implied DOs
	z = (/(2*n-1,n=1,ncols)/)

	! output x,y,z
	PRINT *
	PRINT *, x
	PRINT *, y
	PRINT *, z

	! item 4
	! setting inital values for a 2D array using intrinsic function RESHAPE
	CALL item(4)

	array = RESHAPE( (/1,2,3,4,5,6/), (/nrows,ncols/) )

	! output array
	DO n=1,nrows
		PRINT *, (array(n,m),m=1,ncols)
	END DO

	! compare the output from each of the above. Recall the order in 
	! which arrays are stored in memory: first variable varying most 
	! rapidly.

END PROGRAM arrayio

!! 1.	The implied DOloop has the form
!!
!!		(List, Index = InitValueExpr, FinalValueExpr, IncrExpr )
!!
!!	which can be embedded in a READ, WRITE, or PRINT statement 
!!	where
!!	    List: list of constants, variables, arrays, array elements
!!		  and also nested implied DOloops.
!!	    Index = ... IncrExpr : as for other DOloops

!! 2.	Whole array input and output:
!!
!!	Remember that this will read from or write to arrays in the order 
!!	that elements are stored in the memory. 

!!	END OF FILE: arrayio16.f90.f

