! 5. Intrinsic Functions.				   File: intrinsic5.f90
!------------------------------------------------------------------------------!

PROGRAM intrinsic
	IMPLICIT NONE

	! this program illustrates the use of intrinsic functions

	! example: COMPLEX IMPEDANCE AND VOLTAGE WAVEFORM
	! Calculates impedance and voltage in an ac circuit with resistance, 
	! inductance, and capacitance in series, with a given peak voltage
	! and angular frequency (in radians)		

	! variable declarations
	! input variables
	REAL :: R		! Resistance in ohms
	REAL :: L		! Inductance in henrys
	REAL :: C		! Capacitance in farads
	REAL :: omega		! Angular frequency in radians/sec
	REAL :: Vmax		! Peak voltage in volts
	REAL :: t		! Time of measurement in seconds
	! result variables
	COMPLEX :: Z		! Impedance in ohms
	COMPLEX :: Voltage	! Voltage at time t

	! intrinsic functions used
	REAL, INTRINSIC :: CMPLX, SIN, COS

	! inputs
	PRINT *,'This program calculates '
	PRINT *
	PRINT *,'   (a) the complex impedance for a specified resistance,& 
			& inductance and capacitance'
	PRINT *
	PRINT *,'   (b) the complex voltage at a given time t for a &
			&specified  peak voltage'
	PRINT *
	PRINT *, 'Specify the Resistance(ohms), Inductance(henrys), and& 
		&  Capacitance(farads)?'
	PRINT *
	PRINT *, '<Capacitance must not be zero!>'
	PRINT *
	READ *, R, L, C
	PRINT *
	PRINT *, 'Angular frequency(radians/sec)=?'
	PRINT *
	READ *, omega
	PRINT *
	PRINT *, 'Peak voltage(volts)=?'
	PRINT *
	READ *, Vmax
	PRINT *
	PRINT *, 'Time(sec)=?'
	PRINT *
	READ *, t
	PRINT *

	! calculate impedance 
	Z = CMPLX( R, omega*L - 1.0 / (omega*C) )
	! calculate voltage at time t
	Voltage = CMPLX( Vmax*COS(omega*t),Vmax*SIN(omega*t) )

	! output
	PRINT *, 'Voltage is ', Voltage, ' volts'
	PRINT *
	PRINT *, 'Current is ', (Voltage / Z), ' amperes'
	PRINT *
	PRINT *, 'Impedance is ', Z, ' ohms'
	PRINT *

	END PROGRAM intrinsic

!! 1.	Applications frequently require common mathematical functions like
!!	square root, exponential, sin, cos etc.. Fortran provides these in 
!!	a LIBRARY of machine-code functions. These functions are invoked simply
!!	by writing their names with one or more arguments. Such functions are 
!!	called INTRINSIC FUNCTIONS. They are another kind of Fortran 'verb'. 

!! 2.	Consult Appendix A of the textbook for a complete list of intrinsic 
!!	procedures and their usage. Below is a list of the more commonly 
!!	used where n represents an integer, x,y represents real or integer 
!!	variables, and z represents complex,real or integer variables unless 
!!	otherwise stated:
!!	______________________________________________________________________
!!
!!	Function	Description		Type of	Result
!!	_______________________________________________________________________
!!
!!	ABS(z)		absolute value		same as z (real if z complex)
!!	SQRT(z)		square root		as z (if z real, z must be 
!!						non-negative; if z complex, 
!!						SQRT(z) has real part non-ve;
!!						if real part of SQRT(z)=0, 
!!						the imaginary part is non-ve)
!!	EXP(z)		e to power z		as z
!!	LOG(z)		natural log		as z; z non-zero
!!	LOG10(x)	log to base 10		x real positive
!!	SIN(z)		sine 			as z
!!	COS(z)		cosine			as z
!!	TAN(x)		tangent			real, x real
!!	ASIN(x)		arcsine			real
!!	ACOS(x)		arccosine		real
!!	ATAN(x)		arctangent		real
!!	SINH(x)		hyperbolic sine		real
!!	COSH(x)		hyperbolic cosine	real
!!	TANH(x)		hyperbolic tangent	real
!!
!!	REAL(n)		converts the integer 	real
!!			n to a real number
!!	CMPLX(x,y)	converts pair of real	complex
!!			numbers to complex
!!	AIMAG(z)	imaginary part of z	real, z complex
!!	
!!	HUGE(x)		largest number of the 	as x
!!			same type as x
!!	TINY(x)		smallest real number 	as x, x real only
!!	EPSILON(x)	smallest +ve number 	as x, x real only
!!			which is not ignored 
!!			when added to 1.0
!!	DIGITS(x)	number of significant 	as x
!!			digits in x
!!	INT(x)		real x, truncated and 	x real
!!			converted to integer
!!	NINT(x)		integer nearest to x	integer, x real
!!	
!!	CEILING(x)	least integer >=x	integer
!!	FLOOR(x)	greatest integer <=x	integer
!!	FRACTION(x)	fractional part of x	real
!!	MOD(x,y)	remainder of x/y	integer or real
!!	SIGN(x,y)	abs. value of x set	as x,y
!!			to the same sign as y

!! 3.	Examples:
!!
!!		discrm = SQRT( b**2 -4.0*a*c )
!!		v = ( 1.0 / COS(x) ) + LOG( ABS( TAN( x / 2.0 ) ) )
!!
!!	Note that we can insert spaces to make expressions more readable.
!!	Fortran ignores spaces.
!!	Also, long expressions are often more easily digested (although the
!!	compiler doesn't care) if they are broken up into smaller bites:
!!
!!		t = TAN(x/2.0)
!!		absvalue = ABS(t)
!!		v = 1.0/COS(x) + LOG(absvalue)

!! 4.	In the program you will notice an INTRINSIC declaration. Fortran does 
!!	not USUALLY require this.

!! 5.	Exercises 5.
!!
!!	a)Compile and execute the above program using as inputs:
!!
!!		R=10.0 , L=0.0 , C=40.0E-06
!!		omega=2500.0
!!		Vmax=500.0
!!		t=1.0
!!
!!	What are the outputs?
!!
!!	b) Write a program to convert Cartesian coordinates into spherical 
!!	polar coordinates (x = rSIN(theta)COS(phi),y = rSIN(theta)SIN(phi), 
!!	z = rCOS(theta); r = SQRT(x**2+y**2+z**2), theta = ACOS(z/r), and 
!!	phi = ATAN(y/x)
!!	Can you foresee any problems which might arise in these conversions?
!!
!!	c) The rate of emission of particles by a substance undergoing a 
!!	single type of radioactive decay is given by
!!
!!			r = r_0*EXP( - lambda*t )
!!
!!	where 	r	= rate of emission at time t
!!		r_0	= rate of emission at time 0
!!		lambda	= disintegration constant
!!		t	= time
!!		thalf	= half-life (= ln(2.0)/lambda)
!!
!!	Write a program to calculate r with thalf,r_0,t as inputs.

!! End of file: intrinsic5.f90
