! 12. Nesting of Block-IFs.				File: nest12.f90
!------------------------------------------------------------------------------!

PROGRAM nested
	IMPLICIT NONE

	! this program illustrates nested blockIF structures
	! example:  find the largest of three integers int1,int2,int3

	! declarations
	INTEGER :: int1, int2, int3, maximum

	! inputs
	PRINT *, 'This program determines the largest of three integers'
	PRINT *
	PRINT *, 'What are the three integers?'
	READ *, int1, int2, int3

	IF (int1 < int2 ) THEN
		IF (int2 < int3) THEN
			maximum = int3
		ELSE
			maximum = int2
		END IF
	ELSE
		IF (int1 < int3) THEN
			maximum = int3
		ELSE
			maximum = int1
		END IF
	END IF

	! output
	PRINT *
	PRINT *, 'The maximum is ', maximum

END PROGRAM nested

!! 1.	Such nesting of blockIFs may be continued to any level provided 
!!	each inner block is contained entirely within the outer block.
!!
!! 2.	Note that we did not use MAX for the variable name. This is because
!!	MAX is a Fortran intrinsic function and, although it is permitted, 
!!	is confusing and therefore bad practice.
!!
!! 3.	Exercise: a leap year program
!!
!!	The rule for leap years is
!!
!!		If a year is divisible by four, it is a leap year;
!!		but if it also divisible by 100, it is not a leap year
!!		unless it is also divisible by 400.
!!
!!	Divide and conquer! Develop pseudocode step by step:
!!
!!		IF year divisible by 4 THEN
!!			it might be a leapyear
!!		ELSE
!!			it definitely is not a leap year
!!		END IF
!!
!!	Now consider the part called 'it might be a leap year'
!!
!!		IF year not divisible by 100 THEN
!!			it is a leap year
!!		ELSE
!!			(it is divisible by 100)
!!			IF year divisible by 400 THEN
!!				it is a leap year
!!			ELSE
!!				it is not a leap year
!!			END IF
!!		END IF
!!
!!	We can now substitute this for 'it might be a leap year' to obtain:
!!
!!		IF year divisible by 4 THEN
!!			IF year not divisible by a 100 THEN
!!				it is a leap year
!!			ELSE
!!				(it is divisible by 100)
!!				IF year divisible by 400 THEN
!!					it is a leap year
!!				ELSE
!!					it is not a leap year
!!				END IF
!!			END IF
!!		ELSE
!!			it definitely is not a leap year
!!		END IF
!!
!!	Study carefully the overall structure. Now worry about how to discover
!!	whether a year is exactly divisible by 4 (or 100 or 400) without any
!!	remainder:
!!
!!	Since we are dealing with integers, integer division can be exploited.
!!	Call the divisor (one of 4,100,400) 'divisor'. Then dividing 'year' (an
!!	integer) by 'divisor' (an integer) discards any remainder. However, 
!!	this remainder may be found using the algorithm:
!!
!!			(year - (divisor*(year/divisor)))
!!
!!	The final pseudocode algorithm for checking for leap years is
!!
!!		IF (year - (4*(year/4))=0) THEN
!!			IF (year - (100*(year/100)) .NE. 0)  THEN
!!				it is a leap year
!!			ELSE
!!				{it's divisible by 100}
!!				IF (year - (400*(year/400))=0) THEN
!!					it's a leap year
!!				ELSE
!!					it's not a leap year
!!				END IF
!!			END IF
!!		ELSE
!!			it definitely isn't a leap year
!!		END IF
!!
!!	Now code the algorithm into a successful Fortran program.
!!
!!	The MOD function (a Fortran intrinsic function - see above) could also
!!	be usefully employed here.
!!
!!	[An alternative way of determining leap years is:
!!
!!		A year is a leap year if it is either
!!			divisible by 4 and not by 100
!!		or
!!			divisible by 400				]
!!
!! 	END OF FILE:	nest12.f90
