----------------------------------------------------------------------------------
-- Motor Control Logic
----------------------------------------------------------------------------------
library IEEE;
use IEEE.STD_LOGIC_1164.ALL;

entity logic is
Port ( 
	ctl_in_1_A  : in  STD_LOGIC;
	ctl_in_1_B  : in  STD_LOGIC;	
	sw_1_A 		: in  STD_LOGIC;
	sw_1_B      : in  STD_LOGIC;
		
	ctl_in_2_A  : in  STD_LOGIC;
	ctl_in_2_B  : in  STD_LOGIC;
	sw_2_A 		: in  STD_LOGIC;
	sw_2_B      : in  STD_LOGIC;
	
	ctl_in_3_A  : in  STD_LOGIC;
	
	ctl_out_1_A : out  STD_LOGIC;
	ctl_out_1_B : out  STD_LOGIC;
	ctl_out_2_A : out  STD_LOGIC;
	ctl_out_2_B : out  STD_LOGIC;
	ctl_out_3_A : out  STD_LOGIC	
	
	);
end logic;

architecture logic_arch of logic is
begin

	ctl_out_3_A <= ctl_in_3_A;
	
	logic_A: process( ctl_in_1_A, ctl_in_1_B, sw_1_A, sw_1_B )
	begin
		if ( ctl_in_1_A ='0' AND ctl_in_1_B = '1' AND sw_1_B = '0' ) or
		   ( ctl_in_1_A ='1' AND ctl_in_1_B = '0' AND sw_1_A = '0' )
		then
			ctl_out_1_A <= ctl_in_1_A;
			ctl_out_1_B	<= ctl_in_1_B;
		else
			ctl_out_1_A <= '0';
			ctl_out_1_B	<= '0';	
		end if;
	end process;
	
	logic_B: process( ctl_in_2_A, ctl_in_2_B, sw_2_A, sw_2_B )
	begin
		if ( ctl_in_2_A ='0' AND ctl_in_2_B = '1' AND sw_2_A = '0' ) or
		   ( ctl_in_2_A ='1' AND ctl_in_2_B = '0' AND sw_2_B = '0' )
		then
			ctl_out_2_A <= ctl_in_2_A;
			ctl_out_2_B	<= ctl_in_2_B;
		else
			ctl_out_2_A <= '0';
			ctl_out_2_B	<= '0';	
		end if;
	end process;	
		
end logic_arch;

