--------------------------------------------------------
-- Create Date:    22:39:09 06/15/2015 
-- Module Name:    clock_divider - clock_divider_arch 
--------------------------------------------------------
library IEEE;
use IEEE.STD_LOGIC_1164.ALL;

entity clock_divider is
Port ( 
   clk : in  STD_LOGIC;
   clr : in  STD_LOGIC;
   enable : out  STD_LOGIC);
end clock_divider;

architecture clock_divider_arch of clock_divider is

   signal counter : integer range 0 to 64 := 0;

begin

    freq_divider: process (clr, clk) 
    begin
        if (clr = '1') 
        then
            counter  <= 0;
        elsif rising_edge(clk) 
        then
            if (counter = 63) 
            then
                enable <= '1';
                counter  <= 0;
            else
                enable <= '0';
                counter <= counter + 1;
            end if;
        end if;
    end process;
    
end clock_divider_arch;
