----------------------------------------------------------------------------------
-- Create Date:    23:09:24 06/15/2015 
-- Module Name:    sensor - sensor_arch 
----------------------------------------------------------------------------------
library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
use IEEE.STD_LOGIC_UNSIGNED.ALL;

entity sensor is
    Port ( clk      : in  STD_LOGIC;
           clr      : in  STD_LOGIC;
           ce       : in  STD_LOGIC;
           start     : in  STD_LOGIC;
           echo     : in  STD_LOGIC;
           trig     : out STD_LOGIC;           
           distance : out STD_LOGIC_VECTOR (7 downto 0);
           valid    : out STD_LOGIC );
end sensor;

architecture sensor_arch of sensor is

   TYPE state IS (S0, S1, S2, S3, S4, S5, S6, S7);
   SIGNAL present_state, next_state: state;
   
   SIGNAL rx_count_rst : STD_LOGIC;
   SIGNAL rx_count_tc : STD_LOGIC;   
   SIGNAL rx_count : STD_LOGIC_VECTOR( 8 DOWNTO 0 );
   
   SIGNAL tx_count_rst : STD_LOGIC;
   SIGNAL tx_count_tc : STD_LOGIC;   
   SIGNAL tx_count : STD_LOGIC_VECTOR( 3 DOWNTO 0 );   
   
   SIGNAL distance_reg : STD_LOGIC_VECTOR (7 downto 0);
   SIGNAL distance_reg_en : STD_LOGIC;
   
begin

   distance <= distance_reg;

   tx_counter: PROCESS( clk, clr )
   BEGIN
      IF clr='1'
      THEN 
         tx_count <= (OTHERS => '0');
      ELSIF clk='1' and clk'event
      THEN
         IF tx_count_rst='1'
         THEN
            tx_count <= (OTHERS => '0');
         ELSIF ce='1'
         THEN
            tx_count <= tx_count + 1;
         END IF;
      END IF;
   END PROCESS;
   
   tx_terminal_count: PROCESS( tx_count )
   BEGIN
      IF tx_count="1111"
      THEN 
         tx_count_tc <= '1';
      ELSE
         tx_count_tc <= '0';   
      END IF;   
   END PROCESS;
   
   rx_counter: PROCESS( clk, clr )
   BEGIN
      IF clr='1'
      THEN 
         rx_count <= (OTHERS => '0');
      ELSIF clk='1' and clk'event
      THEN
         IF rx_count_rst='1'
         THEN
            rx_count <= (OTHERS => '0');
         ELSIF ce='1'
         THEN
            rx_count <= rx_count + 1;
         END IF;
      END IF;
   END PROCESS;
   
   rx_terminal_count: PROCESS( rx_count )
   BEGIN
      IF rx_count="111111111"
      THEN 
         rx_count_tc <= '1';
      ELSE
         rx_count_tc <= '0';   
      END IF;
   END PROCESS;   
   
   distance_register: PROCESS( clk, clr )
   BEGIN
      IF clr='1'
      THEN 
         distance_reg <= (OTHERS => '0');
      ELSIF clk='1' and clk'event
      THEN
         IF distance_reg_en='1'
         THEN
            distance_reg <= rx_count(8 downto 1);
         END IF;
      END IF;
   END PROCESS;
   
   reg: PROCESS( clk, clr )
   BEGIN
      IF clr='1'
      THEN
         present_state <= S0;
      ELSIF clk='1' and clk'event
      THEN
         present_state <= next_state;
      END IF;
   END PROCESS;
   
   comb: PROCESS( present_state, start, echo, rx_count_tc, tx_count_tc )
   begin
      rx_count_rst <= '0';
      tx_count_rst <= '0';   
      
      distance_reg_en <= '0';
      trig <= '0';
      valid <= '0';
      
      CASE present_state IS
         WHEN S0 =>
            rx_count_rst <= '1';
            tx_count_rst <= '1';   
            
            IF start='1'               -- wait for start signal
            THEN
               next_state <= S1;
            ELSE
               next_state <= S0;
            END IF;
         
         WHEN S1 =>
            rx_count_rst <= '1';
            tx_count_rst <= '1';   
         
            IF start='1'               -- wait for start signal to clear
            THEN
               next_state <= S1;
            ELSE
               next_state <= S2;
            END IF;         
         
         WHEN S2 =>
            rx_count_rst <= '1';
            trig <= '1';
            
            IF tx_count_tc='1'      -- wait for trigger pulse delay
            THEN
               next_state <= S3;   
            ELSE
               next_state <= S2;      -- otherwise wait
            END IF;   
            
         WHEN S3 =>                  -- wait for start of pulse or timeout
         
            --IF rx_count_tc='1' or echo='1'
            IF echo='1'
            THEN
               next_state <= S4;
            ELSE
               next_state <= S3;
            END IF;
   
         WHEN S4 =>                  -- reset rx counter
            rx_count_rst <= '1';
            next_state <= S5;
            
         WHEN S5 =>                  -- wait for end of pulse or timeout
         
            IF rx_count_tc='1' or echo='0'
            THEN
               next_state <= S6;
            ELSE
               next_state <= S5;
            END IF;   

         WHEN S6 =>                  -- update output register
            distance_reg_en <= '1';
            next_state <= S7;
   
         WHEN S7 =>
            valid <= '1';
            
            IF start='0'               -- wait for start signal to clear
            THEN
               next_state <= S0;
            ELSE
               next_state <= S7;
            END IF;   

         WHEN OTHERS =>
            next_state <= S0;   
      END CASE;
   END PROCESS;

end sensor_arch;
