----------------------------------------------------------------------------------
-- Create Date:    22:45:51 06/15/2015 
-- Module Name:    servo_control - Behavioral 
----------------------------------------------------------------------------------
library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
use IEEE.NUMERIC_STD.ALL;

entity servo_control is
port (
   clk : IN  STD_LOGIC;
   clr : IN  STD_LOGIC;
   ce  : IN  STD_LOGIC;
   pos : IN  STD_LOGIC_VECTOR(6 downto 0);
   servo : OUT STD_LOGIC );
end servo_control;

architecture servo_control_arch of servo_control is

   -- Counter, from 0 to 1279.
   signal cnt : unsigned(10 downto 0);
   
   -- Temporal signal used to generate the PWM pulse.
   signal pwmi: unsigned(7 downto 0);

begin
   -- Minimum value should be 0.5ms.
   pwmi <= unsigned('0' & pos) + 32;
    
   -- Counter process, from 0 to 1279.
   counter: process (clr, clk) 
   begin
      if (clr = '1') 
      then
         cnt <= (others => '0');
      elsif clk='1' and clk'event
      then
         if ce = '1'
         then
            if (cnt = 1279) 
            then
                cnt <= (others => '0');
            else
                cnt <= cnt + 1;
            end if;
        end if;
      end if;
    end process;
    
    -- Output signal for the servomotor.
    servo <= '1' when (cnt < pwmi) else '0';
    
end servo_control_arch;